/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductRejectTask;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;

public class CancelBookingRequestHotelProductAction
extends BaseProductAction<HotelProduct> {
    @Override
    protected String getName() {
        return Messages.CancelBookingRequestHotel;
    }

    @Override
    protected String getDescription() {
        return Messages.CancelBookingRequestHotel;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    public double getWeight() {
        return 40.0;
    }

    @Override
    public boolean isEnabled(HotelProduct hotelProduct) {
        if (hotelProduct != null) {
            return hotelProduct.getStatus() == ProductStatus.REQUEST;
        }
        return false;
    }

    @Override
    protected void execute(ProductActionContext<HotelProduct> ctx) {
        Dialog.confirm((String)Messages.CancelBookingRequestHotelNotification, () -> {
            EntityReference bookingFileRef = ctx.getRootPane().getData().getContainer().toReference();
            HotelProduct hotelProduct = (HotelProduct)ctx.getSelectedProduct();
            ProductRejectTask task = new ProductRejectTask(hotelProduct.getUid(), (EntityReference<BookingFile>)bookingFileRef, hotelProduct.getSystemNumber());
            Notifications.get().enqueueAsyncTask(task);
        });
    }
}

