/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.SingleFopsDialogContainer;
import com.gridnine.xtrip.client.fx.model.booking.SingleFopsDialogContainerController;
import com.gridnine.xtrip.client.fx.model.booking.SingleFopsDialogContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.SingleFopsDialogFopVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductClientFOPTask;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class ChangePayerProductAction<P extends BaseProduct>
extends BaseProductAction<P> {
    public double getWeight() {
        return 100.0;
    }

    @Override
    protected String getName() {
        return Messages.Change_fop_payer;
    }

    @Override
    protected String getDescription() {
        return Messages.Change_fop_payer;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    @Override
    protected boolean isEnabled(P product) {
        if (product == null) {
            return false;
        }
        ProductStatus status = GeneralProductHelper.getStatus(product);
        return ChangePayerProductAction.isValidStatus(status);
    }

    private static boolean isValidStatus(ProductStatus status) {
        return !ProductStatusHandler.getAllVoidStatuses().contains(status);
    }

    @Override
    protected void execute(ProductActionContext<P> ctx) {
        P selectedProduct = ctx.getSelectedProduct();
        String productUid = selectedProduct.getUid();
        BookingFileUIData bookingData = (BookingFileUIData)ctx.getRootPane().getData().getSupplement();
        BaseProductUIData productData = bookingData.getProducts().stream().filter(prd -> productUid.equals(prd.getRelatedProductUID())).findFirst().orElse(null);
        if (productData == null) {
            throw Xeption.forDeveloper((String)"can't find product data for product uid = {0}", (Object[])new Object[]{productUid});
        }
        EntityContainer bookingCtr = ctx.getRootPane().getData().getContainer();
        EntityReference bookingRef = bookingCtr.toReference();
        Notifications.get().submitTask((Executable)new ChangeFopPayerTask((EntityReference<BookingFile>)bookingRef, productUid, productData), Messages.Change_fop_payer_Process);
    }

    private static class ChangeFopPayerTask
    implements Executable {
        private final EntityReference<BookingFile> bookingRef;
        private final String productUid;
        private final BaseProductUIData productData;

        public ChangeFopPayerTask(EntityReference<BookingFile> bookingRef, String productUid, BaseProductUIData productData) {
            this.bookingRef = bookingRef;
            this.productUid = productUid;
            this.productData = productData;
        }

        public void execute() throws Exception {
            SingleFopsDialogContainerController controller = new SingleFopsDialogContainerController(false);
            SingleFopsDialogContainer pane = controller.getView();
            List serverClientFops = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getClientFops(ServiceInvocationContext.get(), this.bookingRef, Collections.singletonList(this.productUid));
            BookingFileService.ProductFopsResult serverFops = serverClientFops.stream().filter(res -> this.productUid.equals(res.getProductUid())).findFirst().orElse(null);
            if (serverFops == null) {
                throw Xeption.forEndUser((String)"\u0423 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0445 \u0444\u043e\u043f\u043e\u0432", (Object[])new Object[0]);
            }
            if (!ChangePayerProductAction.isValidStatus(serverFops.getStatus())) {
                throw Xeption.forEndUser((String)"\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0434\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 {0}", (Object[])new Object[]{serverFops.getStatus()});
            }
            Dialog dialog = new Dialog().setTitle(Messages.Change_fop_payer).setBody((Node)pane);
            dialog.setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close());
            TableWidget tableWidget = (TableWidget)pane.getContent();
            tableWidget.hideColumn(tableWidget.getColumn("uid"));
            tableWidget.hideColumn(tableWidget.getColumn("sourceUid"));
            tableWidget.setControlButtonsAvailability(type -> type == ControlsPane.ButtonType.REMOVE);
            ComboBoxWidgetColumn paymentTypeColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("paymentType");
            paymentTypeColumn.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
            EntityBoxWidgetColumn payerColumn = (EntityBoxWidgetColumn)tableWidget.getColumn("payer");
            payerColumn.setListParametersSupplier(() -> ControllerInterceptorsHelper.getPayers((List)MiscUtil.guarded(this.productData.getPayersUids().get(ContractType.CLIENT), Collections::emptyList)));
            PriceValueWidgetColumn paymentColumn = (PriceValueWidgetColumn)tableWidget.getColumn("payment");
            tableWidget.setOnRowsAction(event -> {
                if (event.getEventType() == TableRowEvent.ROW_REMOVE) {
                    SingleFopsDialogContainerVM parameters = new SingleFopsDialogContainerVM();
                    controller.writeData(parameters);
                    this.validateParameters(parameters, dialog);
                }
            });
            tableWidget.setControlButtonsCoordinator((type, row) -> {
                if (type == ControlsPane.ButtonType.REMOVE) {
                    if (row == null || row < 0) {
                        return false;
                    }
                    ArrayList fops = new ArrayList(tableWidget.getRowsData());
                    String uid = row < fops.size() ? ((SingleFopsDialogFopVM)fops.get((int)row)).getUid() : null;
                    return uid == null;
                }
                return false;
            });
            controller.getContent().readData(this.toVm(serverFops, this.productData));
            dialog.addButton(DialogButtonStyle.AUXILARY, Messages.Recalc_amounts, () -> {
                SingleFopsDialogContainerVM parameters = new SingleFopsDialogContainerVM();
                controller.writeData(parameters);
                this.correctFops(parameters);
                controller.readData(parameters);
                dialog.addValidationMessages(false, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Recalc_amounts_done, (Object[])new Object[0])});
            });
            dialog.addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Execute, () -> {
                SingleFopsDialogContainerVM parameters = new SingleFopsDialogContainerVM();
                controller.writeData(parameters);
                if (!this.validateParameters(parameters, dialog)) {
                    return;
                }
                Map<EntityReference<BookingFile>, Map<String, List<GeneralProductFop>>> taskParams = this.buildTaskParams(this.bookingRef, this.productUid, parameters, serverFops);
                Notifications.get().enqueueAsyncTask((ClientTask)new ProductClientFOPTask(taskParams));
                dialog.close();
            });
            FxUtil.submitToFxThread(() -> ((Dialog)dialog).showGlobal());
        }

        private Collection<SingleFopsDialogFopVM> toVm(BookingFileService.ProductFopsResult serverFops, BaseProductUIData productData) {
            return serverFops.getFops().stream().map(fop -> this.toVm((GeneralProductFop)fop, productData, serverFops.getStatus())).collect(Collectors.toList());
        }

        private SingleFopsDialogFopVM toVm(GeneralProductFop fop, BaseProductUIData productData, ProductStatus productStatus) {
            ProductFopUIData fopData = productData.getFopsList().stream().filter(f -> fop.getUid().equals(f.getUid())).findFirst().orElse(null);
            SingleFopsDialogFopVM result = new SingleFopsDialogFopVM();
            result.setUid(fop.getUid());
            result.setSourceUid(fop.getUid());
            result.setPaymentType(fop.getType());
            result.setCategory(fopData.getCategory());
            BigDecimal amount = fop.getEquivalentAmount();
            if (amount != null && ChangeFopPayerTask.needNegate(productStatus)) {
                amount = amount.negate();
            }
            result.setSum(amount);
            result.setPayment(amount);
            result.setPayer(fop.getPayer());
            return result;
        }

        private static boolean needNegate(ProductStatus productStatus) {
            return productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE;
        }

        private boolean validateParameters(SingleFopsDialogContainerVM parameters, Dialog dialog) {
            dialog.setValidationMessages(false, Collections.emptyList());
            ArrayList messages = new ArrayList();
            boolean needRecalcAmounts = this.checkParameters(parameters, messages::add);
            if (!messages.isEmpty()) {
                dialog.addValidationMessages(false, messages);
                if (needRecalcAmounts) {
                    dialog.addValidationMessages(false, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Errors_exists_recalc_fops, (Object[])new Object[0])});
                }
            }
            return messages.isEmpty();
        }

        private boolean checkParameters(SingleFopsDialogContainerVM parameters, Consumer<Message> messages) {
            boolean result = false;
            Map<String, SingleFopsDialogFopVM> originalFops = this.getOriginalFops(parameters);
            for (int ind = 0; ind < parameters.getContent().size(); ++ind) {
                SingleFopsDialogFopVM fopVM = (SingleFopsDialogFopVM)parameters.getContent().get(ind);
                int rec = ind + 1;
                if (MiscUtil.isZero((BigDecimal)fopVM.getPayment(), (boolean)true) && !MiscUtil.isZero((BigDecimal)fopVM.getSum(), (boolean)true)) {
                    messages.accept(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_amount_of_payment_in_record, (Object[])new Object[]{rec}));
                    if (fopVM.getUid() == null) {
                        result = true;
                    }
                }
                if (fopVM.getPaymentType() != null) continue;
                messages.accept(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_payment_type_in_record, (Object[])new Object[]{rec}));
            }
            Map<String, BigDecimal> resultPayments = this.getResultPayments(parameters);
            for (SingleFopsDialogFopVM originalFop : originalFops.values()) {
                BigDecimal originalFopAmount;
                BigDecimal resultPayment = MiscUtil.guarded((BigDecimal)resultPayments.get(originalFop.getUid()));
                if (MiscUtil.equals((Object)resultPayment, (Object)(originalFopAmount = MiscUtil.guarded((BigDecimal)originalFop.getSum())))) continue;
                messages.accept(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Amount_of_payments_not_equals_total_amount, (Object[])new Object[]{resultPayment, originalFopAmount}));
                result = true;
            }
            return result;
        }

        private Map<String, SingleFopsDialogFopVM> getOriginalFops(SingleFopsDialogContainerVM parameters) {
            return parameters.getContent().stream().filter(fop -> fop.getUid() != null).collect(Collectors.toMap(SingleFopsDialogFopVM::getUid, Function.identity()));
        }

        private Map<String, BigDecimal> getResultPayments(SingleFopsDialogContainerVM parameters) {
            return parameters.getContent().stream().filter(fop -> !MiscUtil.isZero((BigDecimal)fop.getPayment(), (boolean)true)).collect(Collectors.toMap(SingleFopsDialogFopVM::getSourceUid, SingleFopsDialogFopVM::getPayment, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})));
        }

        private void correctFops(SingleFopsDialogContainerVM parameters) {
            Map<String, SingleFopsDialogFopVM> originalFops = this.getOriginalFops(parameters);
            parameters.getContent().removeIf(fop -> fop.getUid() == null && MiscUtil.isZero((BigDecimal)fop.getPayment(), (boolean)true));
            Map<String, BigDecimal> resultPayments = this.getResultPayments(parameters);
            for (SingleFopsDialogFopVM originalFop : originalFops.values()) {
                BigDecimal resultPayment = resultPayments.get(originalFop.getUid());
                BigDecimal sub = MiscUtil.sub((BigDecimal)MiscUtil.guarded((BigDecimal)originalFop.getSum()), (BigDecimal[])new BigDecimal[]{MiscUtil.guarded((BigDecimal)resultPayment)});
                if (MiscUtil.compare((Comparable)sub, (Comparable)BigDecimal.ZERO) == 0) continue;
                SingleFopsDialogFopVM newFop = new SingleFopsDialogFopVM();
                newFop.setSourceUid(originalFop.getSourceUid());
                newFop.setCategory(originalFop.getCategory());
                newFop.setPayment(sub);
                parameters.getContent().add(newFop);
            }
        }

        private Map<EntityReference<BookingFile>, Map<String, List<GeneralProductFop>>> buildTaskParams(EntityReference<BookingFile> bookingRef, String productUid, SingleFopsDialogContainerVM parameters, BookingFileService.ProductFopsResult serverFops) {
            HashMap<EntityReference<BookingFile>, Map<String, List<GeneralProductFop>>> result = new HashMap<EntityReference<BookingFile>, Map<String, List<GeneralProductFop>>>();
            HashMap productFops = new HashMap();
            List fops = parameters.getContent().stream().map(ExceptionUtil.wrapFunction(fopVm -> this.fromVm((SingleFopsDialogFopVM)fopVm, serverFops))).collect(Collectors.toList());
            productFops.put(productUid, fops);
            if (!fops.containsAll(serverFops.getFops())) {
                throw Xeption.forDeveloper((String)"new fops is not contains all server fops", (Object[])new Object[0]);
            }
            result.put(bookingRef, productFops);
            return result;
        }

        private GeneralProductFop fromVm(SingleFopsDialogFopVM fopVm, BookingFileService.ProductFopsResult serverFops) throws Exception {
            GeneralProductFop sourceFop = (GeneralProductFop)CollectionUtil.find((Iterable)serverFops.getFops(), (String)fopVm.getSourceUid());
            GeneralProductFop result = (GeneralProductFop)XCloneHelper.clone((XCloneable)sourceFop);
            if (fopVm.getUid() == null) {
                result.setUid(UUIDUtil.toString((UUID)UUID.randomUUID()));
            }
            result.setType(fopVm.getPaymentType());
            BigDecimal payment = fopVm.getPayment();
            if (payment != null && ChangeFopPayerTask.needNegate(serverFops.getStatus())) {
                payment = payment.negate();
            }
            result.setEquivalentAmount(payment);
            result.setPayer(fopVm.getPayer());
            return result;
        }
    }
}

