/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.CopySegmentsForEmdProductService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;

public class CopyEMDProductSegmentsAction
extends BaseProductAction<Product> {
    @Override
    protected String getName() {
        return Messages.emd_Product_Copy_Segments_Name;
    }

    @Override
    protected String getDescription() {
        return Messages.emd_Product_Copy_Segments_Description;
    }

    @Override
    protected boolean isEnabled(Product product) {
        return true;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    public double getWeight() {
        return 30.0;
    }

    @Override
    protected void execute(ProductActionContext<Product> ctx) {
        Product product = ctx.getSelectedProduct();
        EntityContainer bookingFileContainer = ctx.getRootPane().getData().getContainer();
        ObservableMutex mutex = ctx.getRootPane().getMutex();
        FxUtil.submitToFxThread(() -> {
            try {
                Notifications.get().submitTask(() -> ((CopySegmentsForEmdProductService)RpcServiceManager.get().getService(CopySegmentsForEmdProductService.class)).populateSegments(product, bookingFileContainer), mutex);
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(bookingFileContainer.toReference(), EntityModification.ModificationType.CHANGE)));
            }
            catch (Exception ex) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.emd_Product_Copy_Segments_Error, (Throwable)ex, (Object[])new Object[0])});
            }
        });
    }
}

