/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.UniversalProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductExchangeTask;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ExchangeUniversalProductAction
implements TileAction<Node, BookingFileProductsFullPanel> {
    public String getName(Tile<Node, BookingFileProductsFullPanel> tile) {
        return Messages.Exchange;
    }

    public String getDescription(Tile<Node, BookingFileProductsFullPanel> tile) {
        return Messages.Exchange_service;
    }

    public double getWeight() {
        return 30.0;
    }

    public boolean isEnabled(Tile<Node, BookingFileProductsFullPanel> tile) {
        if (((CompactNavigatorWidget)((BookingFileProductsFullPanel)tile.getFullNode()).getContent()).getViewState().isImmutable()) {
            return false;
        }
        RootEntityPane rp = RootEntityPane.lookup((Node)tile.getFullNode());
        if (rp == null) {
            return false;
        }
        UniversalProduct universalProduct = (UniversalProduct)ProductActionsHelper.getSelectedProduct(tile);
        if (universalProduct == null) {
            return false;
        }
        return UniversalProductFXHelper.getDescription(universalProduct).isExchangeSupported() && this.isEnabled(universalProduct);
    }

    public void execute(Control source, Tile<Node, BookingFileProductsFullPanel> tile, boolean alt) {
        RootEntityPane rootPane = RootEntityPane.lookup((Node)source);
        if (!rootPane.isDataChanged()) {
            ProductActionContext<UniversalProduct> ctx = new ProductActionContext<UniversalProduct>(tile, alt, rootPane);
            if (ctx.getSelectedProduct() != null) {
                this.execute(ctx);
            }
            return;
        }
        Dialog.confirm((Node)Dialog.getGlobalWindow(), (String)Messages.Save_changes, null, (String)Messages.Save_and_continue, () -> {
            if (!rootPane.validate()) {
                return;
            }
            Notifications.get().submitTask(() -> {
                rootPane.saveData();
                FxUtil.submitToFxThread(() -> {
                    ProductActionContext<UniversalProduct> ctx = new ProductActionContext<UniversalProduct>(tile, alt, rootPane);
                    UniversalProduct selectedProduct = (UniversalProduct)ctx.getSelectedProduct();
                    if (selectedProduct == null) {
                        return;
                    }
                    if (this.isEnabled(selectedProduct)) {
                        this.execute(ctx);
                    }
                });
            }, rootPane.getMutex());
        }, null);
    }

    private void execute(ProductActionContext<UniversalProduct> ctx) {
        Dialog.confirm(ctx.getRootPane(), (String)Messages.Exchange_the_selected_product, () -> {
            ProductExchangeRefundProperties props = new ProductExchangeRefundProperties(null, null, false, null, null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
            Notifications.get().enqueueAsyncTask((ClientTask)new ProductExchangeTask(((UniversalProduct)ctx.getSelectedProduct()).getUid(), props, ctx.getRootPane()));
        });
    }

    private boolean isEnabled(UniversalProduct product) {
        return product != null && product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null;
    }
}

