/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import javafx.scene.Node;

final class ProductActionsHelper {
    static EntityContainer<BookingFile> getBookingFile(Tile<Node, BookingFileProductsFullPanel> tl) {
        RootEntityPane rep = RootEntityPane.lookup((Node)tl.getFullNode());
        if (rep == null || rep.getData() == null) {
            return null;
        }
        return rep.getData().getContainer();
    }

    static BaseProduct getSelectedProduct(Tile<Node, BookingFileProductsFullPanel> tl) {
        EntityContainer<BookingFile> bfCont = ProductActionsHelper.getBookingFile(tl);
        return bfCont != null ? ProductActionsHelper.getSelectedProduct(tl, (BookingFile)bfCont.getEntity()) : null;
    }

    static BaseProduct getSelectedProduct(Tile<Node, BookingFileProductsFullPanel> tl, BookingFile bookingFile) {
        Node selectedView = ((CompactNavigatorWidget)((BookingFileProductsFullPanel)tl.getFullNode()).getContent()).getSelectedView();
        if (selectedView == null) {
            return null;
        }
        String selectedProductUid = (String)selectedView.getProperties().get((Object)"model-uid");
        if (selectedProductUid == null) {
            return null;
        }
        return bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product.getUid().equals(selectedProductUid)).findFirst().orElse(null);
    }

    static <P extends BaseProduct> CopyProductAction<P> getBaseCopyProductAction() {
        return new CopyProductAction<P>(){

            @Override
            protected boolean isEnabled(P product) {
                if (product != null) {
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
                    ProductStatus status = handler.getStatus(product);
                    return (status == ProductStatus.SELL || status == ProductStatus.BOOKING || ProductStatusHandler.getAllVoidStatuses().contains(status)) && product.getReservation().getBookingFile().getNumber() != null;
                }
                return false;
            }

            @Override
            protected void execute(ProductActionContext<P> ctx) {
                CopyTask.showCopyDialog((EntityReference<BookingFile>)ctx.getRootPane().getData().getContainer().toReference(), ctx.getSelectedProduct().getUid(), ctx.getRootPane(), ctx.getRootPane().getMutex());
            }
        };
    }

    public <P extends BaseProduct> boolean isActionEnabled(P product) {
        if (product != null) {
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            ProductStatus status = handler.getStatus(product);
            BaseProduct nextProduct = handler.getNextProduct(product);
            return status == ProductStatus.SELL && nextProduct == null && product.getReservation().getBookingFile().getNumber() != null;
        }
        return false;
    }

    private ProductActionsHelper() {
    }
}

