/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductDialog;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.UniversalProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.UniversalProductService;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductRecalcFareData;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import org.apache.commons.io.FileUtils;

public class RecalculateEquivalentTariff
implements TileAction<Node, BookingFileProductsFullPanel> {
    public String getName(Tile<Node, BookingFileProductsFullPanel> tile) {
        return Messages.Recalculate_Eq_Rate;
    }

    public String getDescription(Tile<Node, BookingFileProductsFullPanel> tile) {
        return Messages.Recalculate_Equivalent_Tariff;
    }

    public double getWeight() {
        return 55.0;
    }

    public boolean isEnabled(Tile<Node, BookingFileProductsFullPanel> tile) {
        if (((CompactNavigatorWidget)((BookingFileProductsFullPanel)tile.getFullNode()).getContent()).getViewState().isImmutable()) {
            return false;
        }
        RootEntityPane rp = RootEntityPane.lookup((Node)tile.getFullNode());
        if (rp == null) {
            return false;
        }
        UniversalProduct universalProduct = (UniversalProduct)ProductActionsHelper.getSelectedProduct(tile);
        if (universalProduct == null) {
            return false;
        }
        return UniversalProductFXHelper.getDescription(universalProduct).isBaseFareSupported();
    }

    public void execute(Control source, Tile<Node, BookingFileProductsFullPanel> tile, boolean alt) {
        UniversalProduct universalProduct = (UniversalProduct)ProductActionsHelper.getSelectedProduct(tile);
        BookingFileUniversalProductPanel productParent = (BookingFileUniversalProductPanel)UiUtil.findViewWithModelUid((Iterable)((CompactNavigatorWidget)((BookingFileProductsFullPanel)tile.getFullNode()).getContent()).getViews(), (String)universalProduct.getUid());
        RootEntityPane context = RootEntityPane.lookup((Node)tile.getFullNode());
        if (productParent.getCostNode().getSumCellNode().getTariffCurrencyNode().getValue() == null || productParent.getCostNode().getSumCellNode().getTariffSumNode().getValue() == null) {
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Recalculate_Equivalent_Tariff).setMessage(Messages.Bassic_Tariff_Information_is_not_filled).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close).show((Node)source);
        } else if (!context.isDataChanged()) {
            this.getDialogForRecalc(context, universalProduct);
        } else {
            new Dialog().setTitle(Messages.Confirmation_required).setMessage(Messages.Must_save_the_changes).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> Notifications.get().submitTask(() -> {
                context.saveData();
                FxUtil.waitForFxThread(() -> this.getDialogForRecalc(context, universalProduct));
            }, Messages.Saving)).show((Node)source);
        }
    }

    private void getDialogForRecalc(RootEntityPane<?, ?> context, UniversalProduct universalProduct) {
        BookingFileUniversalProductDialog body = this.getPreconfiguredBody(universalProduct);
        VBox vBody = new VBox(new Node[]{body});
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Tariff_Re_Calculation).setBody((Node)vBody).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Calculate, () -> {
            vBody.getChildren().removeAll((Collection)vBody.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
            List<Node> listMessage = this.validateDialog(body);
            if (listMessage != null && !listMessage.isEmpty()) {
                listMessage.forEach(error -> vBody.getChildren().add(0, error));
                return;
            }
            UniversalProductRecalcFareData result = this.getRecalcFareData(body);
            this.applyChanges(universalProduct, result, context);
            dialog.close();
        }).show(context.getEditor());
    }

    private UniversalProductRecalcFareData getRecalcFareData(BookingFileUniversalProductDialog body) {
        UniversalProductRecalcFareData result = new UniversalProductRecalcFareData();
        result.setCoeff((BigDecimal)body.getCoeffNode().getValue());
        result.setRate((BigDecimal)body.getRateNode().getValue());
        result.setRateWithCoeff((BigDecimal)body.getRateWithCoeffNode().getValue());
        result.setRoundingMode((RoundingMode)body.getRoundingModeNode().getValue());
        result.setRoundingValue((RoundingValue)body.getRoundingValueNode().getValue());
        return result;
    }

    private void applyChanges(UniversalProduct product, UniversalProductRecalcFareData result, RootEntityPane<?, ?> context) {
        File file = new File(Environment.getTempFolder(), UniversalProductRecalcFareData.class.getSimpleName() + ".xml");
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])XSUtil.toByteArray((XSSerializable)result));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        Notifications.get().submitTask(() -> {
            ((UniversalProductService)RpcServiceManager.get().getService(UniversalProductService.class)).fillingAndSaveProduct(ServiceInvocationContext.get(), context.getData().getContainer().toReference(), product.getUid(), result);
            context.reloadData();
        }, Messages.Saving_Data);
    }

    private List<Node> validateDialog(BookingFileUniversalProductDialog body) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (body.getRateNode().getValue() == null) {
            result.add((Node)MessagePane.error((String)Messages.Specify_Rate));
        }
        if (body.getCoeffNode().getValue() == null) {
            result.add((Node)MessagePane.error((String)Messages.Specify_the_Risk_Ratio));
        }
        return result;
    }

    private BookingFileUniversalProductDialog getPreconfiguredBody(UniversalProduct product) {
        BookingFileUniversalProductDialog body = new BookingFileUniversalProductDialog(false);
        body.getRoundingValueNode().setNoNulls(true);
        body.getRoundingModeNode().setNoNulls(true);
        Notifications.get().submitTask(() -> {
            UniversalProductRecalcFareData data = ((UniversalProductService)RpcServiceManager.get().getService(UniversalProductService.class)).getUniversalProductRecalcFareData(ServiceInvocationContext.get(), product);
            File file = new File(Environment.getTempFolder(), UniversalProductRecalcFareData.class.getSimpleName() + ".xml");
            if (file.exists()) {
                try {
                    byte[] content = FileUtils.readFileToByteArray((File)file);
                    XUtil.fromBytes((byte[])content, (XSerializable)data);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
            FxUtil.waitForFxThread(() -> {
                body.getRoundingValueNode().setValue((Object)(data.getRoundingValue() == null ? RoundingValue.V_0_0_1 : data.getRoundingValue()));
                body.getRoundingModeNode().setValue((Object)(data.getRoundingMode() == null ? RoundingMode.NONE : data.getRoundingMode()));
                body.getCoeffNode().setValue((Number)data.getCoeff());
                body.getRateNode().setValue((Number)data.getRate());
                body.getRateWithCoeffNode().setValue((Number)data.getRateWithCoeff());
                body.getCoeffNode().valueProperty().addListener((v, oldValue, newValue) -> {
                    if (newValue != null && body.getRateNode().getValue() != null) {
                        body.getRateWithCoeffNode().setValue((Number)newValue.multiply((BigDecimal)body.getRateNode().getValue()));
                        body.getRateWithCoeffNode().getViewState().setNotEditable(true);
                    }
                });
                body.getRateNode().valueProperty().addListener((v, oldValue, newValue) -> {
                    if (newValue != null && body.getCoeffNode().getValue() != null) {
                        body.getRateWithCoeffNode().setValue((Number)newValue.multiply((BigDecimal)body.getCoeffNode().getValue()));
                        body.getRateWithCoeffNode().getViewState().setNotEditable(true);
                    }
                });
            });
        }, Messages.Retrieving_course_data);
        return body;
    }
}

