/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductPanel;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ChangePayerProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ExchangeUniversalProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.PayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateEquivalentTariff;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefundUniversalProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnpayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnrefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnvoidBaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.VoidProductAction;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.scene.Node;

public class UniversalProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    @Override
    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileUniversalProductPanel;
    }

    @Override
    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new MovePrevProductAction<UniversalProduct>(){

            @Override
            protected BaseProduct getPreviousProduct(UniversalProduct product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<UniversalProduct>(){

            @Override
            protected BaseProduct getNextProduct(UniversalProduct product) {
                return product.getNextProduct();
            }
        }, new ExchangeUniversalProductAction(), new RefundUniversalProductAction(), new RecalculateFOPProductAction(), new RecalculateEquivalentTariff(), new CopyProductAction<UniversalProduct>(){

            @Override
            protected boolean isEnabled(UniversalProduct product) {
                if (product != null) {
                    ProductStatus status = product.getStatus();
                    boolean enabledByStatus = status == ProductStatus.SELL || status == ProductStatus.BOOKING || status == ProductStatus.VOID_BOOKING || status == ProductStatus.VOID;
                    UniversalProductDescription description = Prefetched.getData().getUniversalProductDescriptionData().stream().filter(data -> data.getReference().equals((Object)product.getDescription())).map(UniversalProductDescriptionData::getData).findFirst().orElse(null);
                    boolean enabledByDescription = description == null || !description.isDisabled();
                    return enabledByStatus && enabledByDescription;
                }
                return false;
            }

            @Override
            protected void execute(ProductActionContext<UniversalProduct> ctx) {
                boolean notGenerateSystemNumber = Prefetched.getData().getUniversalProductDescriptionData().stream().filter(data -> data.getReference().equals((Object)((UniversalProduct)ctx.getSelectedProduct()).getDescription())).map(UniversalProductDescriptionData::getData).filter(Objects::nonNull).anyMatch(UniversalProductDescription::isAutoGeneratedSystemNumbers);
                CopyTask.showCopyDialog((EntityReference<BookingFile>)ctx.getRootPane().getData().getContainer().toReference(), ctx.getSelectedProduct().getUid(), false, ctx.getRootPane(), ctx.getRootPane().getMutex(), notGenerateSystemNumber);
            }
        }, new VoidProductAction<UniversalProduct>(){

            @Override
            protected boolean isEnabled(UniversalProduct product) {
                return product != null && (product.getStatus() == ProductStatus.BOOKING || product.getStatus() == ProductStatus.SELL) && product.getNextProduct() == null;
            }
        }, new UnvoidBaseProductAction<UniversalProduct>(){

            @Override
            protected boolean isEnabled(UniversalProduct product) {
                return product != null && (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING);
            }
        }, new PayProductAction<UniversalProduct>(){

            @Override
            protected ProductStatus getStatus(UniversalProduct product) {
                return product.getStatus();
            }
        }, new UnpayProductAction<UniversalProduct>(){

            @Override
            protected ProductStatus getStatus(UniversalProduct product) {
                return product.getStatus();
            }
        }, new RefusePaymentProductAction<UniversalProduct>(){

            @Override
            protected ProductStatus getStatus(UniversalProduct product) {
                return product.getStatus();
            }
        }, new UnrefusePaymentProductAction<UniversalProduct>(){

            @Override
            protected ProductStatus getStatus(UniversalProduct product) {
                return product.getStatus();
            }
        }, new ChangePayerProductAction());
        return this.actions;
    }

    public String getId() {
        return "universal-product-actions-provider";
    }
}

