/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ProductUnpayClientFOPDialog;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourceOperations;

public abstract class UnpayProductAction<P extends BaseProduct>
extends BaseProductAction<P> {
    public double getWeight() {
        return 100.0;
    }

    @Override
    protected String getName() {
        return Messages.Cancel_Payment;
    }

    @Override
    protected String getDescription() {
        return Messages.Cancel_payment;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    @Override
    protected boolean isEnabled(P product) {
        return product != null && !ProductStatusHandler.getAllVoidStatuses().contains(this.getStatus(product));
    }

    @Override
    protected void execute(ProductActionContext<P> ctx) {
        Object selectedProduct = ctx.getSelectedProduct();
        EntityReference bfRef = ctx.getRootPane().getData().getContainer().toReference();
        Notifications.get().submitTask(() -> {
            ProductUnpayClientFOPDialog dialog = new ProductUnpayClientFOPDialog(selectedProduct.getUid(), (EntityReference<BookingFile>)bfRef, false);
            FxUtil.submitToFxThread(() -> ((ProductUnpayClientFOPDialog)dialog).showGlobal());
        }, Messages.Cancellation_Process);
    }

    protected abstract ProductStatus getStatus(P var1);

    @Override
    protected AclQuery getACLQuery(EntityContainer<BookingFile> bookingFile, P product) {
        return AclQuery.AclQueryBuilder.get().entry(ModelAclResourceOperations.UNPAY.getId(), ModelRestrictionEntityResources.ENTITY_RESERVATION.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), new NestedEntityReference(bookingFile, product)).build();
    }
}

