/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.List;

public class VatRecalculateAction
extends BaseProductAction<Product> {
    public double getWeight() {
        return 60.0;
    }

    @Override
    protected String getName() {
        return Messages.recalculateVat;
    }

    @Override
    protected String getDescription() {
        return Messages.recalculateVat;
    }

    @Override
    protected boolean isEnabled(Product product) {
        return product != null;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    @Override
    protected void execute(ProductActionContext<Product> ctx) {
        String productUid = ctx.getSelectedProduct().getUid();
        EntityReference bfRef = ctx.getRootPane().getData().getContainer().toReference();
        Dialog.confirm(ctx.getRootPane(), (String)Messages.recalculateVat, () -> Notifications.get().submitTask(() -> this.recalculateVat((EntityReference<BookingFile>)bfRef, productUid), ctx.getRootPane().getMutex()));
    }

    private void recalculateVat(EntityReference<BookingFile> bfRef, String productUid) throws Exception {
        List messages = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).recalculateVAT(ServiceInvocationContext.get(), bfRef, productUid);
        Notifications.get().showMessages((Collection)messages);
        if (!ValidationUtil.hasErrors((Iterable)messages)) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(bfRef, EntityModification.ModificationType.CHANGE)));
        }
    }
}

