/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multitable.MultiTableWidget;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCommissionsController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCommissionsVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsEntryVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsWidgetVM;
import com.gridnine.xtrip.client.fx.standard.custom.CommissionsWidget2;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.BookingFileSpaceHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DiscountsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.Parent;

public class BookingFileProductCommissionsControllerInterceptor
extends ControllerInterceptor<BookingFileProductCommissionsVM, BookingFileProductCommissionsController> {
    protected Class<BookingFileProductCommissionsController> getControllerClass() {
        return BookingFileProductCommissionsController.class;
    }

    protected void beforeReadData(BookingFileProductCommissionsController controller, final BookingFileProductCommissionsVM model) {
        final CommissionsWidget2 commissionsWidget = (CommissionsWidget2)controller.getView().getContent();
        commissionsWidget.setProductDataSupplier(new CommissionsWidget2.ProductDataSupplier(){
            private ProductType productType = null;

            @Override
            public ProductType getProductType() {
                if (this.productType != null) {
                    return this.productType;
                }
                for (Parent parent = commissionsWidget.getParent(); parent != null; parent = parent.getParent()) {
                    BaseProduct product;
                    EntityContainer<BookingFile> bookingFileContainer;
                    String productUid;
                    ProductFXHandler<?, ?, ?, ?> handler = ProductFXHandler.forNode((Node)parent);
                    if (handler == null || (productUid = (String)parent.getProperties().get((Object)"model-uid")) == null || (bookingFileContainer = BookingFileSpaceHelper.lookupBookingFileContainer((Node)parent)) == null || (product = (BaseProduct)((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(prod -> prod.getUid().equals(productUid)).findFirst().orElse(null)) == null) continue;
                    this.productType = handler.getProductType(product);
                    break;
                }
                return this.productType;
            }

            @Override
            public List<SegmentTariff> getSegmentTariffs() {
                return model.getSegmentTariffs();
            }

            @Override
            public boolean isUseSegmentColumn() {
                return model.isEnableSegmentsColumn();
            }
        });
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductCommissionsController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        String uid = controller.getData().getProductUid();
        BookingFileUIData bookingFileSupplementData = (BookingFileUIData)((DataTransferPackage)rootController.getData()).getSupplement();
        MultiTableWidget<CommissionsWidgetVM, CommissionsEntryVM> commissionsMultiTable = ((CommissionsWidget2)controller.getView().getContent()).getTable();
        List contractRelationDatas = bookingFileSupplementData.getProducts().stream().filter(item -> MiscUtil.equals((Object)item.getRelatedProductUID(), (Object)uid)).findFirst().map(BaseProductUIData::getCommissionDiscountFeeHandlers).orElse(Collections.emptyList());
        Map<String, MultiTableWidget.TableSet> tableSets = commissionsMultiTable.getTableSets().stream().collect(Collectors.toMap(MultiTableWidget.TableSet::getId, item -> item));
        boolean contractRelationCreateGranted = !deniedPermissions.contains(AclHelper.createPermission((String)ModelRestrictionEntityResources.ENTITY_CONTRACT_RELATION_DATA.getId(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.CREATE));
        boolean commissionCreateGranted = !deniedPermissions.contains(AclHelper.createPermission((String)ModelRestrictionEntityResources.ENTITY_COMMISSION.getId(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.CREATE));
        for (CommissionsDiscountsFeesUIDataHandler contractRelationData : contractRelationDatas) {
            MultiTableWidget.Row commissionRow;
            boolean isProtectedRelation = contractRelationData.getContractType() == ContractType.TECHNICAL_PROVIDER;
            boolean contractRelationViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)contractRelationData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
            boolean contractRelationEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)contractRelationData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT)) && !isProtectedRelation;
            boolean contractRelationDeleteGranted = !deniedPermissions.contains(AclHelper.createPermission((String)contractRelationData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE)) && !isProtectedRelation;
            MultiTableWidget.TableSet tableSet = tableSets.get(contractRelationData.getUid());
            tableSet.getViewState().setState(ViewState.composeState((boolean)tableSet.getViewState().isReadonly(), (boolean)tableSet.getViewState().isNotEditable(), (!contractRelationEditGranted ? 1 : 0) != 0, (!contractRelationViewGranted ? 1 : 0) != 0, (!contractRelationCreateGranted ? 1 : 0) != 0, (!contractRelationDeleteGranted ? 1 : 0) != 0));
            Map<String, MultiTableWidget.Table> tables = tableSet.getTables().stream().collect(Collectors.toMap(MultiTableWidget.Table::getId, item -> item));
            MultiTableWidget.Table commissionsTable = tables.get("commission");
            commissionsTable.getViewState().setState(ViewState.composeState((boolean)commissionsTable.getViewState().isReadonly(), (boolean)commissionsTable.getViewState().isNotEditable(), (boolean)commissionsTable.getViewState().isAclNotEditable(), (boolean)commissionsTable.getViewState().isAclNotViewable(), (!commissionCreateGranted ? 1 : 0) != 0, (boolean)commissionsTable.getViewState().isAclNotDeletable()));
            Map<String, MultiTableWidget.Row> commissionRows = commissionsTable.getRows().stream().collect(Collectors.toMap(MultiTableWidget.Row::getId, item -> item));
            for (CommissionsUIData commissionData : contractRelationData.getCommissions()) {
                boolean commissionViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)commissionData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
                boolean commissionEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)commissionData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT)) && !isProtectedRelation;
                boolean commissionDeleteGranted = !deniedPermissions.contains(AclHelper.createPermission((String)commissionData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE)) && !isProtectedRelation;
                commissionRow = commissionRows.get(commissionData.getUid());
                commissionRow.getViewState().setState(ViewState.composeState((boolean)commissionRow.getViewState().isReadonly(), (boolean)commissionRow.getViewState().isNotEditable(), (!commissionEditGranted ? 1 : 0) != 0, (!commissionViewGranted ? 1 : 0) != 0, (!commissionCreateGranted ? 1 : 0) != 0, (!commissionDeleteGranted ? 1 : 0) != 0));
            }
            for (DiscountsUIData discountData : contractRelationData.getDiscounts()) {
                boolean discountViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)discountData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
                boolean discountEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)discountData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT)) && !isProtectedRelation;
                boolean discountDeleteGranted = !deniedPermissions.contains(AclHelper.createPermission((String)discountData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE)) && !isProtectedRelation;
                commissionRow = commissionRows.get(discountData.getUid());
                commissionRow.getViewState().setState(ViewState.composeState((boolean)commissionRow.getViewState().isReadonly(), (boolean)commissionRow.getViewState().isNotEditable(), (!discountEditGranted ? 1 : 0) != 0, (!discountViewGranted ? 1 : 0) != 0, (!commissionCreateGranted ? 1 : 0) != 0, (!discountDeleteGranted ? 1 : 0) != 0));
            }
            MultiTableWidget.Table feesTable = tables.get("fees");
            feesTable.getViewState().setState(ViewState.composeState((boolean)feesTable.getViewState().isReadonly(), (boolean)feesTable.getViewState().isNotEditable(), (boolean)feesTable.getViewState().isAclNotEditable(), (boolean)feesTable.getViewState().isAclNotViewable(), (!commissionCreateGranted ? 1 : 0) != 0, (boolean)feesTable.getViewState().isAclNotDeletable()));
            Map<String, MultiTableWidget.Row> feeRows = feesTable.getRows().stream().collect(Collectors.toMap(MultiTableWidget.Row::getId, item -> item));
            for (FeesUIData feeData : contractRelationData.getFees()) {
                boolean feeViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)feeData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
                boolean feeEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)feeData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT)) && !isProtectedRelation;
                boolean feeDeleteGranted = !deniedPermissions.contains(AclHelper.createPermission((String)feeData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE)) && !isProtectedRelation;
                MultiTableWidget.Row feeRow = feeRows.get(feeData.getUid());
                feeRow.getViewState().setState(ViewState.composeState((boolean)feeRow.getViewState().isReadonly(), (boolean)feeRow.getViewState().isNotEditable(), (!feeEditGranted ? 1 : 0) != 0, (!feeViewGranted ? 1 : 0) != 0, (!commissionCreateGranted ? 1 : 0) != 0, (!feeDeleteGranted ? 1 : 0) != 0));
            }
        }
    }
}

