/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DoubleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopAdditional;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCard1Grid;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCard4Grid;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCard5Grid;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCard6Grid;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCards;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileVendorFinanceDocumentsDataPanel;
import com.gridnine.xtrip.client.fx.model.booking.ContractCurrencyVM;
import com.gridnine.xtrip.client.fx.model.booking.FopDiscountsVM;
import com.gridnine.xtrip.client.fx.model.booking.FopFeesVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DiscountsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.ProductFopCategory;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.util.StringConverter;

public class BookingFileProductFopControllerInterceptor
extends ControllerInterceptor<BookingFileProductFopVM, BookingFileProductFopController> {
    protected Class<BookingFileProductFopController> getControllerClass() {
        return BookingFileProductFopController.class;
    }

    protected void beforeReadData(BookingFileProductFopController controller, BookingFileProductFopVM model) {
        ExtendedTableWidget fopTable = controller.getView().getFopTableNode();
        fopTable.setEventHandler(event -> {
            if (event.getTarget() == fopTable && ExtendedTableRowEvent.ROW_ADD.equals(event.getEventType())) {
                ExtendedTableWidget.Row row = event.getRow();
                ComboBoxWidget contractTypeWidget = (ComboBoxWidget)row.getWidget("contractType");
                ComboBoxWidget paymentTypeWidget = (ComboBoxWidget)row.getWidget("paymentType");
                PopupWidget popupWidget = (PopupWidget)row.getWidget("superColumn");
                BookingFileProductFopControllerInterceptor.initTypeColumns((ComboBoxWidget<ContractType>)contractTypeWidget, (ComboBoxWidget<PaymentType>)paymentTypeWidget, model);
                BookingFileProductFopControllerInterceptor.initFopTableColumns((ExtendedTableWidget<BookingFileProductFopTableVM>)fopTable, (ExtendedTableWidget.Row<BookingFileProductFopTableVM>)row, model.getProductType());
                BookingFileProductFopControllerInterceptor.initSuppliersForInnerWidget((ComboBoxWidget<ContractType>)contractTypeWidget, controller, (BookingFileProductFopAdditional)popupWidget.getView());
                this.initZoneSwitcher((ComboBoxWidget<ContractType>)contractTypeWidget, (ComboBoxWidget<PaymentType>)paymentTypeWidget, (BookingFileProductFopAdditional)popupWidget.getView(), model.getProductType());
                ((TableWidget)((BookingFileProductFopCards)((BookingFileProductFopAdditional)popupWidget.getView()).getContent()).getFopComponentCard().getContent()).getColumn("correctionShipment").setHidden(TicketType.CORRECTION != model.getTicketType());
                BookingFileProductFopControllerInterceptor.setCaption((ComboBoxWidget<ContractType>)contractTypeWidget, (PopupWidget<BookingFileProductFopAdditional>)popupWidget);
            }
        });
        TableWidget vendorFinanceDocumentsDataTable = (TableWidget)((BookingFileVendorFinanceDocumentsDataPanel)controller.getView().getVendorFinanceDocumentsDataNode().getView()).getContent();
        vendorFinanceDocumentsDataTable.addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget financeDocumentType = (ComboBoxWidget)vendorFinanceDocumentsDataTable.getColumn("financeDocumentType").getWidget(ind.intValue());
            financeDocumentType.setItemsSupplier(() -> FinanceDocumentsHelper.types);
            if (financeDocumentType.getValue() == null) {
                financeDocumentType.setValue((Object)FinanceDocumentType.INVOICE_FACTURA);
            }
        });
    }

    private static void setCaption(ComboBoxWidget<ContractType> contractTypeWidget, PopupWidget<BookingFileProductFopAdditional> popupWidget) {
        BookingFileProductFopControllerInterceptor.setPopupCaption((ContractType)contractTypeWidget.getValue(), popupWidget);
        contractTypeWidget.valueProperty().addListener((f, old, type) -> BookingFileProductFopControllerInterceptor.setPopupCaption(type, popupWidget));
    }

    private static void setPopupCaption(ContractType type, PopupWidget<BookingFileProductFopAdditional> popupWidget) {
        if (type != null && ContractType.VENDOR.equals((Object)type)) {
            popupWidget.setFieldName(Messages.Contract_with_the_supplier);
        } else {
            popupWidget.setFieldName(Messages.Contract_with_the_client);
        }
    }

    private static void initTypeColumns(ComboBoxWidget<ContractType> contractTypeWidget, ComboBoxWidget<PaymentType> paymentTypeWidget, BookingFileProductFopVM model) {
        boolean isDelivery = model.getProductType() == null ? false : model.getProductType().isAssignableFrom(Delivery.class);
        contractTypeWidget.setNoNulls(true);
        contractTypeWidget.setItemsSupplier(BookingFileProductFopControllerInterceptor.contractTypeSupplier(model.isHasSubagencyType(), isDelivery));
        if (contractTypeWidget.getValue() == null) {
            if (isDelivery) {
                contractTypeWidget.setValue((Object)ContractType.CLIENT);
            } else {
                contractTypeWidget.setValue((Object)ContractType.VENDOR);
            }
        }
        paymentTypeWidget.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
    }

    private static void initFopTableColumns(ExtendedTableWidget<BookingFileProductFopTableVM> fopTable, ExtendedTableWidget.Row<BookingFileProductFopTableVM> row, Class<? extends BaseProduct> productType) {
        CurrencyValueWidget currencyWidget = (CurrencyValueWidget)row.getWidget("currency");
        ComboBoxWidget categoryWidget = (ComboBoxWidget)row.getWidget("category");
        EntityBoxWidget agentWidget = (EntityBoxWidget)row.getWidget("agent");
        if (categoryWidget.getValue() == null) {
            categoryWidget.setValue((Object)ProductFopCategory.PRODUCT);
        }
        agentWidget.setFieldName(Messages.Dimension_agent);
        agentWidget.setListParametersSupplier(BookingFileProductFopControllerInterceptor.agentListParametersSupplier());
    }

    private static void initSuppliersForInnerWidget(ComboBoxWidget<ContractType> contractTypeWidget, BookingFileProductFopController controller, BookingFileProductFopAdditional innerWidget) {
        EntityBoxWidget payerWidget = ((BookingFileProductFopCard1Grid)((BookingFileProductFopCards)innerWidget.getContent()).getContractTypeVendorCard().getContent()).getPayerNode();
        payerWidget.setFieldName(Messages.Payer);
        payerWidget.setListParametersSupplier(() -> ControllerInterceptorsHelper.getPayers((List)MiscUtil.guarded(controller.getData().getAvailablePayersUids().get(contractTypeWidget.getValue()), Collections::emptyList)));
        ComboBoxWidget bankNameWidget = ((BookingFileProductFopCard4Grid)((BookingFileProductFopCards)innerWidget.getContent()).getBankCard().getContent()).getBankNameNode();
        bankNameWidget.setItemsSupplier(() -> controller.getData().getAgencyBanks());
        ComboBoxWidget detailsWidget = ((BookingFileProductFopCard5Grid)((BookingFileProductFopCards)innerWidget.getContent()).getDocumentCard().getContent()).getDetailsNode();
        detailsWidget.setItemsSupplier(Suppliers.createEnumSupplier(PassengerStatus.class));
        ComboBoxWidget vendorWidget = ((BookingFileProductFopCard6Grid)((BookingFileProductFopCards)innerWidget.getContent()).getCardCard().getContent()).getVendorNode();
        vendorWidget.setItemsSupplier(Suppliers.createEnumSupplier(CardVendor.class));
        TableWidget discountsTable = (TableWidget)((BookingFileProductFopCards)innerWidget.getContent()).getDiscountsCard().getContent();
        for (int i = 0; i < discountsTable.getRowsCount(); ++i) {
            BookingFileProductFopControllerInterceptor.initInnerDiscountsTableRow((TableWidget<FopDiscountsVM>)discountsTable, i, controller.getData().getAllDiscounts());
        }
        discountsTable.setOnRowsAction(event -> {
            if (event.getTarget() == discountsTable && TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                BookingFileProductFopControllerInterceptor.initInnerDiscountsTableRow((TableWidget<FopDiscountsVM>)discountsTable, event.getRowIndex(), controller.getData().getAllDiscounts());
            }
        });
        TableWidget feesTable = (TableWidget)((BookingFileProductFopCards)innerWidget.getContent()).getFeesCard().getContent();
        for (int i = 0; i < feesTable.getRowsCount(); ++i) {
            BookingFileProductFopControllerInterceptor.initInnerFeesTableRow((TableWidget<FopFeesVM>)feesTable, i, controller.getData().getAllFees());
        }
        feesTable.setOnRowsAction(event -> {
            if (event.getTarget() == feesTable && TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                BookingFileProductFopControllerInterceptor.initInnerFeesTableRow((TableWidget<FopFeesVM>)feesTable, event.getRowIndex(), controller.getData().getAllFees());
            }
        });
    }

    private static void initInnerDiscountsTableRow(TableWidget<FopDiscountsVM> discountsTable, int rowIdx, List<DiscountsUIData> allDiscounts) {
        TableWidgetColumn discountsColumn = discountsTable.getColumn("discount");
        ComboBoxWidget discountsWidget = (ComboBoxWidget)discountsColumn.getWidget(rowIdx);
        discountsWidget.setLive(true);
        discountsWidget.setItemsSupplier(() -> allDiscounts);
        discountsWidget.setConverter((StringConverter)new StringConverter<DiscountsUIData>(){

            public String toString(DiscountsUIData d) {
                return d == null ? null : d.getDiscountProperty().getCaption();
            }

            public DiscountsUIData fromString(String s) {
                return null;
            }
        });
        DiscountsUIData oldValue = (DiscountsUIData)discountsWidget.getValue();
        discountsWidget.setValue(null);
        discountsWidget.setValue((Object)oldValue);
        TableWidgetColumn sumColumn = discountsTable.getColumn("sum");
        PriceValueWidget sumWidget = (PriceValueWidget)sumColumn.getWidget(rowIdx);
        discountsWidget.valueProperty().addListener((f, old, val) -> sumWidget.setValue((Number)(val == null ? null : val.getEquivalentAmount())));
    }

    private static void initInnerFeesTableRow(TableWidget<FopFeesVM> feesTable, int rowIdx, List<FeesUIData> allFees) {
        TableWidgetColumn feesColumn = feesTable.getColumn("fee");
        ComboBoxWidget feesWidget = (ComboBoxWidget)feesColumn.getWidget(rowIdx);
        feesWidget.setLive(true);
        feesWidget.setItemsSupplier(() -> allFees);
        feesWidget.setConverter((StringConverter)new StringConverter<FeesUIData>(){

            public String toString(FeesUIData f) {
                return f == null ? null : f.getFeeProperty().getCaption();
            }

            public FeesUIData fromString(String s) {
                return null;
            }
        });
        FeesUIData oldValue = (FeesUIData)feesWidget.getValue();
        feesWidget.setValue(null);
        feesWidget.setValue((Object)oldValue);
        TableWidgetColumn sumColumn = feesTable.getColumn("sum");
        PriceValueWidget sumWidget = (PriceValueWidget)sumColumn.getWidget(rowIdx);
        feesWidget.valueProperty().addListener((f, old, val) -> sumWidget.setValue((Number)(val == null ? null : val.getEquivalentAmount())));
    }

    private void initZoneSwitcher(ComboBoxWidget<ContractType> contractTypeWidget, ComboBoxWidget<PaymentType> paymentTypeWidget, BookingFileProductFopAdditional innerWidget, Class<? extends BaseProduct> productType) {
        BookingFileProductFopControllerInterceptor.switchFirstZone((ContractType)contractTypeWidget.getValue(), innerWidget, productType);
        contractTypeWidget.valueProperty().addListener((f, old, type) -> BookingFileProductFopControllerInterceptor.switchFirstZone(type, innerWidget, productType));
        this.switchSecondZone((PaymentType)paymentTypeWidget.getValue(), innerWidget);
        paymentTypeWidget.valueProperty().addListener((f, old, type) -> this.switchSecondZone((PaymentType)type, innerWidget));
    }

    private static void switchFirstZone(ContractType type, BookingFileProductFopAdditional innerWidget, Class<? extends BaseProduct> productType) {
        BookingFileProductFopCards contentNode = (BookingFileProductFopCards)innerWidget.getContent();
        if (ContractType.VENDOR.equals((Object)type) && productType != null && productType.isAssignableFrom(Product.class)) {
            contentNode.getAccompanyingDocumentCard().setHidden(false);
            contentNode.getContractTypeVendorCard().setHidden(true);
        } else {
            contentNode.getAccompanyingDocumentCard().setHidden(true);
            contentNode.getContractTypeVendorCard().setHidden(false);
        }
    }

    protected void switchSecondZone(PaymentType type, BookingFileProductFopAdditional innerWidget) {
        Set<Card<?>> result = BookingFileProductFopControllerInterceptor.getCardsToShow(type, innerWidget);
        this.hideSecondZoneCards(innerWidget, result);
    }

    protected void hideSecondZoneCards(BookingFileProductFopAdditional innerWidget, Set<Card<?>> cards) {
        ((BookingFileProductFopCards)innerWidget.getContent()).getRelatedTicketNumberCard().setHidden(true);
        ((BookingFileProductFopCards)innerWidget.getContent()).getBankCard().setHidden(true);
        Card docCard = ((BookingFileProductFopCards)innerWidget.getContent()).getDocumentCard();
        docCard.setHidden(true);
        Card cardCard = ((BookingFileProductFopCards)innerWidget.getContent()).getCardCard();
        cardCard.setHidden(true);
        if (cards.isEmpty() || !cards.contains(cardCard)) {
            BookingFileProductFopControllerInterceptor.clearCreditCard((BookingFileProductFopCard6Grid)cardCard.getContent());
        }
        if (cards.isEmpty() || !cards.contains(docCard)) {
            BookingFileProductFopControllerInterceptor.clearDocumentCard((BookingFileProductFopCard5Grid)docCard.getContent());
        }
        cards.forEach(card -> card.setHidden(false));
    }

    protected static Set<Card<?>> getCardsToShow(PaymentType type, BookingFileProductFopAdditional innerWidget) {
        HashSet result = new HashSet();
        if (type != null) {
            switch (type) {
                case CREDIT_CARD: 
                case CREDIT_CARD_AGENCY: 
                case CREDIT_CARD_ONLINE_CHRONOPAY: 
                case CREDIT_CARD_ONLINE_CLEARPARK: 
                case CREDIT_CARD_ONLINE_PAYTURE: 
                case CREDIT_CARD_ONLINE_RAIFFEISEN: 
                case CREDIT_CARD_ONLINE_RBS: 
                case CREDIT_CARD_ONLINE_RBS_V2: 
                case CREDIT_CARD_TCH: {
                    result.add(((BookingFileProductFopCards)innerWidget.getContent()).getCardCard());
                    break;
                }
                case CREDIT: 
                case INTERLINE: 
                case MTD: 
                case MTD_AGENCY: {
                    result.add(((BookingFileProductFopCards)innerWidget.getContent()).getDocumentCard());
                    break;
                }
                case TICKET: 
                case PTA: 
                case SERVICE_DEMAND: 
                case VOUCHER: {
                    result.add(((BookingFileProductFopCards)innerWidget.getContent()).getRelatedTicketNumberCard());
                    break;
                }
                case BANK: {
                    result.add(((BookingFileProductFopCards)innerWidget.getContent()).getBankCard());
                }
            }
            if (type.name().equals("EPAYKZT_PAYBOX")) {
                result.add(((BookingFileProductFopCards)innerWidget.getContent()).getCardCard());
            }
        }
        return result;
    }

    private static Supplier<List<ContractType>> contractTypeSupplier(boolean hasSubagencyType, boolean isDelivery) {
        return () -> {
            ArrayList<ContractType> types = new ArrayList<ContractType>();
            types.add(ContractType.CLIENT);
            if (!isDelivery) {
                types.add(ContractType.VENDOR);
                if (hasSubagencyType) {
                    types.add(ContractType.SUBAGENCY);
                }
            }
            return types;
        };
    }

    private static Supplier<IndexListParameters<Person, ?>> agentListParametersSupplier() {
        return () -> {
            IndexListParameters params = new IndexListParameters();
            params.setIndexType(PersonIndex.class);
            TableColumnSettings name = new TableColumnSettings();
            name.setId(PersonIndex.Property.name.name());
            TableColumnSettings code = new TableColumnSettings();
            code.setId(PersonIndex.Property.code.name());
            params.getColumns().add(name);
            params.getColumns().add(code);
            params.getFilters().add(name);
            params.getFilters().add(code);
            params.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT));
            params.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
            params.getPatternSearchFields().add(PersonIndex.Property.name.name());
            return params;
        };
    }

    private static void clearCreditCard(BookingFileProductFopCard6Grid card) {
        card.getExpirationDateNode().setValue(null);
        card.getNumberNode().setValue(null);
        card.getSecurityCodeNode().setValue(null);
        card.getVendorNode().setValue(null);
    }

    private static void clearDocumentCard(BookingFileProductFopCard5Grid card) {
        card.getDetailsNode().setValue(null);
        card.getDocumentNumberNode().setValue(null);
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductFopController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        String uid = controller.getData().getProductUid();
        BookingFileUIData bookingFileSupplementData = (BookingFileUIData)((DataTransferPackage)rootController.getData()).getSupplement();
        ExtendedTableWidget fopsExtendedTable = controller.getView().getFopTableNode();
        List fopDatas = bookingFileSupplementData.getProducts().stream().filter(item -> MiscUtil.equals((Object)item.getRelatedProductUID(), (Object)uid)).findFirst().map(item -> item.getFopsList()).orElse(Collections.emptyList());
        boolean fopCreateGranted = !deniedPermissions.contains(AclHelper.createPermission((String)ModelRestrictionEntityResources.ENTITY_FOP.getId(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.CREATE));
        ExtendedTableWidget.Table fopsTable = fopsExtendedTable.getTable();
        fopsTable.getViewState().setState(ViewState.composeState((boolean)fopsTable.getViewState().isReadonly(), (boolean)fopsTable.getViewState().isNotEditable(), (boolean)fopsTable.getViewState().isAclNotEditable(), (boolean)fopsTable.getViewState().isAclNotViewable(), (!fopCreateGranted ? 1 : 0) != 0, (boolean)fopsTable.getViewState().isAclNotDeletable()));
        Map<String, ExtendedTableWidget.Row> fopRows = fopsTable.getRows().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        for (ProductFopUIData fopData : fopDatas) {
            boolean fopViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)fopData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
            boolean fopEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)fopData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
            boolean fopDeleteGranted = !deniedPermissions.contains(AclHelper.createPermission((String)fopData.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE));
            ExtendedTableWidget.Row fopRow = fopRows.get(fopData.getUid());
            fopRow.getViewState().setState(ViewState.composeState((boolean)fopRow.getViewState().isReadonly(), (boolean)fopRow.getViewState().isNotEditable(), (!fopEditGranted ? 1 : 0) != 0, (!fopViewGranted ? 1 : 0) != 0, (!fopCreateGranted ? 1 : 0) != 0, (!fopDeleteGranted ? 1 : 0) != 0));
        }
    }

    protected void afterReadData(BookingFileProductFopController controller, BookingFileProductFopVM model) {
        CheckBoxWidgetColumn fromColumn = (CheckBoxWidgetColumn)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getColumn("fromContract");
        ComboBoxWidgetColumn typeColumn = (ComboBoxWidgetColumn)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getColumn("currencyType");
        TextWidgetColumn baseColumn = (TextWidgetColumn)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getColumn("baseCurrency");
        TextWidgetColumn equivColumn = (TextWidgetColumn)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getColumn("equivalentCurrency");
        DateValueWidgetColumn dateColumn = (DateValueWidgetColumn)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getColumn("conversionDate");
        DoubleValueWidgetColumn coeffColumn = (DoubleValueWidgetColumn)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getColumn("conversionCoefficient");
        DoubleValueWidgetColumn valueColumn = (DoubleValueWidgetColumn)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getColumn("conversionValue");
        for (int i = 0; i < ((TableWidget)controller.getContract().getCurrencyConversion().getView()).getRowsCount(); ++i) {
            boolean from = ((CheckBoxWidget)fromColumn.getWidget(i)).isSelected();
            ((ComboBoxWidget)typeColumn.getWidget(i)).getViewState().setNotEditable(from);
            ((TextFieldWidget)baseColumn.getWidget(i)).getViewState().setNotEditable(from);
            ((TextFieldWidget)equivColumn.getWidget(i)).getViewState().setNotEditable(from);
            ((DateValueWidget)dateColumn.getWidget(i)).getViewState().setNotEditable(from);
            ((DoubleValueWidget)coeffColumn.getWidget(i)).getViewState().setNotEditable(from);
            ((DoubleValueWidget)valueColumn.getWidget(i)).getViewState().setNotEditable(from);
            int finalI = i;
            ((CheckBoxWidget)fromColumn.getWidget(i)).getViewState().setNotEditable(false);
            ((CheckBoxWidget)fromColumn.getWidget(i)).selectedProperty().addListener((s, o, n) -> {
                if (o == n) {
                    return;
                }
                ((ComboBoxWidget)typeColumn.getWidget(finalI)).getViewState().setNotEditable(n.booleanValue());
                ((TextFieldWidget)baseColumn.getWidget(finalI)).getViewState().setNotEditable(n.booleanValue());
                ((TextFieldWidget)equivColumn.getWidget(finalI)).getViewState().setNotEditable(n.booleanValue());
                ((DateValueWidget)dateColumn.getWidget(finalI)).getViewState().setNotEditable(n.booleanValue());
                ((DoubleValueWidget)coeffColumn.getWidget(finalI)).getViewState().setNotEditable(n.booleanValue());
                ((DoubleValueWidget)valueColumn.getWidget(finalI)).getViewState().setNotEditable(n.booleanValue());
                if (n.booleanValue()) {
                    ExchangeRateData rate = ((ContractCurrencyVM)((TableWidget)controller.getContract().getCurrencyConversion().getView()).getData(finalI)).getCurrency();
                    if (rate == null) {
                        ((ComboBoxWidget)typeColumn.getWidget(finalI)).setValue(null);
                        ((TextFieldWidget)baseColumn.getWidget(finalI)).setValue(null);
                        ((TextFieldWidget)equivColumn.getWidget(finalI)).setValue(null);
                        ((DateValueWidget)dateColumn.getWidget(finalI)).setValue(null);
                        ((DoubleValueWidget)coeffColumn.getWidget(finalI)).setValue(null);
                        ((DoubleValueWidget)valueColumn.getWidget(finalI)).setValue(null);
                    } else {
                        boolean indirect = rate.getIndirectRate() != null && rate.getIndirectRate() != false;
                        ((ComboBoxWidget)typeColumn.getWidget(finalI)).setValue((Object)rate.getRateType());
                        ((TextFieldWidget)baseColumn.getWidget(finalI)).setValue(indirect ? rate.getCurrencyRateData().getBaseCurrency() : rate.getCurrencyRateData().getCurrency());
                        ((TextFieldWidget)equivColumn.getWidget(finalI)).setValue(indirect ? rate.getCurrencyRateData().getCurrency() : rate.getCurrencyRateData().getBaseCurrency());
                        ((DateValueWidget)dateColumn.getWidget(finalI)).setValue(DateUtils.asLocalDate((Date)rate.getCurrencyRateData().getDate()));
                        ((DoubleValueWidget)coeffColumn.getWidget(finalI)).setValue((Number)Optional.of(rate.getCoefficient()).orElse(1.0));
                        ((DoubleValueWidget)valueColumn.getWidget(finalI)).setValue((Number)(indirect ? 1.0 / rate.getCurrencyRateData().getRate() : rate.getCurrencyRateData().getRate()));
                    }
                }
            });
        }
    }
}

