/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfsController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticParameters;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticReasonCodesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticUdidsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductStatisticsHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingFileProductStatisticsControllerInterceptor
extends ControllerInterceptor<BookingFileProductStatisticVM, BookingFileProductStatisticController> {
    private static Map<String, AFSType> AFS_TYPES = Arrays.stream(AFSType.values()).collect(Collectors.toMap(Enum::name, type -> type));

    protected Class<BookingFileProductStatisticController> getControllerClass() {
        return BookingFileProductStatisticController.class;
    }

    protected void onCreate(BookingFileProductStatisticController controller) {
        this.filterPricesVM(controller, (EntityReference<Organization>)((EntityReference)((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).clientProperty().getValue()));
    }

    protected void afterReadData(BookingFileProductStatisticController controller, BookingFileProductStatisticVM model) {
        BookingFileProductStatisticsHelper.setupUdidsWidgetButtons(controller, model);
        BookingFileProductStatisticsHelper.updateReasonCodesTable((TableWidget<BookingFileProductStatisticReasonCodesVM>)((TableWidget)controller.getView().getStatisticNode().getReasonCodesCard().getContent()), model);
        BookingFileProductStatisticsHelper.updateUdidsTable((TableWidget<BookingFileProductStatisticUdidsVM>)((TableWidget)controller.getView().getStatisticNode().getUdidsCard().getContent()), model);
        Class productClass = controller.getData().getProductType();
        if (!(productClass.getName().equals(Product.class.getName()) || productClass.getName().equals(AdditionalServiceProduct.class.getName()) || productClass.getName().equals(ProductVoiding.class.getName()))) {
            this.hideParameters(controller);
        } else {
            this.filterPricesVM(controller, (EntityReference<Organization>)model.getStatistic().getAfs().getClient());
        }
    }

    private void hideParameters(BookingFileProductStatisticController controller, Set<AFSType> types) {
        BookingFileProductStatisticParameters panel = ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode();
        panel.getOverallDestinationCell().setHidden(!types.contains(AFSType.DEST) && ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode().getOverallDestinationNode().getValue() == null);
        panel.getValidatingCarrierCell().setHidden(!types.contains(AFSType.VALC) && ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode().getValidatingCarrierNode().getValue() == null);
        panel.getOverallClassServiceCell().setHidden(!types.contains(AFSType.OCCL) && ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode().getOverallClassServiceNode().getValue() == null);
    }

    private void hideParameters(BookingFileProductStatisticController controller) {
        BookingFileProductStatisticParameters panel = ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode();
        panel.getOverallDestinationCell().setHidden(true);
        panel.getValidatingCarrierCell().setHidden(true);
        panel.getOverallClassServiceCell().setHidden(true);
        BookingFileProductStatisticAfs afsTable = (BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent();
        if (afsTable.getProperties().get((Object)"controller") != null) {
            ((BookingFileProductStatisticAfsController)afsTable.getProperties().get((Object)"controller")).getPrices().readData(Collections.emptyList());
        }
    }

    private void filterPricesVM(BookingFileProductStatisticController controller, EntityReference<Organization> newValue) {
        if (newValue == null) {
            this.hideParameters(controller);
            return;
        }
        Notifications.get().submitTask(() -> {
            EntityContainer orgCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).loadBypassingAcl(ServiceInvocationContext.get(), newValue);
            if (orgCtr == null) {
                this.hideParameters(controller);
                return;
            }
            Organization org = (Organization)orgCtr.getEntity();
            EnumSet<AFSType> types = EnumSet.noneOf(AFSType.class);
            if (org.getAfsSettings() != null && org.getAfsSettings().length() > 0) {
                for (String str : org.getAfsSettings().split("[|]")) {
                    AFSType type = AFS_TYPES.get(str);
                    if (type == null) continue;
                    types.add(type);
                }
            }
            BookingFileProductStatisticAfs afsTable = (BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent();
            List newRows = afsTable.getPricesNode().getRowsData().stream().filter(vm -> types.contains(vm.getAfsType()) || vm.getBooking() != null || vm.getTicket() != null).collect(Collectors.toList());
            FxUtil.submitToFxThread(() -> {
                afsTable.getPricesNode().removeAllRows();
                ((BookingFileProductStatisticAfsController)afsTable.getProperties().get((Object)"controller")).getPrices().readData((Object)newRows);
                this.hideParameters(controller, types);
            });
        }, Messages.General_Data_loading);
    }
}

