/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardViewType;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler.AirProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler.McoFeesFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler.UniversalProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.scene.Node;

public class BookingFileSpaceControllerInterceptorHelper {
    public static Collection<NavigatorViewType> createViewType(BookingFileSpaceController controller, ProductFXHandler<?, ?, ?, ?> handler) {
        if (!handler.canCreateNewProduct()) {
            return Collections.emptyList();
        }
        ArrayList<NavigatorViewType> types = new ArrayList<NavigatorViewType>();
        DataTransferPackage dataTransferPackage = RootEntityPane.lookup((Node)controller.getView()).getData();
        BookingFile bookingFile = (BookingFile)dataTransferPackage.getContainer().getEntity();
        EntityReference bookingFileReference = dataTransferPackage.getContainer().toReference();
        if (handler instanceof UniversalProductFXHandler) {
            List descriptionDatas = Prefetched.getData().getUniversalProductDescriptionData();
            for (UniversalProductDescriptionData descriptionData : descriptionDatas) {
                if (descriptionData.getData().isDisabled()) continue;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("universalProductDescriptionData", descriptionData);
                parameters.put("bookingFile", bookingFile);
                parameters.put("bookingFileSpace", controller.getView());
                StandardViewType viewType = new StandardViewType(handler.getProductClass(), () -> handler.createConfigurator(parameters), configuration -> handler.createNodeForNewProduct(controller.getData(), configuration, parameters), () -> handler.createNodeForExistingProduct(controller.getData(), parameters), Messages.Own_product + descriptionData.getReference().getCaption());
                viewType.setViewFactoryForNewObject(configuration -> {
                    parameters.putAll(viewType.getCustomData());
                    return handler.createNodeForNewProduct(controller.getData(), configuration, parameters);
                });
                types.add((NavigatorViewType)viewType);
            }
        } else if (handler instanceof AirProductFXHandler) {
            List<MiscUtil.Pair> productMetaInfos = Arrays.asList(new MiscUtil.Pair((Object)ProductCategory.AIR, (Object)handler.getDisplayName()), new MiscUtil.Pair((Object)ProductCategory.MCO, (Object)Messages.Air_EMD), new MiscUtil.Pair((Object)ProductCategory.EXCESS_BAGAGE, (Object)Messages.Air_Bagage));
            for (MiscUtil.Pair productMetaInfo : productMetaInfos) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("bookingFile", bookingFile);
                parameters.put("productCategory", productMetaInfo.getFirst());
                parameters.put("bookingFileSpace", controller.getView());
                StandardViewType viewType = new StandardViewType(handler.getProductClass(), () -> handler.createConfigurator(parameters), configuration -> handler.createNodeForNewProduct(controller.getData(), configuration, parameters), () -> handler.createNodeForExistingProduct(controller.getData(), parameters), (String)productMetaInfo.getSecond());
                viewType.setViewFactoryForNewObject(configuration -> {
                    parameters.putAll(viewType.getCustomData());
                    return handler.createNodeForNewProduct(controller.getData(), configuration, parameters);
                });
                types.add((NavigatorViewType)viewType);
            }
        } else {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("bookingFile", bookingFile);
            parameters.put("bookingFileSpace", controller.getView());
            if (handler instanceof McoFeesFXHandler) {
                parameters.put("reference", bookingFileReference);
            }
            StandardViewType viewType = new StandardViewType(handler.getProductClass(), () -> handler.createConfigurator(parameters), configuration -> handler.createNodeForNewProduct(controller.getData(), configuration, parameters), () -> handler.createNodeForExistingProduct(controller.getData(), parameters), handler.getDisplayName());
            viewType.setViewFactoryForNewObject(configuration -> {
                parameters.putAll(viewType.getCustomData());
                return handler.createNodeForNewProduct(controller.getData(), configuration, parameters);
            });
            types.add((NavigatorViewType)viewType);
        }
        return types;
    }
}

