/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainer;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.system.config.RegionalVariation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.util.StringConverter;

public class ControllerInterceptorVatHelper {
    public static final StringConverter<Double> vatConverter = new StringConverter<Double>(){

        public String toString(Double object) {
            String result = object == null || object == -1.0 ? Messages.Bez_NDS : object + " %";
            return result;
        }

        public Double fromString(String string) {
            return null;
        }
    };

    public static Supplier<List<Double>> getVatGeneralSupplier() {
        if (Prefetched.getData().getRegionalVariation() == RegionalVariation.KZ) {
            return () -> Arrays.asList(12.0, 0.0, null);
        }
        return () -> Arrays.asList(20.0, 10.0, 7.0, 5.0, 0.0, null);
    }

    public static Supplier<List<Double>> getVatSimpleTaxedSupplier() {
        if (Prefetched.getData().getRegionalVariation() == RegionalVariation.KZ) {
            return Collections::emptyList;
        }
        return () -> Arrays.asList(7.0, 5.0, 0.0, null);
    }

    public static Supplier<List<Double>> getVatHotelsSupplier() {
        if (Prefetched.getData().getRegionalVariation() == RegionalVariation.KZ) {
            return () -> Arrays.asList(12.0, 0.0, null);
        }
        return () -> Arrays.asList(20.0, 18.0, 10.0, 7.0, 5.0, 0.0, null);
    }

    public static Supplier<List<Double>> getRulesVatHotelsSupplier() {
        if (Prefetched.getData().getRegionalVariation() == RegionalVariation.KZ) {
            return () -> Arrays.asList(12.0, 0.0, -1.0);
        }
        return () -> Arrays.asList(20.0, 10.0, 7.0, 5.0, 0.0, -1.0);
    }

    public static Supplier<List<Double>> getVatCwtSupplier() {
        return () -> Arrays.asList(20.0, 18.0, 10.0, 7.0, 5.0, 0.0, null);
    }

    public static void configureVatContainer(CustomVatContainer vatContainer, PriceValueWidget sourcePriceWidget) {
        ControllerInterceptorVatHelper.configureVatWidgets((ComboBoxWidget<Double>)vatContainer.getVatRateNode(), vatContainer.getVatAmountNode(), sourcePriceWidget);
    }

    public static void configureVatWidgets(ComboBoxWidget<Double> vatRate, PriceValueWidget vatAmountWidget, PriceValueWidget sourcePriceWidget) {
        vatRate.setNoNulls(true);
        vatRate.setSortItems(false);
        vatRate.setConverter(vatConverter);
        vatRate.setPromptText(null);
        vatRate.valueProperty().addListener((observable, oldValue, newValue) -> {
            BigDecimal result = (BigDecimal)sourcePriceWidget.getValue();
            result = ControllerInterceptorVatHelper.calculateVat(result, newValue);
            vatAmountWidget.setValue((Number)result);
            vatAmountWidget.getViewState().setNotEditable(vatAmountWidget.getViewState().isNotEditable());
        });
        sourcePriceWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && (oldValue == null || newValue.compareTo((BigDecimal)oldValue) != 0)) {
                Double vatValue = (Double)vatRate.getValue();
                BigDecimal result = ControllerInterceptorVatHelper.calculateVat(newValue, vatValue);
                vatAmountWidget.setValue((Number)result);
                vatAmountWidget.getViewState().setNotEditable(vatAmountWidget.getViewState().isNotEditable());
            }
        });
    }

    private static BigDecimal calculateVat(BigDecimal totalWithVat, Double vatRate) {
        BigDecimal result;
        if (vatRate == null) {
            result = null;
        } else if (totalWithVat == null) {
            result = BigDecimal.ZERO;
        } else {
            result = new BigDecimal(1.0 + vatRate / 100.0);
            result = totalWithVat.divide(result, 2, RoundingMode.HALF_UP);
            result = totalWithVat.subtract(result);
        }
        return result;
    }
}

