/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.avia;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ValuesWidgetColumn;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAirSegmentVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirCostSumPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirOtherParametersPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirStatusesPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.SabrePassiveSegmentsPane;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaAdditionalsDiscount;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaAdditionalsReports;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaAdditionalsTariff;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.avia.BookingFileProductSegmentsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductAdditionalParametersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SpecialTariff;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.TchDirectContract;
import com.gridnine.xtrip.common.model.profile.TchDirectContractIndex;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class BookingFileProductAirPanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductAirPanelVM, BookingFileProductAirPanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";
    static final String READING_DATA_KEY = "readingData";

    protected Class<BookingFileProductAirPanelController> getControllerClass() {
        return BookingFileProductAirPanelController.class;
    }

    protected void onCreate(BookingFileProductAirPanelController controller) {
        BookingFileProductAirPanel view = controller.getView();
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getTicketInfoNode().getStatusValueNode(), () -> ((BookingFileProductAirPanelController)controller).getData());
        this.additionalParameters(controller, () -> controller.getData().getUid());
        BindingUtil.addYearValidationListener(view.getGeneralNode().getTicketInfoNode().getOperationDateValueNode());
        BookingFileProductSegmentsHelper.configureSegmentsTable((TableWidget<BookingFileAirSegmentVM>)((TableWidget)view.getSegmentsNode().getContent()));
        BookingFileContractPanel tableView = (BookingFileContractPanel)view.getFopsNode().getContractNode().getView();
        if (!Prefetched.getData().isFindocsEnabled()) {
            view.getGeneralNode().getTravelerInfoNode().getShipmentsDateCaptionCell().setHidden(true);
            view.getGeneralNode().getTravelerInfoNode().getShipmentsDateValueCell().setHidden(true);
        }
        ((TableWidget)tableView.getContractsCard().getContent()).addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget contractType = (ComboBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("contractType").getWidget(ind.intValue());
            ContractType type = (ContractType)contractType.getValue();
            EntityBoxWidget manualContract = (EntityBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("manualContract").getWidget(ind.intValue());
            manualContract.setListParametersSupplier(() -> {
                IndexListParameters<Contract, ContractIndex> contractsByType = ControllerInterceptorsHelper.getContractsByType((ContractType)contractType.getValue());
                BookingFileSpace pane = (BookingFileSpace)RootEntityPane.lookup((Node)controller.getView()).getEditor();
                EntityReference client = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)pane.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
                EntityReference blankOwner = view.getGeneralNode().getSalesChainNode().getBlankOwnerValueNode().getBlankOwnerCodeNode().getValue();
                EntityReference supplier = view.getGeneralNode().getSalesChainNode().getSupplierValueNode().getValue();
                EntityReference agency = view.getGeneralNode().getSalesChainNode().getAgencyValueNode().getValue();
                EntityReference subagency = view.getGeneralNode().getSalesChainNode().getSubagencyValueNode().getValue();
                if (type.equals((Object)ContractType.CLIENT)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)client));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.SUBAGENCY)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)agency));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.VENDOR)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)blankOwner)}));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)agency));
                }
                contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
                return contractsByType;
            });
        });
    }

    protected void beforeWriteData(BookingFileProductAirPanelController controller, BookingFileProductAirPanelVM model) {
        model.setProductType(Product.class);
    }

    protected void beforeReadData(BookingFileProductAirPanelController controller, BookingFileProductAirPanelVM model) {
        TableWidget tableWidget = (TableWidget)controller.getView().getSegmentsNode().getContent();
        tableWidget.getProperties().put((Object)READING_DATA_KEY, (Object)true);
    }

    protected void afterReadData(BookingFileProductAirPanelController controller, BookingFileProductAirPanelVM model) {
        ObservableMap properties = controller.getView().getProperties();
        properties.put((Object)"segmentsPoints", new HashMap());
        TableWidget tableWidget = (TableWidget)controller.getView().getSegmentsNode().getContent();
        tableWidget.getProperties().remove((Object)READING_DATA_KEY);
        model.getBookingFile().getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> TextUtil.isSame((String)product.getUid(), (String)controller.getData().getUid())).findFirst().ifPresent(baseProduct -> {
            final Product product = (Product)baseProduct;
            controller.getView().getProperties().put((Object)"category", (Object)product.getProductCategory());
            controller.getView().getProperties().put((Object)"mcoCategory", (Object)product.getMcoCategory());
            boolean isHiddenFineCell = (product.getPreviousProduct() == null || !product.getPreviousProduct().getStatus().equals((Object)ProductStatus.EXCHANGE) || !product.getStatus().equals((Object)ProductStatus.SELL)) && !product.getStatus().equals((Object)ProductStatus.REFUND);
            BookingFileProductAirCostSumPane costSum = controller.getView().getCostNode().getSumNode();
            costSum.getFineValueCell().setHidden(isHiddenFineCell);
            costSum.getFineCaptionCell().setHidden(isHiddenFineCell);
            costSum.getFineTAXValueCell().setHidden(isHiddenFineCell);
            costSum.getFineCurrencyValueCell().setHidden(isHiddenFineCell);
            ProductFXHandler<Product, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(product);
            ProductStatus productStatus = productFXHandler.getProductStatus(product);
            ((BookingFileProductAirStatusesPane)controller.getView().getStatusesCell().getPayload()).getForcedRefundCell().setHidden(productStatus != ProductStatus.REFUND && productStatus != ProductStatus.EXCHANGE);
            ValuesWidgetColumn column = (ValuesWidgetColumn)((TableWidget)controller.getCost().getCell4().getContent().getView()).getColumn("taxesUids");
            column.setItemsSupplier(() -> product.getTaxes().stream().sorted(Comparator.comparing(it -> it.getCode() == null ? "" : it.getCode())).map(t -> t.getUid()).collect(Collectors.toList()));
            column.setConverter((StringConverter)new StringConverter<String>(){

                public String toString(String object) {
                    return product.getTaxes().stream().filter(t -> t.getUid().equals(object)).map(t -> t.getCode() == null ? "" : t.getCode()).findFirst().orElse(null);
                }

                public String fromString(String string) {
                    return null;
                }
            });
        });
        Optional<BaseProductUIData> productUIData = Optional.ofNullable(model.getProductUiData());
        controller.getView().getGeneralNode().getSalesChainNode().getAgencyValueNode().getViewState().setNotEditable(productUIData.map(BaseProductUIData::isHasSubagentRelatedShipment).orElse(false).booleanValue());
        controller.getView().getGeneralNode().getSalesChainNode().getSubagencyValueNode().getViewState().setNotEditable(productUIData.map(data -> data.isHasClientRelatedShipment() || data.isHasSubagentRelatedShipment()).orElse(false).booleanValue());
    }

    private void additionalParameters(BookingFileProductAirPanelController controller, Supplier<String> getProductUID) {
        BookingFileProductAirOtherParametersPanel otherParamsPanel = controller.getView().getOtherParametersNode();
        BookingFileProductAdditionalParametersHelper.setStringConverters(((BookingFileProductAviaAdditionalsReports)otherParamsPanel.getReportsCard().getContent()).getReturnFareDifferenceNode(), ((BookingFileProductAviaAdditionalsTariff)otherParamsPanel.getTariffCard().getContent()).getSubsidizedTariffNode());
        ((BookingFileProductAviaAdditionalsTariff)otherParamsPanel.getTariffCard().getContent()).getSpecialTariffNode().setItemsSupplier(Suppliers.createEnumSupplier(SpecialTariff.class));
        NestedEntityBoxWidget tchWidget = ((BookingFileProductAviaAdditionalsReports)otherParamsPanel.getReportsCard().getContent()).getTchDirectContractNode();
        tchWidget.setFieldName(Messages.Direct_contract);
        tchWidget.setListParametersSupplier(BookingFileProductAdditionalParametersHelper.tchContractListParametersSupplier());
        tchWidget.setConverter(BookingFileProductAdditionalParametersHelper.tchContractConverter());
        tchWidget.setNestedReferenceBuilder(idx -> new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), TchDirectContract.class, ((TchDirectContractIndex)idx).getContractName()));
        EntityBoxWidget contractWidget = ((BookingFileProductAviaAdditionalsDiscount)otherParamsPanel.getDiscountCard().getContent()).getContractNode();
        contractWidget.setFieldName(Messages.Contract);
        contractWidget.setListParametersSupplier(BookingFileProductAdditionalParametersHelper.contractListParametersSupplier());
        BookingFileProductAdditionalParametersHelper.setupQuotaForwardWidgets(otherParamsPanel, getProductUID);
        BookingFileProductAdditionalParametersHelper.setupQuotaBackwardWidgets(otherParamsPanel, getProductUID);
        BookingFileProductAdditionalParametersHelper.configurePassiveSegmentsWidget((PopupWidget<SabrePassiveSegmentsPane>)controller.getOtherParameters().getPopups().getView().getPassiveSegmentsNode(), () -> controller.getData().getUid());
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductAirPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
        String productSubagencyUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId());
        boolean productSubagencyViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSubagencyEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSubagencyCaptionCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueNode().getViewState().setAclNotEditable(!productSubagencyEditGranted);
        String productTourCodeUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_TOUR_CODE.getId());
        boolean productTourCodeViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productTourCodeUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productTourCodeEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productTourCodeUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getTourCodeCaptionCell().setHidden(!productTourCodeViewGranted);
        controller.getGeneral().getTravelerInfo().getView().getTourCodeValueCell().setHidden(!productTourCodeViewGranted);
        controller.getGeneral().getTravelerInfo().getView().getTourCodeValueNode().getViewState().setAclNotEditable(!productTourCodeEditGranted);
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

