/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.avia;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ValuesWidgetColumn;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirCostPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirCostPaneController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirCostPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirCostSumPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirFeesAndChargesPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirTariffComponentsPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirVatDetailsPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRatesPaneController;
import com.gridnine.xtrip.client.fx.model.booking.SegmentsData;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import java.util.Arrays;
import javafx.util.StringConverter;

public class BookingFileProductAviaCostControllerInterceptor
extends ControllerInterceptor<BookingFileProductAirCostPaneVM, BookingFileProductAirCostPaneController> {
    protected Class<BookingFileProductAirCostPaneController> getControllerClass() {
        return BookingFileProductAirCostPaneController.class;
    }

    protected void beforeReadData(BookingFileProductAirCostPaneController controller, BookingFileProductAirCostPaneVM model) {
        BookingFileProductAviaCostControllerInterceptor.setupTaxTable(controller.getView(), model);
        BookingFileProductAviaCostControllerInterceptor.setupTariffTable(controller.getView(), model);
    }

    protected void onCreate(BookingFileProductAirCostPaneController controller) {
        BookingFileProductAirCostPane view = controller.getView();
        BookingFileProductAviaCostControllerInterceptor.setChildTaxTableSegmentsConverter(view);
        BookingFileProductAviaCostControllerInterceptor.setChildTariffTableSegmentsConverter(view);
        BookingFileProductAviaCostControllerInterceptor.setupVatsTable(controller, view);
        BookingFileProductAviaCostControllerInterceptor.setupVatPrompt(view);
    }

    private static void setupVatPrompt(BookingFileProductAirCostPane view) {
        PriceValueWidget totalTAXValueNode = view.getSumNode().getTotalTAXValueNode();
        totalTAXValueNode.setPromptText(Messages.noVat);
    }

    protected void afterReadData(BookingFileProductAirCostPaneController controller, BookingFileProductAirCostPaneVM model) {
        BookingFileProductRatesPaneController rates = controller.getRates();
        if (rates.getBaseCurrencyValue() != null) {
            controller.getView().getRatesCell().setHidden(rates.getBaseCurrencyValue().equals(rates.getEqCurrencyValue()));
        }
        if (!model.isExchange()) {
            BookingFileProductAirCostSumPane sumCell = (BookingFileProductAirCostSumPane)controller.getView().getSumCell().getPayload();
            Arrays.asList(sumCell.getAdditionCaptionCell(), sumCell.getBaseAdditionValueCell(), sumCell.getEqAdditionValueCell(), sumCell.getAdditionalAdditionValueCell(), sumCell.getSumTaxAdditionValueCell(), sumCell.getFineAdditionValueCell(), sumCell.getTotalAdditionValueCell()).forEach(cell -> cell.setHidden(true));
            PopupWidget popupWidget = (PopupWidget)controller.getView().getCell1Cell().getPayload();
            TableWidget taxTable = (TableWidget)((BookingFileProductAirFeesAndChargesPane)popupWidget.getView()).getContent();
            TableWidgetColumn additionColumn2 = taxTable.getColumn("addition");
            taxTable.hideColumn(additionColumn2);
        }
    }

    private static void setupTaxTable(BookingFileProductAirCostPane view, BookingFileProductAirCostPaneVM model) {
        PopupWidget popupWidget = (PopupWidget)view.getCell1Cell().getPayload();
        TableWidget taxTable = (TableWidget)((BookingFileProductAirFeesAndChargesPane)popupWidget.getView()).getContent();
        ComboBoxWidgetColumn segmentsColumn1 = (ComboBoxWidgetColumn)taxTable.getColumn("segments");
        segmentsColumn1.setConverter(BookingFileProductAviaCostControllerInterceptor.segmentsConverter());
        segmentsColumn1.setItemsSupplier(() -> ((BookingFileProductAirCostPaneVM)model).getSegmentsData());
    }

    private static void setChildTaxTableSegmentsConverter(BookingFileProductAirCostPane view) {
        PopupWidget popupWidget = (PopupWidget)view.getCell1Cell().getPayload();
        TableWidget taxTable = (TableWidget)((BookingFileProductAirFeesAndChargesPane)popupWidget.getView()).getContent();
        ComboBoxWidgetColumn taxSegmentsColumn = (ComboBoxWidgetColumn)taxTable.getColumn("segments");
        taxSegmentsColumn.setConverter(BookingFileProductAviaCostControllerInterceptor.segmentsConverter());
    }

    private static void setChildTariffTableSegmentsConverter(BookingFileProductAirCostPane view) {
        TableWidget tariffTable = (TableWidget)((BookingFileProductAirTariffComponentsPane)((PopupWidget)view.getCell3Cell().getPayload()).getView()).getContent();
        ComboBoxWidgetColumn tariffSegmentsColumn = (ComboBoxWidgetColumn)tariffTable.getColumn("segments");
        tariffSegmentsColumn.setConverter(BookingFileProductAviaCostControllerInterceptor.segmentsConverter());
    }

    private static void setupTariffTable(BookingFileProductAirCostPane view, BookingFileProductAirCostPaneVM model) {
        TableWidget tariffTable = (TableWidget)((BookingFileProductAirTariffComponentsPane)((PopupWidget)view.getCell3Cell().getPayload()).getView()).getContent();
        ComboBoxWidgetColumn segmentsColumn3 = (ComboBoxWidgetColumn)tariffTable.getColumn("segments");
        segmentsColumn3.setConverter(BookingFileProductAviaCostControllerInterceptor.segmentsConverter());
        segmentsColumn3.setItemsSupplier(() -> ((BookingFileProductAirCostPaneVM)model).getSegmentsData());
    }

    private static void setupVatsTable(BookingFileProductAirCostPaneController controller, BookingFileProductAirCostPane view) {
        TableWidget vatTable = (TableWidget)((BookingFileProductAirVatDetailsPane)((PopupWidget)view.getCell4Cell().getPayload()).getView()).getContent();
        ValuesWidgetColumn typesColumn = (ValuesWidgetColumn)vatTable.getColumn("basisTypes");
        typesColumn.setItemsSupplier(Suppliers.createEnumSupplier(VatBasisType.class));
        PriceValueWidgetColumn rateColumn = (PriceValueWidgetColumn)vatTable.getColumn("rate");
        PriceValueWidgetColumn sumColumn = (PriceValueWidgetColumn)vatTable.getColumn("sum");
        vatTable.addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            PriceValueWidget rateWidget = (PriceValueWidget)rateColumn.getWidget(ind.intValue());
            rateWidget.setPromptText(Messages.noVat);
            PriceValueWidget sumWidget = (PriceValueWidget)sumColumn.getWidget(ind.intValue());
            sumWidget.setPromptText(Messages.noVat);
        });
    }

    public static StringConverter<SegmentsData> segmentsConverter() {
        return new StringConverter<SegmentsData>(){

            public String toString(SegmentsData data) {
                return data == null ? null : data.getDescription();
            }

            public SegmentsData fromString(String string) {
                return null;
            }
        };
    }
}

