/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.avia;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.HyperlinkWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageRelatedProductsController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageRelatedProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.AddProductsDialog;
import com.gridnine.xtrip.client.fx.standard.helpers.BookingFileSpaceHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.scene.Node;

public class BookingFileProductBagageRelatedProductsControllerInterceptor
extends ControllerInterceptor<BookingFileProductBagageRelatedProductsVM, BookingFileProductBagageRelatedProductsController> {
    protected Class<BookingFileProductBagageRelatedProductsController> getControllerClass() {
        return BookingFileProductBagageRelatedProductsController.class;
    }

    protected void afterReadData(final BookingFileProductBagageRelatedProductsController controller, final BookingFileProductBagageRelatedProductsVM model) {
        TableWidget productTableWidget = controller.getView().getRelatedProductsNode();
        IntStream.range(0, productTableWidget.getRowsCount()).forEach(index -> BookingFileProductBagageRelatedProductsControllerInterceptor.setActionLink((TableWidget<BookingFileProductBagageRelatedProductsTableVM>)productTableWidget, index));
        productTableWidget.setItemsProvider((MultiProvider)new MultiProvider<BookingFileProductBagageRelatedProductsTableVM>(){

            public BookingFileProductBagageRelatedProductsTableVM createOne() {
                return new BookingFileProductBagageRelatedProductsTableVM();
            }

            public void createAny(Consumer<Collection<BookingFileProductBagageRelatedProductsTableVM>> consumer) {
                ArrayList alreadySelected = new ArrayList();
                controller.getRelatedProducts().writeData(alreadySelected);
                ArrayList<String> usedUids = new ArrayList<String>();
                usedUids.add(model.getProductUid());
                usedUids.addAll(alreadySelected.stream().map(p -> p.getProductUID()).collect(Collectors.toList()));
                List<Product> products = model.getBookingFile().getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(p -> !usedUids.contains(p.getUid()) && p instanceof Product).map(bp -> (Product)bp).collect(Collectors.toList());
                RootEntityPane rootEntityPane = Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView()));
                AddProductsDialog dialog = new AddProductsDialog(rootEntityPane.getEditor(), products);
                dialog.showDialog(() -> {
                    List rows = dialog.getSelectedProducts().stream().map(selectedProduct -> {
                        Product product = (Product)((BookingFile)rootEntityPane.getData().getContainer().getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(arg_0 -> ((Product)selectedProduct).equals(arg_0)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)("Unknown product with uid " + selectedProduct.getUid()), (Object[])new Object[0]));
                        BookingFileProductBagageRelatedProductsTableVM productVM = new BookingFileProductBagageRelatedProductsTableVM();
                        productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)product));
                        productVM.setProductUID(product.getUid());
                        return productVM;
                    }).collect(Collectors.toList());
                    consumer.accept(rows);
                });
            }
        });
        productTableWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int idx = event.getRowIndex();
                BookingFileProductBagageRelatedProductsControllerInterceptor.setActionLink((TableWidget<BookingFileProductBagageRelatedProductsTableVM>)productTableWidget, idx);
            }
        });
    }

    private static void setActionLink(TableWidget<BookingFileProductBagageRelatedProductsTableVM> productTableWidget, int ind) {
        HyperlinkWidgetColumn productHyperlinkWidgetColumn = (HyperlinkWidgetColumn)productTableWidget.getColumn("product");
        HyperlinkWidget hyperlinkWidget = (HyperlinkWidget)productHyperlinkWidgetColumn.getWidget(ind);
        String productUID = ((BookingFileProductBagageRelatedProductsTableVM)productTableWidget.getData(ind)).getProductUID();
        hyperlinkWidget.setOnAction(evt -> {
            BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace((Node)productTableWidget);
            CompactNavigatorWidget widget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent();
            Node node = UiUtil.findViewWithModelUid((Iterable)widget.getViews(), (String)productUID);
            if (node != null) {
                widget.selectView(node);
            }
        });
    }
}

