/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.avia;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.HyperlinkWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDRelatedProductsController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDRelatedProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.AddProductsDialog;
import com.gridnine.xtrip.client.fx.standard.helpers.BookingFileSpaceHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.scene.Node;

public class BookingFileProductEMDRelatedProductsControllerInterceptor
extends ControllerInterceptor<BookingFileProductEMDRelatedProductsVM, BookingFileProductEMDRelatedProductsController> {
    protected Class<BookingFileProductEMDRelatedProductsController> getControllerClass() {
        return BookingFileProductEMDRelatedProductsController.class;
    }

    protected void onCreate(BookingFileProductEMDRelatedProductsController controller) {
        TableWidget productTableWidget = controller.getView().getRelatedProductsNode();
        productTableWidget.setItemsProvider(this.createItemsProvider(controller, null));
        this.setOnRowsAction((TableWidget<BookingFileProductEMDRelatedProductsTableVM>)productTableWidget);
    }

    private void setOnRowsAction(TableWidget<BookingFileProductEMDRelatedProductsTableVM> productTableWidget) {
        productTableWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int idx = event.getRowIndex();
                BookingFileProductEMDRelatedProductsControllerInterceptor.setActionLink(productTableWidget, idx);
            }
        });
    }

    protected void afterReadData(BookingFileProductEMDRelatedProductsController controller, BookingFileProductEMDRelatedProductsVM model) {
        TableWidget productTableWidget = controller.getView().getRelatedProductsNode();
        IntStream.range(0, productTableWidget.getRowsCount()).forEach(index -> BookingFileProductEMDRelatedProductsControllerInterceptor.setActionLink((TableWidget<BookingFileProductEMDRelatedProductsTableVM>)productTableWidget, index));
        productTableWidget.setItemsProvider(this.createItemsProvider(controller, model));
        this.setOnRowsAction((TableWidget<BookingFileProductEMDRelatedProductsTableVM>)productTableWidget);
    }

    private MultiProvider<BookingFileProductEMDRelatedProductsTableVM> createItemsProvider(final BookingFileProductEMDRelatedProductsController controller, final BookingFileProductEMDRelatedProductsVM model) {
        return new MultiProvider<BookingFileProductEMDRelatedProductsTableVM>(){

            public BookingFileProductEMDRelatedProductsTableVM createOne() {
                return new BookingFileProductEMDRelatedProductsTableVM();
            }

            public void createAny(Consumer<Collection<BookingFileProductEMDRelatedProductsTableVM>> consumer) {
                ArrayList alreadySelected = new ArrayList();
                controller.getRelatedProducts().writeData(alreadySelected);
                ArrayList<String> usedUids = new ArrayList<String>();
                if (model != null) {
                    usedUids.add(model.getProductUid());
                }
                usedUids.addAll(alreadySelected.stream().map(p -> p.getProductUID()).collect(Collectors.toList()));
                RootEntityPane rootEntityPane = Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView()));
                BookingFile bookingFile = (BookingFile)rootEntityPane.getData().getContainer().getEntity();
                List<Product> products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(p -> !usedUids.contains(p.getUid()) && p instanceof Product).map(bp -> (Product)bp).collect(Collectors.toList());
                AddProductsDialog dialog = new AddProductsDialog(rootEntityPane.getEditor(), products);
                dialog.showDialog(() -> {
                    List rows = dialog.getSelectedProducts().stream().map(selectedProduct -> {
                        Product product = (Product)bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(arg_0 -> ((Product)selectedProduct).equals(arg_0)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)("Unknown product with uid " + selectedProduct.getUid()), (Object[])new Object[0]));
                        BookingFileProductEMDRelatedProductsTableVM productVM = new BookingFileProductEMDRelatedProductsTableVM();
                        productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)product));
                        productVM.setProductUID(product.getUid());
                        return productVM;
                    }).collect(Collectors.toList());
                    consumer.accept(rows);
                });
            }
        };
    }

    private static void setActionLink(TableWidget<BookingFileProductEMDRelatedProductsTableVM> productTableWidget, int ind) {
        HyperlinkWidgetColumn productHyperlinkWidgetColumn = (HyperlinkWidgetColumn)productTableWidget.getColumn("product");
        HyperlinkWidget hyperlinkWidget = (HyperlinkWidget)productHyperlinkWidgetColumn.getWidget(ind);
        String productUID = ((BookingFileProductEMDRelatedProductsTableVM)productTableWidget.getData(ind)).getProductUID();
        hyperlinkWidget.setOnAction(evt -> {
            BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace((Node)productTableWidget);
            CompactNavigatorWidget widget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent();
            Node node = UiUtil.findViewWithModelUid((Iterable)widget.getViews(), (String)productUID);
            if (node != null) {
                widget.selectView(node);
            }
        });
    }
}

