/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.carrental;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersCost;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersCostSum;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersOwner;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRatesPaneController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductParametersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Optional;
import java.util.Set;
import javafx.scene.Node;

public class BookingFileProductCarRentalPanelControllerInterceptor
extends ControllerInterceptor<BookingFileCarRentalPanelVM, BookingFileCarRentalPanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";

    protected Class<BookingFileCarRentalPanelController> getControllerClass() {
        return BookingFileCarRentalPanelController.class;
    }

    protected void onCreate(BookingFileCarRentalPanelController controller) {
        super.onCreate((ViewController)controller);
        BookingFileCarRentalPanel view = controller.getView();
        BookingFileProductCarRentalParametersCostSum node = view.getCostNode().getSumCellNode();
        BindingUtil.addYearValidationListener(view.getGeneralNode().getBaseInformationParametersNode().getOperationDateValueNode());
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getBaseInformationParametersNode().getStatusValueNode(), () -> ((BookingFileCarRentalPanelController)controller).getData());
        view.getStatusesNode().getCheckedNode().setConverter(Converters.boolConverter((String)Messages.Checked, (String)Messages.Unchecked));
        view.getStatusesNode().getFinishedNode().setConverter(Converters.boolConverter((String)Messages.Finished, (String)Messages.Not_finished));
        view.getStatusesNode().getHasErrorsNode().setConverter(Converters.boolConverter((String)Messages.Has_errors, (String)Messages.Has_not_errors));
        view.getStatusesNode().getHasWarningsNode().setConverter(Converters.boolConverter((String)Messages.Has_warnings, (String)Messages.Has_not_warnings));
        view.getStatusesNode().getRulesAppliedNode().setConverter(Converters.boolConverter((String)Messages.Rules_applied, (String)Messages.Rules_not_applied));
        BookingFileProductCarRentalParametersOwner ownerNode = view.getGeneralNode().getOwnerParametersNode();
        ownerNode.getBlankOwnerValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        ownerNode.getAgencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getSubagencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getPrescribeAgentValueNode().setListParametersSupplier(() -> {
            EntityReference spRef = ownerNode.getSalesPointValueNode().getValue();
            return ControllerInterceptorsHelper.getAgentsForSalesPoint((EntityReference<SalesPoint>)spRef);
        });
        ownerNode.getSupplierValueNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersMulti());
        if (!Prefetched.getData().isFindocsEnabled()) {
            ownerNode.getShipmentsDateCaptionCell().setHidden(true);
            ownerNode.getShipmentsDateValueCell().setHidden(true);
        }
        BookingFileProductParametersHelper.configureSupplierPoints((EntityBoxWidget<Organization>)ownerNode.getSubagencyValueNode(), (EntityBoxWidget<SalesPoint>)ownerNode.getSalesPointValueNode());
        CustomVatContainer vatContainer = node.getVatIncludedEqTariffNode();
        vatContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        ControllerInterceptorVatHelper.configureVatContainer(vatContainer, node.getEqTariffSumNode());
        CustomVatContainer vatPenaltyContainer = node.getVatIncludedPenaltyNode();
        vatPenaltyContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        ControllerInterceptorVatHelper.configureVatContainer(vatPenaltyContainer, node.getPenaltySumNode());
        BookingFileContractPanel tableView = (BookingFileContractPanel)view.getFopsNode().getContractNode().getView();
        ((TableWidget)tableView.getContractsCard().getContent()).addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget contractType = (ComboBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("contractType").getWidget(ind.intValue());
            ContractType type = (ContractType)contractType.getValue();
            EntityBoxWidget manualContract = (EntityBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("manualContract").getWidget(ind.intValue());
            manualContract.setListParametersSupplier(() -> {
                IndexListParameters<Contract, ContractIndex> contractsByType = ControllerInterceptorsHelper.getContractsByType((ContractType)contractType.getValue());
                BookingFileSpace pane = (BookingFileSpace)RootEntityPane.lookup((Node)view).getEditor();
                EntityReference client = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)pane.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
                EntityReference blankOwner = view.getGeneralNode().getOwnerParametersNode().getBlankOwnerValueNode().getValue();
                EntityReference supplier = view.getGeneralNode().getOwnerParametersNode().getSupplierValueNode().getValue();
                EntityReference agency = view.getGeneralNode().getOwnerParametersNode().getAgencyValueNode().getValue();
                EntityReference subagency = view.getGeneralNode().getOwnerParametersNode().getSubagencyValueNode().getValue();
                if (type.equals((Object)ContractType.CLIENT)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)client));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.SUBAGENCY)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)agency));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.VENDOR)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)blankOwner)}));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)agency));
                }
                contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
                return contractsByType;
            });
        });
    }

    protected void beforeWriteData(BookingFileCarRentalPanelController controller, BookingFileCarRentalPanelVM model) {
        model.setProductType(CarRentalProduct.class);
    }

    protected void afterReadData(BookingFileCarRentalPanelController controller, BookingFileCarRentalPanelVM model) {
        controller.getView().getProperties().put((Object)"status", (Object)model.getStatus());
        String productStatus = model.getGeneral().getBaseInformationParameters().getStatusValue();
        CustomVatContainer vatNode = controller.getView().getCostNode().getSumCellNode().getVatIncludedPenaltyNode();
        if (productStatus.equals(ProductStatus.SELL.toString())) {
            vatNode.getVatRateNode().getViewState().setNotEditable(true);
            vatNode.getVatAmountNode().getViewState().setNotEditable(true);
        } else {
            vatNode.getVatRateNode().getViewState().setNotEditable(false);
            vatNode.getVatAmountNode().getViewState().setNotEditable(false);
        }
        controller.getData().getBookingFile().getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> TextUtil.isSame((String)product.getUid(), (String)controller.getData().getUid())).findFirst().ifPresent(baseProduct -> {
            CarRentalProduct product = (CarRentalProduct)baseProduct;
            boolean isHiddenFineCell = (product.getPreviousProduct() == null || !product.getPreviousProduct().getStatus().equals((Object)ProductStatus.EXCHANGE) || !product.getStatus().equals((Object)ProductStatus.SELL)) && !product.getStatus().equals((Object)ProductStatus.REFUND);
            BookingFileProductCarRentalParametersCostSum costSum = controller.getView().getCostNode().getSumCellNode();
            costSum.getPenaltyCurrencyCell().setHidden(isHiddenFineCell);
            costSum.getVatIncludedPenaltyCell().setHidden(isHiddenFineCell);
            costSum.getPenaltySumCell().setHidden(isHiddenFineCell);
            costSum.getPenaltyCaptionCell().setHidden(isHiddenFineCell);
        });
        BookingFileProductRatesPaneController ratesController = controller.getCost().getRates();
        BookingFileProductCarRentalParametersCost costView = controller.getCost().getView();
        if (ratesController.getBaseCurrencyValue() != null) {
            costView.getRatesCell().setHidden(ratesController.getBaseCurrencyValue().equals(ratesController.getEqCurrencyValue()));
        }
        Optional<BaseProductUIData> productUIData = Optional.ofNullable(model.getProductUiData());
        controller.getView().getGeneralNode().getOwnerParametersNode().getAgencyValueNode().getViewState().setNotEditable(productUIData.map(BaseProductUIData::isHasSubagentRelatedShipment).orElse(false).booleanValue());
        controller.getView().getGeneralNode().getOwnerParametersNode().getSubagencyValueNode().getViewState().setNotEditable(productUIData.map(productData -> productData.isHasClientRelatedShipment() || productData.isHasSubagentRelatedShipment()).orElse(false).booleanValue());
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileCarRentalPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getPrescribeAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getPrescribeAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getPrescribeAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
        String productSubagencyUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId());
        boolean productSubagencyViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSubagencyEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getSubagencyCaptionCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSubagencyValueCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSubagencyValueNode().getViewState().setAclNotEditable(!productSubagencyEditGranted);
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

