/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirOtherParametersPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAviaAdditionalPopups;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAviaCharterQuotaBinding;
import com.gridnine.xtrip.client.fx.model.booking.SabrePassiveSegmentsPane;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaCharterBackwardQuota;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaCharterForwardQuota;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.BlockCharterAppendixIndex;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.profile.TchDirectContract;
import com.gridnine.xtrip.common.model.profile.TchDirectContractIndex;
import com.gridnine.xtrip.common.model.profile.VendorContractType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class BookingFileProductAdditionalParametersHelper {
    public static void setupQuotaForwardWidgets(BookingFileProductAirOtherParametersPanel view, Supplier<String> getProductUID) {
        ObservableMutex mutex = ObservableMutex.lookup((Node)view);
        BookingFileProductAviaCharterForwardQuota charterForwardQuota = (BookingFileProductAviaCharterForwardQuota)((BookingFileProductAviaCharterQuotaBinding)((BookingFileProductAviaAdditionalPopups)view.getPopupsCard().getContent()).getCharterBindingNode().getView()).getForwardQuotaCard().getContent();
        ComboBoxWidget classOfBookingForwardWidget = charterForwardQuota.getTariffClassOfBookingNode();
        classOfBookingForwardWidget.setConverter((StringConverter)new StringConverter<SUBlockCharterTariffInfo>(){

            public String toString(SUBlockCharterTariffInfo tariff) {
                return tariff == null ? null : tariff.getClassOfBooking();
            }

            public SUBlockCharterTariffInfo fromString(String string) {
                return null;
            }
        });
        ComboBoxWidget flightDateForwardWidget = charterForwardQuota.getQuotaDateNode();
        flightDateForwardWidget.setItemsSupplier(() -> BookingFileProductAdditionalParametersHelper.getDates((SUBlockCharterTariffInfo)classOfBookingForwardWidget.getValue(), false));
        ComboBoxWidget flightNoForwardWidget = charterForwardQuota.getQuotaFlightNoNode();
        flightNoForwardWidget.setItemsSupplier(() -> BookingFileProductAdditionalParametersHelper.getFlightNo((SUBlockCharterTariffInfo)classOfBookingForwardWidget.getValue(), (LocalDate)flightDateForwardWidget.getValue(), false));
        NestedEntityBoxWidget appendixForwardWidget = charterForwardQuota.getAppendixNode();
        appendixForwardWidget.setFieldName(Messages.Application);
        appendixForwardWidget.setNestedReferenceBuilder(BookingFileProductAdditionalParametersHelper.getAppendixEntityBuilder());
        appendixForwardWidget.setListParametersSupplier(BookingFileProductAdditionalParametersHelper.appendixListParametersSupplier(Collections.emptyList()));
        appendixForwardWidget.valueProperty().addListener((obj, old, val) -> BookingFileProductAdditionalParametersHelper.setClassOfBookingSupplier((EntityReference<Contract>)val, (ComboBoxWidget<SUBlockCharterTariffInfo>)classOfBookingForwardWidget, mutex));
        EntityBoxWidget contractForwardWidget = charterForwardQuota.getContractNode();
        contractForwardWidget.setFieldName(Messages.Contract);
        contractForwardWidget.setListParametersSupplier(BookingFileProductAdditionalParametersHelper.charterContractListParametersSupplier());
        contractForwardWidget.valueProperty().addListener((src, old, val) -> BookingFileProductAdditionalParametersHelper.setupAppendixSupplier(view, (EntityReference<Contract>)val, (NestedEntityBoxWidget<Contract, SUBlockCharterAppendix>)appendixForwardWidget, (String)getProductUID.get(), mutex));
    }

    public static void setupQuotaBackwardWidgets(BookingFileProductAirOtherParametersPanel view, Supplier<String> getProductUID) {
        ObservableMutex mutex = ObservableMutex.lookup((Node)view);
        BookingFileProductAviaCharterBackwardQuota charterBackwardQuota = (BookingFileProductAviaCharterBackwardQuota)((BookingFileProductAviaCharterQuotaBinding)((BookingFileProductAviaAdditionalPopups)view.getPopupsCard().getContent()).getCharterBindingNode().getView()).getBackwardQuotaCard().getContent();
        ComboBoxWidget classOfBookingBackwardWidget = charterBackwardQuota.getTariffClassOfBookingNode();
        classOfBookingBackwardWidget.setConverter((StringConverter)new StringConverter<SUBlockCharterTariffInfo>(){

            public String toString(SUBlockCharterTariffInfo tariff) {
                return tariff == null ? null : tariff.getClassOfBooking();
            }

            public SUBlockCharterTariffInfo fromString(String string) {
                return null;
            }
        });
        ComboBoxWidget flightDateBackwardWidget = charterBackwardQuota.getQuotaDateNode();
        flightDateBackwardWidget.setItemsSupplier(() -> BookingFileProductAdditionalParametersHelper.getDates((SUBlockCharterTariffInfo)classOfBookingBackwardWidget.getValue(), true));
        ComboBoxWidget flightNoBackwardWidget = charterBackwardQuota.getQuotaFlightNoNode();
        flightNoBackwardWidget.setItemsSupplier(() -> BookingFileProductAdditionalParametersHelper.getFlightNo((SUBlockCharterTariffInfo)classOfBookingBackwardWidget.getValue(), (LocalDate)flightDateBackwardWidget.getValue(), true));
        NestedEntityBoxWidget appendixBackwardWidget = charterBackwardQuota.getAppendixNode();
        appendixBackwardWidget.setFieldName(Messages.Application);
        appendixBackwardWidget.setNestedReferenceBuilder(BookingFileProductAdditionalParametersHelper.getAppendixEntityBuilder());
        appendixBackwardWidget.setListParametersSupplier(BookingFileProductAdditionalParametersHelper.appendixListParametersSupplier(Collections.emptyList()));
        appendixBackwardWidget.valueProperty().addListener((obj, old, val) -> BookingFileProductAdditionalParametersHelper.setClassOfBookingSupplier((EntityReference<Contract>)val, (ComboBoxWidget<SUBlockCharterTariffInfo>)classOfBookingBackwardWidget, mutex));
        EntityBoxWidget contractBackwardWidget = charterBackwardQuota.getContractNode();
        contractBackwardWidget.setFieldName(Messages.Contract);
        contractBackwardWidget.setListParametersSupplier(BookingFileProductAdditionalParametersHelper.charterContractListParametersSupplier());
        contractBackwardWidget.valueProperty().addListener((src, old, val) -> BookingFileProductAdditionalParametersHelper.setupAppendixSupplier(view, (EntityReference<Contract>)val, (NestedEntityBoxWidget<Contract, SUBlockCharterAppendix>)appendixBackwardWidget, (String)getProductUID.get(), mutex));
    }

    private static void setupAppendixSupplier(BookingFileProductAirOtherParametersPanel view, EntityReference<Contract> contractRef, NestedEntityBoxWidget<Contract, SUBlockCharterAppendix> appendixWidget, String productUid, ObservableMutex mutex) {
        RootEntityPane rootPane = RootEntityPane.lookup((Node)view);
        if (rootPane != null) {
            String bookingUid = rootPane.getContainerUid();
            EntityReference bookingRef = new EntityReference(bookingUid, BookingFile.class, bookingUid);
            BookingFileProductAdditionalParametersHelper.setupAppendixSupplier((EntityReference<BookingFile>)bookingRef, productUid, contractRef, appendixWidget, mutex);
        } else {
            BookingFileProductAdditionalParametersHelper.setupAppendixSupplier(null, productUid, contractRef, appendixWidget, mutex);
        }
    }

    private static void setupAppendixSupplier(EntityReference<BookingFile> bookingRef, String productUid, EntityReference<Contract> contractRef, NestedEntityBoxWidget<Contract, SUBlockCharterAppendix> appendixWidget, ObservableMutex mutex) {
        Notifications.get().submitTask(() -> {
            try {
                List numbers;
                List<Object> list = contractRef == null ? Collections.emptyList() : (numbers = bookingRef == null ? BookingFileProductAdditionalParametersHelper.loadAllAppendixNumbers(contractRef) : BookingFileProductAdditionalParametersHelper.loadAllowedAppendixNumbers(bookingRef, productUid, contractRef));
                if (numbers != null) {
                    FxUtil.waitForFxThread(() -> appendixWidget.setListParametersSupplier(BookingFileProductAdditionalParametersHelper.appendixListParametersSupplier(numbers)));
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }, mutex);
    }

    private static List<String> loadAllowedAppendixNumbers(EntityReference<BookingFile> bookingRef, String productUid, EntityReference<Contract> contractRef) throws Exception {
        BookingFileService service = (BookingFileService)RpcServiceManager.get().getService(BookingFileService.class);
        ServiceInvocationContext ctx = ServiceInvocationContext.get();
        return service.loadAppendixNumbers(ctx, bookingRef, productUid, contractRef);
    }

    private static List<String> loadAllAppendixNumbers(EntityReference<Contract> contractRef) throws Exception {
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        ServiceInvocationContext ctx = ServiceInvocationContext.get();
        Contract contract = (Contract)entityService.loadBypassingAcl(ctx, contractRef).getEntity();
        List<String> numbers = contract.getCustomers().stream().flatMap(info -> info.getAppendices().stream()).filter(a -> a instanceof SUBlockCharterAppendix).map(a -> (SUBlockCharterAppendix)a).map(a -> a.getNumber()).collect(Collectors.toList());
        return numbers;
    }

    private static void setClassOfBookingSupplier(EntityReference<Contract> reference, ComboBoxWidget<SUBlockCharterTariffInfo> classOfBookingWidget, ObservableMutex mutex) {
        Notifications.get().submitTask(() -> {
            try {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer contractContainer = entityService.loadBypassingAcl(sic, reference);
                if (contractContainer != null) {
                    FxUtil.waitForFxThread(() -> {
                        List<SUBlockCharterTariffInfo> list = BookingFileProductAdditionalParametersHelper.getClassOfBookingList((Contract)contractContainer.getEntity());
                        classOfBookingWidget.setItemsSupplier(() -> list);
                    });
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }, mutex);
    }

    private static List<SUBlockCharterTariffInfo> getClassOfBookingList(Contract contract) {
        List<SUBlockCharterTariffInfo> tariffs = contract.getCustomers().stream().flatMap(c -> c.getAppendices().stream()).flatMap(a -> ((SUBlockCharterAppendix)a).getTariffs().stream()).collect(Collectors.toList());
        return tariffs;
    }

    private static List<LocalDate> getDates(SUBlockCharterTariffInfo tariff, boolean onlyBackward) {
        if (tariff == null) {
            return Collections.emptyList();
        }
        Set<LocalDate> flightDates = tariff.getQuotas().stream().filter(q -> q.isBackwardDirection() == onlyBackward).map(q -> DateUtils.asLocalDate((Date)q.getFlightDate())).collect(Collectors.toSet());
        return Arrays.asList(flightDates.toArray(new LocalDate[0]));
    }

    private static List<String> getFlightNo(SUBlockCharterTariffInfo tariff, LocalDate date, boolean onlyBackward) {
        if (tariff == null || date == null) {
            return Collections.emptyList();
        }
        List<String> flights = tariff.getQuotas().stream().filter(q -> q.isBackwardDirection() == onlyBackward).filter(q -> date.equals(DateUtils.asLocalDate((Date)q.getFlightDate()))).map(q -> q.getFlightNumber()).collect(Collectors.toList());
        return flights;
    }

    public static Supplier<IndexListParameters<Contract, ?>> tchContractListParametersSupplier() {
        return () -> {
            IndexListParameters params = new IndexListParameters();
            params.setIndexType(TchDirectContractIndex.class);
            TableColumnSettings contractName = new TableColumnSettings();
            contractName.setId(TchDirectContractIndex.Property.contractName.name());
            TableColumnSettings airline = new TableColumnSettings();
            airline.setId(TchDirectContractIndex.Property.airline.name());
            TableColumnSettings directContractNumber = new TableColumnSettings();
            directContractNumber.setId(TchDirectContractIndex.Property.directContractNumber.name());
            params.getColumns().add(contractName);
            params.getColumns().add(airline);
            params.getColumns().add(directContractNumber);
            params.getFilters().add(contractName);
            return params;
        };
    }

    public static StringConverter<NestedEntityReference<Contract, TchDirectContract>> tchContractConverter() {
        return new StringConverter<NestedEntityReference<Contract, TchDirectContract>>(){

            public String toString(NestedEntityReference<Contract, TchDirectContract> ref) {
                return ref == null ? null : ref.getCaption();
            }

            public NestedEntityReference<Contract, TchDirectContract> fromString(String string) {
                return null;
            }
        };
    }

    public static Supplier<IndexListParameters<Contract, ?>> contractListParametersSupplier() {
        return () -> {
            IndexListParameters params = new IndexListParameters();
            params.setIndexType(ContractCustomerIndex.class);
            TableColumnSettings contractType = new TableColumnSettings();
            contractType.setId(ContractCustomerIndex.Property.contractType.name());
            TableColumnSettings name = new TableColumnSettings();
            name.setId(ContractCustomerIndex.Property.name.name());
            TableColumnSettings number = new TableColumnSettings();
            number.setId(ContractCustomerIndex.Property.number.name());
            TableColumnSettings vendor = new TableColumnSettings();
            vendor.setId(ContractCustomerIndex.Property.vendor.name());
            TableColumnSettings supplier = new TableColumnSettings();
            supplier.setId(ContractCustomerIndex.Property.supplier.name());
            TableColumnSettings customer = new TableColumnSettings();
            customer.setId(ContractCustomerIndex.Property.customer.name());
            TableColumnSettings tourCode = new TableColumnSettings();
            tourCode.setId(ContractCustomerIndex.Property.tourCode.name());
            params.getColumns().add(contractType);
            params.getColumns().add(name);
            params.getColumns().add(number);
            params.getColumns().add(vendor);
            params.getColumns().add(supplier);
            params.getColumns().add(customer);
            params.getColumns().add(tourCode);
            params.getFilters().add(contractType);
            params.getFilters().add(vendor);
            params.getFilters().add(supplier);
            params.getFilters().add(customer);
            params.getFilters().add(tourCode);
            return params;
        };
    }

    private static Supplier<IndexListParameters<Contract, ?>> charterContractListParametersSupplier() {
        return () -> {
            IndexListParameters params = new IndexListParameters();
            params.setIndexType(ContractCustomerIndex.class);
            TableColumnSettings name = new TableColumnSettings();
            name.setId(ContractCustomerIndex.Property.name.name());
            TableColumnSettings number = new TableColumnSettings();
            number.setId(ContractCustomerIndex.Property.number.name());
            TableColumnSettings vendor = new TableColumnSettings();
            vendor.setId(ContractCustomerIndex.Property.vendor.name());
            TableColumnSettings supplier = new TableColumnSettings();
            supplier.setId(ContractCustomerIndex.Property.supplier.name());
            TableColumnSettings customer = new TableColumnSettings();
            customer.setId(ContractCustomerIndex.Property.customer.name());
            params.getColumns().add(name);
            params.getColumns().add(number);
            params.getColumns().add(vendor);
            params.getColumns().add(supplier);
            params.getColumns().add(customer);
            params.getFilters().add(vendor);
            params.getFilters().add(supplier);
            params.getFilters().add(customer);
            SearchCriterion charter = SearchCriterion.eq((String)ContractCustomerIndex.Property.vendorContractType.name(), (Object)VendorContractType.CHARTER);
            SearchCriterion blockCharter = SearchCriterion.eq((String)ContractCustomerIndex.Property.vendorContractType.name(), (Object)VendorContractType.BLOCK_CHARTER);
            params.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{charter, blockCharter}));
            return params;
        };
    }

    private static Function<EntityIndex<Contract>, NestedEntityReference<Contract, SUBlockCharterAppendix>> getAppendixEntityBuilder() {
        return idx -> new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), SUBlockCharterAppendix.class, (String)idx.getValue("appendixNumber"));
    }

    private static Supplier<IndexListParameters<Contract, ?>> appendixListParametersSupplier(List<String> appendixNumbers) {
        return () -> {
            Object[] objectArray;
            IndexListParameters params = new IndexListParameters();
            params.setIndexType(BlockCharterAppendixIndex.class);
            TableColumnSettings appendixNumber = new TableColumnSettings();
            appendixNumber.setId(BlockCharterAppendixIndex.Property.appendixNumber.name());
            TableColumnSettings appendixItinerary = new TableColumnSettings();
            appendixItinerary.setId(BlockCharterAppendixIndex.Property.appendixItinerary.name());
            TableColumnSettings appendixType = new TableColumnSettings();
            appendixType.setId(BlockCharterAppendixIndex.Property.appendixType.name());
            params.getColumns().add(appendixNumber);
            params.getColumns().add(appendixItinerary);
            params.getColumns().add(appendixType);
            params.getFilters().add(appendixItinerary);
            params.getFilters().add(appendixType);
            if (appendixNumbers.isEmpty()) {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = "";
            } else {
                objectArray = appendixNumbers.toArray(new String[0]);
            }
            Object[] numbers = objectArray;
            params.getSearchCriterions().add(SearchCriterion.in((String)BlockCharterAppendixIndex.Property.appendixNumber.name(), (Object[])numbers));
            return params;
        };
    }

    public static void setStringConverters(BooleanValueWidget fareDiffWidget, BooleanValueWidget subsidizedTariffWidget) {
        fareDiffWidget.setConverter(Converters.boolConverter((String)Messages.Return_Difference, (String)Messages.Not_Return_Difference));
        subsidizedTariffWidget.setConverter(Converters.boolConverter((String)Messages.Subsidized, (String)Messages.Normal));
    }

    public static void configurePassiveSegmentsWidget(PopupWidget<SabrePassiveSegmentsPane> widget, Supplier<String> uidSupplier) {
        widget.setDialogConfigurator(dialog -> {
            dialog.setExpandToParent(false);
            if (!ViewController.forView((Node)widget.getView()).isReadonly()) {
                dialog.setAutoClose(true);
                dialog.setOnCloseRequest(() -> ((Dialog)dialog).close());
                dialog.addButton(DialogButtonStyle.AUXILARY, Messages.Clean, () -> {
                    SabrePassiveSegmentsPane pane = (SabrePassiveSegmentsPane)widget.getView();
                    pane.getPccNode().setValue(null);
                    pane.getPnrNode().setValue(null);
                    pane.getTimestampNode().setValue(null);
                });
                dialog.addButton(DialogButtonStyle.AUXILARY, Messages.Send_agein, () -> BookingFileProductAdditionalParametersHelper.lambda$null$32(widget, (Supplier)uidSupplier));
            }
        });
    }

    private static void clearPassiveSegments(EntityReference<BookingFile> ref, String productUid) throws Exception {
        List messages = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).clearPassiveSegments(ServiceInvocationContext.get(), ref, productUid);
        Notifications.get().showMessages((Collection)messages);
        if (!ValidationUtil.hasErrors((Iterable)messages)) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(ref, EntityModification.ModificationType.CHANGE)));
        }
    }

    private static /* synthetic */ void lambda$null$32(PopupWidget widget, Supplier uidSupplier) {
        RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)widget);
        String productUid = (String)uidSupplier.get();
        if (rootEntityPane == null || productUid == null) {
            Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error getting productUid and rootEntityPane.", (Object[])new Object[0])});
        } else {
            EntityReference entityReference = rootEntityPane.getData().getContainer().toReference();
            RootEntityPane.executeAction((RootEntityPane)rootEntityPane, () -> Notifications.get().submitTask(() -> BookingFileProductAdditionalParametersHelper.clearPassiveSegments((EntityReference<BookingFile>)entityReference, productUid), rootEntityPane.getMutex()));
        }
    }
}

