/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers;

import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirValidatingCarrierPane;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpace;
import com.gridnine.xtrip.client.fx.model.system.ValidatorValuePair;
import com.gridnine.xtrip.client.fx.standard.custom.ValidatorEntityBoxWidget;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictQueryPseudoProperties;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDateTime;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.util.StringConverter;

public class BookingFileProductParametersHelper {
    public static void configureBlankOwnerNodes(final EntityBoxWidget<Organization> blankOwnerNode, SimpleCell ownerNumberCell) {
        blankOwnerNode.setListParametersSupplier(ControllerInterceptorsHelper::getAviaBlankOwners);
        ownerNumberCell.setValue(null);
        ControllerInterceptorsHelper.spyFor("Airline", blankOwnerNode, orgRef -> {
            try {
                EntityContainer orgCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).loadBypassingAcl(ServiceInvocationContext.get(), orgRef);
                if (orgCtr == null) {
                    return null;
                }
                DictionaryReference airlineRef = ((Organization)orgCtr.getEntity()).getAirline();
                if (airlineRef == null) {
                    return null;
                }
                return (Airline)((DictService)RpcServiceManager.get().getService(DictService.class)).loadBypassingAcl(ServiceInvocationContext.get(), airlineRef);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return null;
            }
        }, airline -> {
            if (airline == null) {
                ownerNumberCell.setValue(null);
                blankOwnerNode.setValue(null);
                return;
            }
            ownerNumberCell.setValue(airline.getAirlineNumber());
            blankOwnerNode.setConverter((StringConverter)new StringConverter<EntityReference<Organization>>(){

                public String toString(EntityReference<Organization> object) {
                    if (object == null) {
                        return null;
                    }
                    if (MiscUtil.equals(object, (Object)blankOwnerNode.getValue())) {
                        return airline.getCode();
                    }
                    return object.toString();
                }

                public EntityReference<Organization> fromString(String string) {
                    return null;
                }
            });
            blankOwnerNode.redraw();
        });
    }

    public static void configureHotelBlankOwnerNode(EntityBoxWidget<Organization> blankOwnerNode, SimpleCell ownerNumberCell) {
        blankOwnerNode.setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        ownerNumberCell.setValue(null);
        ControllerInterceptorsHelper.spyFor("Hotel", blankOwnerNode, orgRef -> {
            try {
                return ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getBlankOwnerCode(ServiceInvocationContext.get(), orgRef);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return null;
            }
        }, blankOwnerCode -> ownerNumberCell.setValue(blankOwnerCode));
    }

    public static void configureCarrierNodes(BookingFileProductAirValidatingCarrierPane pane, Supplier<LocalDateTime> productDateSupplier) {
        final DictBoxWidget carrierNode = pane.getCarrierNode();
        SimpleCell carrierNumberCell = pane.getCarrierNumberCell();
        carrierNode.setListParametersSupplier(() -> {
            DictListParameters result = DictHandler.forDictClass(Airline.class).getStandardListParameters().copy();
            result.getSearchCriterions().add(new DictQuery.SearchCriterion(DictQueryPseudoProperties.AIRLINE_DATE, new Object[]{DateUtils.asDate((LocalDateTime)((LocalDateTime)productDateSupplier.get()))}));
            return result;
        });
        carrierNumberCell.setValue(null);
        ControllerInterceptorsHelper.spyFor("AirlineNumber", carrierNode, carrierRef -> {
            try {
                return (Airline)((DictService)RpcServiceManager.get().getService(DictService.class)).loadBypassingAcl(ServiceInvocationContext.get(), carrierRef);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return null;
            }
        }, airline -> {
            String airlineNumber;
            String airlineCaption;
            if (airline != null) {
                airlineCaption = DictHelper.getCodeVariant((BaseDictionary)airline, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA, CodeSystem.CRT});
                if (TextUtil.isBlank((String)airlineCaption)) {
                    airlineCaption = airline.getCode();
                }
                airlineNumber = airline.getAirlineNumber();
            } else {
                airlineCaption = null;
                airlineNumber = null;
            }
            final String finalAirlineCaption = airlineCaption;
            carrierNode.setConverter((StringConverter)new StringConverter<DictionaryReference<Airline>>(){

                public String toString(DictionaryReference<Airline> ref) {
                    if (ref == null) {
                        return null;
                    }
                    if (ref.equals((Object)carrierNode.getValue())) {
                        return finalAirlineCaption;
                    }
                    return ref.getCode();
                }

                public DictionaryReference<Airline> fromString(String string) {
                    return null;
                }
            });
            carrierNumberCell.setValue(airlineNumber);
            carrierNode.redraw();
        });
    }

    public static void configureBlanktypeNode(DictBoxWidget<BlankType> widget, ProductCategory productCategory) {
        widget.setListParametersSupplier(() -> {
            DictListParameters params = new DictListParameters();
            params.getColumns().add(DictHandlersHelper.COL_CODE);
            params.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.name.name(), Messages.Number, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.couponsCount.name(), Messages.Number_of_coupons, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.blankOwner.name(), Messages.Form_owner, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.productCategory.name(), Messages.View, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.blankCategory.name(), Messages.Type, (Renderer)StandardRenderers.GENERIC));
            params.getSearchCriterions().add(new DictQuery.SearchCriterion(BlankType.Property.productCategory.name(), new Object[]{productCategory}));
            return params;
        });
    }

    public static Supplier<IndexListParameters<SalesPoint, ?>> configureValidatorParametersSupplier() {
        return () -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(ValidatorIndex.class);
            TableColumnSettings colSettings = new TableColumnSettings();
            colSettings.setId(ValidatorIndex.Property.number.name());
            result.getColumns().add(colSettings);
            colSettings = new TableColumnSettings();
            colSettings.setId(ValidatorIndex.Property.agency.name());
            result.getColumns().add(colSettings);
            result.getFilters().add(colSettings);
            colSettings = new TableColumnSettings();
            colSettings.setId(ValidatorIndex.Property.blankOwner.name());
            result.getColumns().add(colSettings);
            result.getFilters().add(colSettings);
            colSettings = new TableColumnSettings();
            colSettings.setId(ValidatorIndex.Property.salesPoint.name());
            result.getColumns().add(colSettings);
            result.getFilters().add(colSettings);
            colSettings = new TableColumnSettings();
            colSettings.setId(ValidatorIndex.Property.pcc.name());
            result.getColumns().add(colSettings);
            colSettings = new TableColumnSettings();
            colSettings.setId(ValidatorIndex.Property.opened.name());
            result.getColumns().add(colSettings);
            colSettings = new TableColumnSettings();
            colSettings.setId(ValidatorIndex.Property.closed.name());
            result.getColumns().add(colSettings);
            return result;
        };
    }

    public static Function<EntityIndex<SalesPoint>, NestedEntityReference<SalesPoint, Validator>> configureValidatorReferenceBuilder() {
        return idx -> new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), Validator.class, ((ValidatorIndex)idx).getNumber());
    }

    public static Consumer<RootEntityPane<?, ?>> configureValidatorCallback() {
        return pane -> {
            if (!(pane.getEditor() instanceof SalesPointSpace)) {
                return;
            }
            SalesPointSpace space = (SalesPointSpace)pane.getEditor();
            space.expand(space.getValidatorsTile());
        };
    }

    public static void configureValidatorNode(ValidatorEntityBoxWidget validatorValueNode, Supplier<ValidatorValuePair> pairSupplier) {
        validatorValueNode.setListParametersSupplier(BookingFileProductParametersHelper.configureValidatorParametersSupplier());
        validatorValueNode.setNestedReferenceBuilder(BookingFileProductParametersHelper.configureValidatorReferenceBuilder());
        validatorValueNode.setNavigationCallback(BookingFileProductParametersHelper.configureValidatorCallback());
        validatorValueNode.valueProperty().addListener((f, old, val) -> {
            ValidatorValuePair validatorValuePair = (ValidatorValuePair)pairSupplier.get();
            if (validatorValuePair == null) {
                return;
            }
            if (val == null) {
                validatorValuePair.setReference(null);
                validatorValuePair.setCode(null);
            } else if (validatorValuePair.getReference() == null || !validatorValuePair.getReference().getNestedEntityUid().equals(val.getNestedEntityUid())) {
                validatorValuePair.setReference(val);
                validatorValuePair.setCode(val.getCaption());
                validatorValueNode.setValidatorCode(validatorValuePair.getCode());
            }
        });
    }

    public static void configureSupplierPoints(EntityBoxWidget<Organization> node, EntityBoxWidget<SalesPoint> salesPointWidget) {
        if (BookingFileProductParametersHelper.isCustomSupplier()) {
            node.valueProperty().addListener((obj, oldVal, newVal) -> salesPointWidget.setListParametersSupplier(() -> ControllerInterceptorsHelper.getSalesPoints((EntityReference<Organization>)newVal)));
        }
    }

    private static boolean isCustomSupplier() {
        return !"true".equals(System.getProperty("midoffice.disableSalesPointCustomSupplier"));
    }
}

