/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.hotel;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ValuesWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelAdditionalParameters;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCostFeesAndCharges;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCostFines;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCostTaxVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomDetailsPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomDetailsPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomServiceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelStatusesPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelVatDetail;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.SabrePassiveSegmentsPane;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductAdditionalParametersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductParametersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.hotel.HotelRoomServiceConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.hotel.HotelSearchConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class BookingFileProductHotelPanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductHotelPanelVM, BookingFileProductHotelPanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";

    protected Class<BookingFileProductHotelPanelController> getControllerClass() {
        return BookingFileProductHotelPanelController.class;
    }

    protected void onCreate(BookingFileProductHotelPanelController controller) {
        BookingFileProductHotelPanel view = controller.getView();
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getTicketInfoNode().getStatusValueNode(), () -> ((BookingFileProductHotelPanelController)controller).getData());
        this.configureStatusesPane(view.getStatusesNode());
        BindingUtil.addYearValidationListener(controller.getView().getGeneralNode().getTicketInfoNode().getOperationDateValueNode());
        BookingFileProductHotelPanelControllerInterceptor.setupVatsTable(controller);
        BookingFileProductHotelSalesChainPane salesChainNode = controller.getView().getGeneralNode().getSalesChainNode();
        salesChainNode.getPrescribeAgentValueNode().setListParametersSupplier(() -> {
            EntityReference spRef = salesChainNode.getSalesPointValueNode().getValue();
            return ControllerInterceptorsHelper.getAgentsForSalesPoint((EntityReference<SalesPoint>)spRef);
        });
        salesChainNode.getAgencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        salesChainNode.getSubagencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        BookingFileProductParametersHelper.configureSupplierPoints((EntityBoxWidget<Organization>)salesChainNode.getSubagencyValueNode(), (EntityBoxWidget<SalesPoint>)salesChainNode.getSalesPointValueNode());
        BookingFileProductParametersHelper.configureHotelBlankOwnerNode((EntityBoxWidget<Organization>)salesChainNode.getBlankOwnerValueNode().getBlankOwnerCodeNode(), salesChainNode.getBlankOwnerValueNode().getBlankOwnerHotelNumberCell());
        ArrayList confs = new ArrayList(ClientRegistry.get().allOf(HotelSearchConfigurator.TYPE).values());
        Collections.reverse(confs);
        Iterator iterator = confs.iterator();
        if (iterator.hasNext()) {
            HotelSearchConfigurator configurator = (HotelSearchConfigurator)iterator.next();
            configurator.install(controller.getView().getGeneralNode().getHotelParametersNode(), (ComboBoxWidget<HotelProvider>)controller.getView().getGeneralNode().getTravelerInfoNode().getProviderValueNode());
        }
        controller.getView().getCancellableNode().setConverter(Converters.boolConverter((String)Messages.Possible, (String)Messages.Not_Possible));
        TableWidget roomsTable = (TableWidget)controller.getRooms().getView();
        roomsTable.addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            DateTimeValueWidget arrival = (DateTimeValueWidget)roomsTable.getColumn("arrival").getWidget(ind.intValue());
            DateTimeValueWidget departure = (DateTimeValueWidget)roomsTable.getColumn("departure").getWidget(ind.intValue());
            IntValueWidget nights = (IntValueWidget)roomsTable.getColumn("nights").getWidget(ind.intValue());
            arrival.valueProperty().addListener((obj, old, value) -> BookingFileProductHotelPanelControllerInterceptor.updateNights(arrival, departure, nights, ((BookingFileProductHotelRoomVM)roomsTable.getData(ind.intValue())).getSuperColumn()));
            departure.valueProperty().addListener((obj, old, value) -> BookingFileProductHotelPanelControllerInterceptor.updateNights(arrival, departure, nights, ((BookingFileProductHotelRoomVM)roomsTable.getData(ind.intValue())).getSuperColumn()));
            BookingFileProductHotelPanelControllerInterceptor.updateNights(arrival, departure, nights, ((BookingFileProductHotelRoomVM)roomsTable.getData(ind.intValue())).getSuperColumn());
        });
        roomsTable.setControlButtonsCoordinator((type, row) -> {
            if (type == ControlsPane.ButtonType.ADD) {
                return row == null;
            }
            return true;
        });
        salesChainNode.getValidatorCodeValueNode().setActionHandler((IconShape)StandardIconShapes.COMBOBOX_LIST_ARROW, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose_value_from_list, node -> {
            NestedEntityBoxWidget widget = new NestedEntityBoxWidget(SalesPoint.class, Validator.class, false);
            widget.setListParametersSupplier(BookingFileProductParametersHelper.configureValidatorParametersSupplier());
            widget.setNestedReferenceBuilder(BookingFileProductParametersHelper.configureValidatorReferenceBuilder());
            widget.setNavigationCallback(BookingFileProductParametersHelper.configureValidatorCallback());
            widget.setLookupDialogOwner((Node)salesChainNode);
            widget.valueProperty().addListener((f, old, val) -> salesChainNode.getValidatorCodeValueNode().setValue(val.getCaption()));
            widget.showLookupDialog();
        });
        this.configureVat(controller.getView());
        BookingFileProductAdditionalParametersHelper.configurePassiveSegmentsWidget((PopupWidget<SabrePassiveSegmentsPane>)((BookingFileProductHotelAdditionalParameters)controller.getView().getOtherParametersNode().getAdditionalCard().getContent()).getPassiveSegmentsNode(), () -> controller.getData().getUid());
        if (!Prefetched.getData().isFindocsEnabled()) {
            view.getGeneralNode().getTravelerInfoNode().getShipmentsDateCaptionCell().setHidden(true);
            view.getGeneralNode().getTravelerInfoNode().getShipmentsDateValueCell().setHidden(true);
        }
        BookingFileContractPanel tableView = (BookingFileContractPanel)view.getFopsNode().getContractNode().getView();
        ((TableWidget)tableView.getContractsCard().getContent()).addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget contractType = (ComboBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("contractType").getWidget(ind.intValue());
            ContractType type = (ContractType)contractType.getValue();
            EntityBoxWidget manualContract = (EntityBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("manualContract").getWidget(ind.intValue());
            manualContract.setListParametersSupplier(() -> {
                IndexListParameters<Contract, ContractIndex> contractsByType = ControllerInterceptorsHelper.getContractsByType((ContractType)contractType.getValue());
                BookingFileSpace pane = (BookingFileSpace)RootEntityPane.lookup((Node)controller.getView()).getEditor();
                EntityReference client = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)pane.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
                EntityReference blankOwner = view.getGeneralNode().getSalesChainNode().getBlankOwnerValueNode().getBlankOwnerCodeNode().getValue();
                EntityReference supplier = view.getGeneralNode().getSalesChainNode().getSupplierValueNode().getValue();
                EntityReference agency = view.getGeneralNode().getSalesChainNode().getAgencyValueNode().getValue();
                EntityReference subagency = view.getGeneralNode().getSalesChainNode().getSubagencyValueNode().getValue();
                if (type.equals((Object)ContractType.CLIENT)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)client));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.SUBAGENCY)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)agency));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.VENDOR)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)blankOwner)}));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)agency));
                }
                contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
                return contractsByType;
            });
        });
        for (HotelRoomServiceConfigurator configurator : ClientRegistry.get().allOf(HotelRoomServiceConfigurator.TYPE).values()) {
            configurator.configureTable((TableWidget<BookingFileProductHotelRoomServiceVM>)controller.getView().getRoomServicesNode());
        }
        view.getGeneralNode().getTravelerInfoNode().getTicketTypeValueNode().valueProperty().addListener((s, o, n) -> {
            view.getGeneralNode().getTicketInfoNode().getCorrectionDateCaptionCell().setHidden(n != TicketType.CORRECTION);
            view.getGeneralNode().getTicketInfoNode().getCorrectionDateValueCell().setHidden(n != TicketType.CORRECTION);
        });
    }

    private void configureStatusesPane(BookingFileProductHotelStatusesPane view) {
        view.getCheckedNode().setConverter(Converters.boolConverter((String)Messages.Checked, (String)Messages.Unchecked));
        view.getFinishedNode().setConverter(Converters.boolConverter((String)Messages.Finished, (String)Messages.Not_finished));
        view.getHasErrorsNode().setConverter(Converters.boolConverter((String)Messages.Has_errors, (String)Messages.Has_not_errors));
        view.getHasWarningsNode().setConverter(Converters.boolConverter((String)Messages.Has_warnings, (String)Messages.Has_not_warnings));
        view.getRulesAppliedNode().setConverter(Converters.boolConverter((String)Messages.Rules_applied, (String)Messages.Rules_not_applied));
        view.getOnHoldNode().setConverter(Converters.boolConverter((String)Messages.bookingFileProductHotelPanelControllerInterceptor_fundsOnHold, (String)Messages.bookingFileProductHotelPanelControllerInterceptor_fundsNotOnHold));
        view.getVatSpecifiedNode().setConverter(Converters.boolConverter((String)Messages.bookingFileProductHotelPanelControllerInterceptor_vatDetailed, (String)Messages.bookingFileProductHotelPanelControllerInterceptor_vatNotDetailed));
        view.getForcedRefundNode().setConverter(Converters.boolConverter((String)Messages.bookingFileProductHotelPanelControllerInterceptor_involuntary, (String)Messages.bookingFileProductHotelPanelControllerInterceptor_voluntary));
    }

    private static void updateNights(DateTimeValueWidget arrival, DateTimeValueWidget departure, IntValueWidget nights, BookingFileProductHotelRoomDetailsPaneVM superColumn) {
        int nightsNum = HotelProductHelper.calculateNights((Date)DateUtils.asDate((LocalDateTime)arrival.getValue()), (Date)DateUtils.asDate((LocalDateTime)departure.getValue()));
        nights.setValue((Number)nightsNum);
        superColumn.setNights(nightsNum);
    }

    private static void setupVatsTable(BookingFileProductHotelPanelController controller) {
        TableWidget vatTable = (TableWidget)((BookingFileProductHotelVatDetail)((PopupWidget)controller.getView().getCostNode().getVatsCell().getPayload()).getView()).getContent();
        ValuesWidgetColumn typesColumn = (ValuesWidgetColumn)vatTable.getColumn("basisTypes");
        typesColumn.setItemsSupplier(Suppliers.createEnumSupplier(VatBasisType.class));
        ValuesWidgetColumn codesColumn = (ValuesWidgetColumn)vatTable.getColumn("codes");
        codesColumn.setItemsSupplier(() -> controller.getData().getCost().getFees().getContent().stream().map(BookingFileProductHotelCostTaxVM::getCode).collect(Collectors.toList()));
        PriceValueWidgetColumn rateColumn = (PriceValueWidgetColumn)vatTable.getColumn("rate");
        PriceValueWidgetColumn sumColumn = (PriceValueWidgetColumn)vatTable.getColumn("sum");
        vatTable.addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            PriceValueWidget rateWidget = (PriceValueWidget)rateColumn.getWidget(ind.intValue());
            rateWidget.setPromptText(Messages.noVat);
            PriceValueWidget sumWidget = (PriceValueWidget)sumColumn.getWidget(ind.intValue());
            sumWidget.setPromptText(Messages.noVat);
        });
    }

    private void configureVat(BookingFileProductHotelPanel view) {
        TableWidget tableRoomAdditional = view.getRoomServicesNode();
        this.configureVatInTable(tableRoomAdditional, this::configureVatInRoomAdditionalTableColumn);
        TableWidget tableRoomDetails = view.getRoomsNode();
        this.configureVatInTable(tableRoomDetails, this::configureVatInRoomDetailsTableColumn);
        TableWidget tableFees = (TableWidget)((BookingFileProductHotelCostFeesAndCharges)view.getCostNode().getFeesNode().getView()).getContent();
        this.configureVatInTable(tableFees, this::configureVatInCostFeesTableColumn);
        TableWidget tableTaxes = (TableWidget)((BookingFileProductHotelCostFines)view.getCostNode().getFinesNode().getView()).getContent();
        this.configureVatInTable(tableTaxes, this::configureVatInCostTaxesTableColumn);
    }

    private <T> void configureVatInTable(TableWidget<T> tableWidget, BiConsumer<TableWidget<T>, Integer> configureTable) {
        tableWidget.addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            configureTable.accept(tableWidget, ind);
        });
    }

    private <T> void configureVatInCostTaxesTableColumn(TableWidget<T> tableWidget, Integer ind) {
        ComboBoxWidget vatRateWidget = (ComboBoxWidget)tableWidget.getColumn("vatRate").getWidget(ind.intValue());
        PriceValueWidget vatAmountWidget = (PriceValueWidget)tableWidget.getColumn("vat").getWidget(ind.intValue());
        PriceValueWidget sourcePriceWidget = (PriceValueWidget)tableWidget.getColumn("eqSum").getWidget(ind.intValue());
        vatRateWidget.setItemsSupplier(ControllerInterceptorVatHelper.getVatHotelsSupplier());
        ControllerInterceptorVatHelper.configureVatWidgets((ComboBoxWidget<Double>)vatRateWidget, vatAmountWidget, sourcePriceWidget);
    }

    private <T> void configureVatInCostFeesTableColumn(TableWidget<T> tableWidget, Integer ind) {
        ComboBoxWidget vatRateWidget = (ComboBoxWidget)tableWidget.getColumn("vatRate").getWidget(ind.intValue());
        PriceValueWidget vatAmountWidget = (PriceValueWidget)tableWidget.getColumn("vat").getWidget(ind.intValue());
        PriceValueWidget sourcePriceWidget = (PriceValueWidget)tableWidget.getColumn("eqSum").getWidget(ind.intValue());
        vatRateWidget.setItemsSupplier(ControllerInterceptorVatHelper.getVatHotelsSupplier());
        ControllerInterceptorVatHelper.configureVatWidgets((ComboBoxWidget<Double>)vatRateWidget, vatAmountWidget, sourcePriceWidget);
    }

    private void configureVatInRoomAdditionalTableColumn(TableWidget<BookingFileProductHotelRoomServiceVM> tableWidget, Integer ind) {
        ComboBoxWidget vatRateWidget = (ComboBoxWidget)tableWidget.getColumn("vatRate").getWidget(ind.intValue());
        PriceValueWidget vatAmountWidget = (PriceValueWidget)tableWidget.getColumn("vat").getWidget(ind.intValue());
        PriceValueWidget sourcePriceWidget = (PriceValueWidget)tableWidget.getColumn("amount").getWidget(ind.intValue());
        vatRateWidget.setItemsSupplier(ControllerInterceptorVatHelper.getVatHotelsSupplier());
        ControllerInterceptorVatHelper.configureVatWidgets((ComboBoxWidget<Double>)vatRateWidget, vatAmountWidget, sourcePriceWidget);
    }

    private void configureVatInRoomDetailsTableColumn(TableWidget<BookingFileProductHotelRoomVM> tableWidget, Integer ind) {
        PopupWidget superColumn = (PopupWidget)tableWidget.getColumn("superColumn").getWidget(ind.intValue());
        PriceValueWidget vatAmountWidget = ((BookingFileProductHotelRoomDetailsPane)superColumn.getView()).getVatNode();
        ComboBoxWidget vatRateWidget = ((BookingFileProductHotelRoomDetailsPane)superColumn.getView()).getVatRateNode();
        PriceValueWidget sourcePriceWidget = ((BookingFileProductHotelRoomDetailsPane)superColumn.getView()).getSumEqNode();
        vatRateWidget.setItemsSupplier(ControllerInterceptorVatHelper.getVatHotelsSupplier());
        ControllerInterceptorVatHelper.configureVatWidgets((ComboBoxWidget<Double>)vatRateWidget, vatAmountWidget, sourcePriceWidget);
    }

    protected void beforeWriteData(BookingFileProductHotelPanelController controller, BookingFileProductHotelPanelVM model) {
        model.setProductType(HotelProduct.class);
    }

    protected void afterReadData(BookingFileProductHotelPanelController controller, BookingFileProductHotelPanelVM model) {
        Optional<BaseProductUIData> productUIData = Optional.ofNullable(model.getProductUiData());
        controller.getView().getGeneralNode().getSalesChainNode().getAgencyValueNode().getViewState().setNotEditable(productUIData.map(BaseProductUIData::isHasSubagentRelatedShipment).orElse(false).booleanValue());
        controller.getView().getGeneralNode().getSalesChainNode().getSubagencyValueNode().getViewState().setNotEditable(productUIData.map(data -> data.isHasClientRelatedShipment() || data.isHasSubagentRelatedShipment()).orElse(false).booleanValue());
        controller.getView().getAdditionalInfoCell().setHidden(TextUtil.isBlank((String)controller.getView().getAdditionalInfoNode().getInfoValueNode().getValue()));
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductHotelPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
        String productSubagencyUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId());
        boolean productSubagencyViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSubagencyEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSubagencyCaptionCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueNode().getViewState().setAclNotEditable(!productSubagencyEditGranted);
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

