/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.hotel;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiSettings;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelParameters;
import com.gridnine.xtrip.client.fx.model.booking.SabreHotelSearchPane;
import com.gridnine.xtrip.client.fx.model.booking.SabreHotelSearchResultItemVM;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.HotelsBrandReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.util.Pair;

public class HotelSearchConfigurator
implements RegistryItem<HotelSearchConfigurator> {
    public static RegistryItemType<HotelSearchConfigurator> TYPE = new RegistryItemType("HOTEL-SEARCH-CONFIGURATOR");

    public RegistryItemType<HotelSearchConfigurator> getType() {
        return TYPE;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void install(BookingFileProductHotelParameters parametersPane, ComboBoxWidget<HotelProvider> provider) {
        parametersPane.getHotelValueNode().setActionHandler((IconShape)StandardIconShapes.SEARCH_12x12, Messages.Hotel_search, node -> {
            SabreHotelSearchPane pane = new SabreHotelSearchPane(false);
            this.configure(pane, (HotelProvider)provider.getValue());
            if (parametersPane.getCountryValueNode().getValue() != null) {
                pane.getCountryNode().setValue(parametersPane.getCountryValueNode().getValue());
            }
            if (parametersPane.getCityValueNode().getValue() != null) {
                pane.getLocationNode().setValue(parametersPane.getCityValueNode().getValue());
            }
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Hotel_search).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                SabreHotelSearchResultItemVM vm = (SabreHotelSearchResultItemVM)pane.getSearchResultNode().getTableView().getSelectionModel().getSelectedItem();
                if (vm == null) {
                    return;
                }
                Hotel hotel = vm.getHotel();
                parametersPane.getCodeValueNode().setValue(hotel.getSabreHotelPropertyNumber() == null ? null : hotel.getSabreHotelPropertyNumber().toString());
                parametersPane.getCountryValueNode().setValue(hotel.getCountry());
                parametersPane.getCityValueNode().setValue(hotel.getCity());
                parametersPane.getChainValueNode().setValue(hotel.getBrand() == null ? null : hotel.getBrand().toString());
                parametersPane.getStarsValueNode().setValue((Number)hotel.getStars());
                parametersPane.getHotelValueNode().setValue(hotel.getName());
                parametersPane.getAddressValueNode().setValue(hotel.getAddress() == null ? null : hotel.getAddress().toString());
                parametersPane.getPhoneValueNode().setValue(hotel.getPhone());
                parametersPane.getFaxValueNode().setValue(hotel.getFax());
            }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)pane.getSearchResultNode().getTableView().getSelectionModel().selectedItemProperty())).show((Node)node);
        });
    }

    public void configure(final SabreHotelSearchPane pane, HotelProvider provider) {
        UiSettings settings = new UiSettings("hotel-search-dialog", new UiSettings.Persister[]{new UiSettings.Persister(){

            public void read(Properties props) throws Exception {
                pane.getHotelIdNode().setValue(props.getProperty("hotelId"));
                String code = props.getProperty("country.code");
                String caption = props.getProperty("country.caption");
                pane.getCountryNode().setValue((DictionaryReference)(code == null ? null : new CountryReference(code, caption)));
                code = props.getProperty("location.code");
                caption = props.getProperty("location.caption");
                pane.getLocationNode().setValue((DictionaryReference)(code == null ? null : new GeoLocationReference(code, caption)));
                code = props.getProperty("chain.code");
                caption = props.getProperty("chain.caption");
                pane.getChainNode().setValue((DictionaryReference)(code == null ? null : new HotelsBrandReference(code, caption)));
                pane.getNameNode().setValue(props.getProperty("name"));
            }

            public void write(Properties props) throws Exception {
                DictionaryReference chain;
                DictionaryReference loc;
                this.setProperty(props, "hotelId", pane.getHotelIdNode().getValue());
                DictionaryReference country = pane.getCountryNode().getValue();
                if (country != null) {
                    this.setProperty(props, "country.code", country.getCode());
                    this.setProperty(props, "country.caption", country.getCaption());
                }
                if ((loc = pane.getLocationNode().getValue()) != null) {
                    this.setProperty(props, "location.code", loc.getCode());
                    this.setProperty(props, "location.caption", loc.getCaption());
                }
                if ((chain = pane.getChainNode().getValue()) != null) {
                    this.setProperty(props, "chain.code", chain.getCode());
                    this.setProperty(props, "chain.caption", chain.getCaption());
                }
                this.setProperty(props, "name", pane.getNameNode().getValue());
            }

            private void setProperty(Properties props, String name, String value) {
                if (!TextUtil.isBlank((String)value)) {
                    props.setProperty(name, value);
                }
            }
        }});
        pane.getSearchResultNode().setHandler(this.createDataViewHandler(pane, provider));
        pane.getActionNode().setOnAction(evt -> {
            settings.save();
            pane.getSearchResultNode().reloadData();
        });
        pane.getLocationNode().setLive(true);
        ValueHolder isHAAvailable = new ValueHolder((Object)Boolean.FALSE);
        Thread t = new Thread(() -> {
            try {
                BookingFileService service = (BookingFileService)RpcServiceManager.get().getService(BookingFileService.class);
                isHAAvailable.setValue((Object)service.isHotelAggregatorAvailable(ServiceInvocationContext.get()));
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        });
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (((Boolean)isHAAvailable.getValue()).booleanValue()) {
            pane.getCountryNode().setItemsSupplier(() -> {
                try {
                    return RpcDictHelper.loadAll(Country.class).stream().filter(d -> d.getCodeVariants().containsKey(CodeSystem.HOTEL_AGGREGATOR.name())).map(Country::toReference).collect(Collectors.toList());
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                    return null;
                }
            }, true);
            pane.getLocationNode().setItemsSupplier(() -> {
                try {
                    DictionaryReference country = pane.getCountryNode().getValue();
                    return RpcDictHelper.loadAll(GeoLocation.class).stream().filter(d -> d.getCodeVariants().containsKey(CodeSystem.HOTEL_AGGREGATOR.name())).filter(gl -> country == null || MiscUtil.equals((Object)gl.getCountry(), (Object)country, (boolean)false)).map(GeoLocation::toReference).collect(Collectors.toList());
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                    return null;
                }
            }, true);
        } else {
            pane.getLocationNode().setListParametersSupplier(() -> {
                DictionaryReference country = pane.getCountryNode().getValue();
                DictListParameters result = DictHandler.forDictClass(GeoLocation.class).getStandardListParameters().copy();
                if (country != null) {
                    result.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.country.name(), new Object[]{country}));
                }
                return result;
            });
        }
        settings.load();
        pane.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                FxUtil.submitToFxThread(() -> ((DataViewWidget)pane.getSearchResultNode()).reloadData());
            }
        });
    }

    protected DataViewHandler<SabreHotelSearchResultItemVM> createDataViewHandler(final SabreHotelSearchPane pane, HotelProvider provider) {
        return new DataViewHandler<SabreHotelSearchResultItemVM>(){

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                String hotelId = pane.getHotelIdNode().getValue();
                DictionaryReference country = pane.getCountryNode().getValue();
                DictionaryReference location = pane.getLocationNode().getValue();
                DictionaryReference chain = pane.getChainNode().getValue();
                String name = pane.getNameNode().getValue();
                if (TextUtil.isBlank((String)hotelId) && country == null && location == null && (TextUtil.isBlank((String)name) || name.trim().length() < 2)) {
                    this.getData().clear();
                    return;
                }
                Notifications.get().submitTask(() -> {
                    List hotels = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).searchSabreHotels(ServiceInvocationContext.get(), hotelId, country, location, chain, name);
                    List vms = hotels.stream().map(hotel -> {
                        SabreHotelSearchResultItemVM vm = new SabreHotelSearchResultItemVM();
                        vm.setHotel(hotel);
                        if (hotel.getSabreHotelPropertyNumber() != null) {
                            vm.setHotelId(hotel.getSabreHotelPropertyNumber().toString());
                        }
                        if (hotel.getCountry() != null) {
                            vm.setCountry(hotel.getCountry().toString());
                        }
                        if (hotel.getCity() != null) {
                            vm.setLocation(hotel.getCity().toString());
                        }
                        if (hotel.getBrand() != null) {
                            vm.setChain(hotel.getBrand().toString());
                        }
                        vm.setName(hotel.getName());
                        if (hotel.getAddress() != null) {
                            vm.setAddress(hotel.getAddress().toString());
                        }
                        return vm;
                    }).collect(Collectors.toList());
                    FxUtil.submitToFxThread(() -> this.getData().setAll((Collection)vms));
                }, this.getMutex());
            }

            protected int getOffset() {
                return 0;
            }

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }
        };
    }
}

