/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.mcofees;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.MoneyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesMainTicketInfo;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesOperation;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesTotalSum;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductParametersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.McoFeesFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class BookingFileProductMCOFeesPanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductMCOFeesPanelVM, BookingFileProductMCOFeesPanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";

    protected Class<BookingFileProductMCOFeesPanelController> getControllerClass() {
        return BookingFileProductMCOFeesPanelController.class;
    }

    protected void onCreate(BookingFileProductMCOFeesPanelController controller) {
        super.onCreate((ViewController)controller);
        BookingFileProductMCOFeesPanel view = controller.getView();
        view.getStatusesNode().getCheckedNode().setConverter(Converters.boolConverter((String)Messages.Checked, (String)Messages.Unchecked));
        view.getStatusesNode().getFinishedNode().setConverter(Converters.boolConverter((String)Messages.Finished, (String)Messages.Not_finished));
        view.getStatusesNode().getHasErrorsNode().setConverter(Converters.boolConverter((String)Messages.Has_errors, (String)Messages.Has_not_errors));
        view.getStatusesNode().getHasWarningsNode().setConverter(Converters.boolConverter((String)Messages.Has_warnings, (String)Messages.Has_not_warnings));
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getTicketInformationNode().getStatusValueNode(), () -> ((BookingFileProductMCOFeesPanelController)controller).getData());
        TableWidget totalSumWidget = view.getGeneralNode().getSourceNode();
        MoneyValueWidgetColumn fareColumn = (MoneyValueWidgetColumn)totalSumWidget.getColumn("fare");
        ComboBoxWidgetColumn mcoFeesSourceCol = (ComboBoxWidgetColumn)totalSumWidget.getColumn("mcoFeesSource");
        totalSumWidget.setOnRowsAction(event -> {
            if (event.getEventType() == TableRowEvent.ROW_ADD) {
                ComboBoxWidget sourceColumnWidget = (ComboBoxWidget)mcoFeesSourceCol.getWidget(event.getRowIndex().intValue());
                MoneyValueWidget fareColumnWidget = (MoneyValueWidget)fareColumn.getWidget(event.getRowIndex().intValue());
                sourceColumnWidget.valueProperty().addListener((observable, oldValue, newValue) -> fareColumnWidget.valueProperty().setValue((Object)(newValue != null ? newValue.getFare() : null)));
            }
        });
        mcoFeesSourceCol.setConverter(McoFeesFXHelper.getMcoFeesSourceConverter());
        mcoFeesSourceCol.setAsync(true);
        mcoFeesSourceCol.setLive(true);
        mcoFeesSourceCol.setItemsSupplier(() -> {
            EntityReference bookingReference = Objects.requireNonNull(RootEntityPane.lookup((Node)view)).getData().getContainer().toReference();
            try {
                List existingSources = totalSumWidget.getRowsData().stream().map(BookingFileProductMCOFeesTotalSum::getMcoFeesSource).filter(Objects::nonNull).collect(Collectors.toList());
                List sources = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).findMCOFeesSources(ServiceInvocationContext.get(), bookingReference);
                sources.removeIf(source -> existingSources.stream().anyMatch(existingSource -> MCOFeesHelper.equals((MCOFeesSource)existingSource, (MCOFeesSource)source)));
                return sources;
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return Collections.emptyList();
            }
        });
        BookingFileProductMCOFeesMainTicketInfo ticketInfoNode = view.getGeneralNode().getTicketInformationNode();
        ticketInfoNode.getBlankValueNode().setConverter(StandardRenderers.DICT_CODE.createStatefulConverter(() -> ((ViewState)view.getGeneralNode().getTicketInformationNode().getBlankValueNode().getViewState()).isImmutable()));
        ticketInfoNode.getPrescribeAgentValueNode().setListParametersSupplier(() -> {
            EntityReference spRef = ticketInfoNode.getSalesPointValueNode().getValue();
            return ControllerInterceptorsHelper.getAgentsForSalesPoint((EntityReference<SalesPoint>)spRef);
        });
        BookingFileProductMCOFeesOperation operationNode = view.getGeneralNode().getOperationNode();
        operationNode.getPaymentTypeValueNode().setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
        BookingFileProductMCOFeesMainTicketInfo infoNode = view.getGeneralNode().getTicketInformationNode();
        BookingFileProductParametersHelper.configureSupplierPoints((EntityBoxWidget<Organization>)infoNode.getAgencyValueNode(), (EntityBoxWidget<SalesPoint>)infoNode.getSalesPointValueNode());
        view.getGeneralNode().getTicketInformationNode().getTicketTypeValueNode().valueProperty().addListener((s, o, n) -> {
            view.getGeneralNode().getOperationNode().getCorrectionDateCaptionCell().setHidden(n != TicketType.CORRECTION);
            view.getGeneralNode().getOperationNode().getCorrectionDateValueCell().setHidden(n != TicketType.CORRECTION);
        });
    }

    protected void afterReadData(BookingFileProductMCOFeesPanelController controller, BookingFileProductMCOFeesPanelVM model) {
        controller.getView().getProperties().put((Object)"status", (Object)model.getStatus());
    }

    protected void beforeWriteData(BookingFileProductMCOFeesPanelController controller, BookingFileProductMCOFeesPanelVM model) {
        super.beforeWriteData((ViewController)controller, (Object)model);
        model.setProductType(MCOFees.class);
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductMCOFeesPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTicketInformation().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getTicketInformation().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getTicketInformation().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTicketInformation().getView().getPrescribeAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getTicketInformation().getView().getPrescribeAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getTicketInformation().getView().getPrescribeAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
    }
}

