/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.taxi;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiCostSumPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductParametersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Optional;
import java.util.Set;
import javafx.scene.Node;

public class BookingFileProductTaxiPanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductTaxiPanelVM, BookingFileProductTaxiPanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";

    protected Class<BookingFileProductTaxiPanelController> getControllerClass() {
        return BookingFileProductTaxiPanelController.class;
    }

    protected void beforeWriteData(BookingFileProductTaxiPanelController controller, BookingFileProductTaxiPanelVM model) {
        model.setProductType(TaxiProduct.class);
    }

    protected void onCreate(BookingFileProductTaxiPanelController controller) {
        super.onCreate((ViewController)controller);
        BookingFileProductTaxiPanel view = controller.getView();
        BookingFileProductTaxiCostSumPane node = view.getCostNode().getSumNode();
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getTicketInfoNode().getStatusValueNode(), () -> ((BookingFileProductTaxiPanelController)controller).getData());
        BindingUtil.addYearValidationListener(view.getGeneralNode().getTicketInfoNode().getOperationDateValueNode());
        BookingFileProductTaxiSalesChainPane salesChainNode = view.getGeneralNode().getSalesChainNode();
        salesChainNode.getBlankOwnerValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        salesChainNode.getAgencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        salesChainNode.getSubagencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        salesChainNode.getPrescribeAgentValueNode().setListParametersSupplier(() -> {
            EntityReference spRef = salesChainNode.getSalesPointValueNode().getValue();
            return ControllerInterceptorsHelper.getAgentsForSalesPoint((EntityReference<SalesPoint>)spRef);
        });
        salesChainNode.getSupplierValueNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersMulti());
        BookingFileProductParametersHelper.configureSupplierPoints((EntityBoxWidget<Organization>)salesChainNode.getSubagencyValueNode(), (EntityBoxWidget<SalesPoint>)salesChainNode.getSalesPointValueNode());
        CustomVatContainer vatContainer = node.getVatIncludedEqTariffNode();
        vatContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        ControllerInterceptorVatHelper.configureVatContainer(vatContainer, node.getEqTariffSumNode());
        CustomVatContainer vatPenaltyContainer = node.getVatIncludedPenaltyNode();
        vatPenaltyContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        ControllerInterceptorVatHelper.configureVatContainer(vatPenaltyContainer, node.getPenaltySumNode());
        BookingFileContractPanel tableView = (BookingFileContractPanel)view.getFopsNode().getContractNode().getView();
        if (!Prefetched.getData().isFindocsEnabled()) {
            view.getGeneralNode().getTravelerInfoNode().getShipmentsDateCaptionCell().setHidden(true);
            view.getGeneralNode().getTravelerInfoNode().getShipmentsDateValueCell().setHidden(true);
        }
        ((TableWidget)tableView.getContractsCard().getContent()).addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget contractType = (ComboBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("contractType").getWidget(ind.intValue());
            ContractType type = (ContractType)contractType.getValue();
            EntityBoxWidget manualContract = (EntityBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("manualContract").getWidget(ind.intValue());
            manualContract.setListParametersSupplier(() -> {
                IndexListParameters<Contract, ContractIndex> contractsByType = ControllerInterceptorsHelper.getContractsByType((ContractType)contractType.getValue());
                BookingFileSpace pane = (BookingFileSpace)RootEntityPane.lookup((Node)view).getEditor();
                EntityReference client = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)pane.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
                EntityReference blankOwner = view.getGeneralNode().getSalesChainNode().getBlankOwnerValueNode().getValue();
                EntityReference supplier = view.getGeneralNode().getSalesChainNode().getSupplierValueNode().getValue();
                EntityReference agency = view.getGeneralNode().getSalesChainNode().getAgencyValueNode().getValue();
                EntityReference subagency = view.getGeneralNode().getSalesChainNode().getSubagencyValueNode().getValue();
                if (type.equals((Object)ContractType.CLIENT)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)client));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.SUBAGENCY)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)agency));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.VENDOR)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)blankOwner)}));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)agency));
                }
                contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
                return contractsByType;
            });
        });
        view.getGeneralNode().getSalesChainNode().getTicketTypeValueNode().valueProperty().addListener((s, o, n) -> {
            view.getGeneralNode().getTicketInfoNode().getCorrectionDateCaptionCell().setHidden(n != TicketType.CORRECTION);
            view.getGeneralNode().getTicketInfoNode().getCorrectionDateValueCell().setHidden(n != TicketType.CORRECTION);
        });
    }

    protected void afterReadData(BookingFileProductTaxiPanelController controller, BookingFileProductTaxiPanelVM model) {
        String productStatus = model.getGeneral().getTicketInfo().getStatusValue();
        CustomVatContainer vatNode = controller.getView().getCostNode().getSumNode().getVatIncludedPenaltyNode();
        if (productStatus.equals(ProductStatus.SELL.toString())) {
            vatNode.getVatRateNode().getViewState().setNotEditable(true);
            vatNode.getVatAmountNode().getViewState().setNotEditable(true);
        } else {
            vatNode.getVatRateNode().getViewState().setNotEditable(false);
            vatNode.getVatAmountNode().getViewState().setNotEditable(false);
        }
        model.getBookingFile().getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> TextUtil.isSame((String)product.getUid(), (String)controller.getData().getUid())).findFirst().ifPresent(baseProduct -> {
            TaxiProduct product = (TaxiProduct)baseProduct;
            boolean isHiddenFineCell = (product.getPreviousProduct() == null || !product.getPreviousProduct().getStatus().equals((Object)ProductStatus.EXCHANGE) || !product.getStatus().equals((Object)ProductStatus.SELL)) && !product.getStatus().equals((Object)ProductStatus.REFUND);
            BookingFileProductTaxiCostSumPane costSum = controller.getView().getCostNode().getSumNode();
            costSum.getPenaltySumCell().setHidden(isHiddenFineCell);
            costSum.getPenaltyCaptionCell().setHidden(isHiddenFineCell);
            costSum.getPenaltyCurrencyCell().setHidden(isHiddenFineCell);
            costSum.getVatIncludedPenaltyCell().setHidden(isHiddenFineCell);
        });
        Optional<BaseProductUIData> productUIData = Optional.ofNullable(model.getProductUiData());
        controller.getView().getGeneralNode().getSalesChainNode().getAgencyValueNode().getViewState().setNotEditable(productUIData.map(BaseProductUIData::isHasSubagentRelatedShipment).orElse(false).booleanValue());
        controller.getView().getGeneralNode().getSalesChainNode().getSubagencyValueNode().getViewState().setNotEditable(productUIData.map(data -> data.isHasClientRelatedShipment() || data.isHasSubagentRelatedShipment()).orElse(false).booleanValue());
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductTaxiPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
        String productSubagencyUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId());
        boolean productSubagencyViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSubagencyEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSubagencyCaptionCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueNode().getViewState().setAclNotEditable(!productSubagencyEditGranted);
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

