/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.visa;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaParametersCostSum;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaParametersOwner;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Optional;
import java.util.Set;
import javafx.scene.Node;

public class BookingFileProductVisaPanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductVisaPanelVM, BookingFileProductVisaPanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";

    protected Class<BookingFileProductVisaPanelController> getControllerClass() {
        return BookingFileProductVisaPanelController.class;
    }

    protected void beforeWriteData(BookingFileProductVisaPanelController controller, BookingFileProductVisaPanelVM model) {
        model.setProductType(VisaProduct.class);
    }

    protected void onCreate(BookingFileProductVisaPanelController controller) {
        super.onCreate((ViewController)controller);
        BookingFileProductVisaPanel view = controller.getView();
        BookingFileProductVisaParametersCostSum costSumView = view.getCostNode().getSumCellNode();
        view.getStatusesNode().getCheckedNode().setConverter(Converters.boolConverter((String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Checked, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Unchecked));
        view.getStatusesNode().getFinishedNode().setConverter(Converters.boolConverter((String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Finished, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Not_finished));
        view.getStatusesNode().getHasErrorsNode().setConverter(Converters.boolConverter((String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Has_errors, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Has_not_errors));
        view.getStatusesNode().getHasWarningsNode().setConverter(Converters.boolConverter((String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Has_warnings, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Has_not_warnings));
        view.getStatusesNode().getRulesAppliedNode().setConverter(Converters.boolConverter((String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Rules_applied, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Rules_not_applied));
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getBaseInformationParametersNode().getStatusValueNode(), () -> ((BookingFileProductVisaPanelController)controller).getData());
        BindingUtil.addYearValidationListener(view.getGeneralNode().getBaseInformationParametersNode().getOperationDateValueNode());
        BookingFileProductVisaParametersOwner ownerNode = view.getGeneralNode().getOwnerParametersNode();
        ownerNode.getAgencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getSubagencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getAgentValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgents);
        ownerNode.getSupplierValueNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersMulti());
        if (!Prefetched.getData().isFindocsEnabled()) {
            ownerNode.getShipmentsDateCaptionCell().setHidden(true);
            ownerNode.getShipmentsDateValueCell().setHidden(true);
        }
        CustomVatContainer vatContainer = costSumView.getVatIncludedEqTariffNode();
        ControllerInterceptorVatHelper.configureVatContainer(vatContainer, costSumView.getEqTariffSumNode());
        vatContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        CustomVatContainer vatPenaltyContainer = costSumView.getVatIncludedPenaltyNode();
        ControllerInterceptorVatHelper.configureVatContainer(vatPenaltyContainer, costSumView.getPenaltySumNode());
        vatPenaltyContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        view.getGeneralNode().getBaseInformationParametersNode().getTicketTypeValueNode().valueProperty().addListener((s, o, n) -> {
            view.getGeneralNode().getBaseInformationParametersNode().getCorrectionDateCaptionCell().setHidden(n != TicketType.CORRECTION);
            view.getGeneralNode().getBaseInformationParametersNode().getCorrectionDateValueCell().setHidden(n != TicketType.CORRECTION);
        });
    }

    protected void afterReadData(BookingFileProductVisaPanelController controller, BookingFileProductVisaPanelVM model) {
        controller.getView().getProperties().put((Object)"status", (Object)model.getStatus());
        String productStatus = model.getGeneral().getBaseInformationParameters().getStatusValue();
        CustomVatContainer vatNode = controller.getView().getCostNode().getSumCellNode().getVatIncludedPenaltyNode();
        if (productStatus.equals(ProductStatus.SELL.toString())) {
            vatNode.getVatRateNode().getViewState().setNotEditable(true);
            vatNode.getVatAmountNode().getViewState().setNotEditable(true);
        } else {
            vatNode.getVatRateNode().getViewState().setNotEditable(false);
            vatNode.getVatAmountNode().getViewState().setNotEditable(false);
        }
        model.getBookingFile().getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> TextUtil.isSame((String)product.getUid(), (String)controller.getData().getUid())).findFirst().ifPresent(baseProduct -> {
            VisaProduct product = (VisaProduct)baseProduct;
            boolean isHiddenFineCell = (product.getPreviousProduct() == null || !product.getPreviousProduct().getStatus().equals((Object)ProductStatus.EXCHANGE) || !product.getStatus().equals((Object)ProductStatus.SELL)) && !product.getStatus().equals((Object)ProductStatus.REFUND);
            BookingFileProductVisaParametersCostSum costSum = controller.getView().getCostNode().getSumCellNode();
            costSum.getPenaltySumCell().setHidden(isHiddenFineCell);
            costSum.getPenaltyCaptionCell().setHidden(isHiddenFineCell);
            costSum.getPenaltyCurrencyCell().setHidden(isHiddenFineCell);
            costSum.getVatIncludedPenaltyCell().setHidden(isHiddenFineCell);
        });
        Optional<BaseProductUIData> productUIData = Optional.ofNullable(model.getProductUiData());
        controller.getView().getGeneralNode().getOwnerParametersNode().getAgencyValueNode().getViewState().setNotEditable(productUIData.map(BaseProductUIData::isHasSubagentRelatedShipment).orElse(false).booleanValue());
        controller.getView().getGeneralNode().getOwnerParametersNode().getSubagencyValueNode().getViewState().setNotEditable(productUIData.map(productData -> productData.isHasClientRelatedShipment() || productData.isHasSubagentRelatedShipment()).orElse(false).booleanValue());
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductVisaPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
        String productSubagencyUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId());
        boolean productSubagencyViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSubagencyEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getSubagencyCaptionCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSubagencyValueCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSubagencyValueNode().getViewState().setAclNotEditable(!productSubagencyEditGranted);
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

