/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product;

import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.PrototypeHolder;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javafx.scene.Node;

public interface ProductFXHandler<P extends BaseProduct, I extends EntityIndex<BookingFile>, D extends BaseProductUIData, C>
extends RegistryItem<ProductFXHandler<?, ?, ?, ?>> {
    public static final RegistryItemType<ProductFXHandler<?, ?, ?, ?>> TYPE = new RegistryItemType("PRODUCT-FX-HANDLER");

    public static ProductFXHandler<?, ?, ?, ?> forId(String id) {
        return (ProductFXHandler)ClientRegistry.get().allOf(TYPE).get(id);
    }

    public static <P extends BaseProduct> ProductFXHandler<P, ?, ?, ?> forProduct(P product) {
        return product == null ? null : ProductFXHandler.forProductClass(product.getClass());
    }

    public static <P extends BaseProduct> ProductFXHandler<P, ?, ?, ?> forProductClass(Class<P> productClass) {
        if (PrototypeHolder.HANDLER != null && PrototypeHolder.HANDLER.getProductClass().isAssignableFrom(productClass)) {
            return PrototypeHolder.HANDLER;
        }
        String className = productClass.getName();
        for (ProductFXHandler handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getProductClass().getName().equals(className)) continue;
            return handler;
        }
        return null;
    }

    public static ProductFXHandler<?, ?, ?, ?> forNode(Node node) {
        if (PrototypeHolder.HANDLER != null && PrototypeHolder.HANDLER.isAwareOf(node)) {
            return PrototypeHolder.HANDLER;
        }
        return ClientRegistry.get().allOf(TYPE).values().stream().filter(handler -> handler.isAwareOf(node)).findFirst().orElse(null);
    }

    public static ProductFXHandler<?, ?, ?, ?> forProductIndex(EntityIndex<BookingFile> productIndex) {
        if (PrototypeHolder.HANDLER != null && PrototypeHolder.HANDLER.getProductIndexClass().equals(productIndex.getClass())) {
            return PrototypeHolder.HANDLER;
        }
        return ClientRegistry.get().allOf(TYPE).values().stream().filter(value -> value.getProductIndexClass().equals(productIndex.getClass())).findFirst().orElse(null);
    }

    public static ProductFXHandler<?, ?, ?, ?> forProductIndexClass(Class<?> productIndex) {
        if (PrototypeHolder.HANDLER != null && PrototypeHolder.HANDLER.getProductIndexClass().equals(productIndex)) {
            return PrototypeHolder.HANDLER;
        }
        return ClientRegistry.get().allOf(TYPE).values().stream().filter(value -> value.getProductIndexClass().equals(productIndex)).findFirst().orElse(null);
    }

    public static void validateProductNode(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        ProductFXHandler<?, ?, ?, ?> productHandler = ProductFXHandler.forNode(node);
        productHandler.validate(uid, node, errors);
        productHandler.validateStatisticalData(space, uid, node, errors);
    }

    default public RegistryItemType<ProductFXHandler<?, ?, ?, ?>> getType() {
        return TYPE;
    }

    default public String getId() {
        return this.getProductClass().getName();
    }

    public Class<P> getProductClass();

    public Class<I> getProductIndexClass();

    public D createUiData();

    public P createProduct();

    default public void updateNewBookingFile(BookingFile bookingFile, BookingFileUIData bookingFileSupplementData, BookingFileCreateParametersPaneVM parameters) {
    }

    default public boolean isShowCreateDialog() {
        return false;
    }

    public BaseProductVM createVM(P var1);

    default public String getDisplayName() {
        return this.getId();
    }

    public void toVM(P var1, D var2, BaseProductVM var3, EntityReference<Organization> var4);

    public void fromVM(BaseProductVM var1, P var2, D var3);

    public String getRecordLocator(BaseProductVM var1);

    default public boolean canCreateNewProduct() {
        return true;
    }

    public boolean isAwareOf(Node var1);

    default public Consumer<Consumer<C>> createConfigurator(Map<String, Object> parameters) {
        return null;
    }

    public Node createNodeForNewProduct(BookingFileSpaceVM var1, C var2, Map<String, Object> var3);

    public Node createNodeForExistingProduct(BookingFileSpaceVM var1, Map<String, Object> var2);

    public P getPreviousProduct(P var1);

    public P getNextProduct(P var1);

    default public boolean isFOPRecalculatable() {
        return true;
    }

    default public boolean isDeletable(P product) {
        return true;
    }

    public ProductStatus getProductStatus(P var1);

    default public boolean isEMDOrExcessBagage(P baseProduct) {
        return false;
    }

    public void remove(P var1);

    default public List<BaseProduct> getRelatedProducts(P baseProduct) {
        return Collections.emptyList();
    }

    default public boolean removeRelatedProduct(P product, BaseProduct removedProduct) {
        return false;
    }

    public StatisticalData getStatisticalData(P var1);

    public void newStatisticalData(P var1);

    public Collection<Traveller> getTravellers(P var1);

    default public boolean isMultiTraveller() {
        return false;
    }

    public void setAgent(P var1, EntityReference<Person> var2);

    public ProductType getProductType(P var1);

    public Set<ContractType> getHiddenContractTypes(Node var1);

    default public boolean isNeedReloadPrefetched(P product) {
        return false;
    }

    public void validate(String var1, Node var2, List<Message> var3) throws Exception;

    public void validateStatisticalData(BookingFileSpace var1, String var2, Node var3, List<Message> var4) throws Exception;
}

