/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceGeneralPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServicePanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServicePanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServicePanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceParametersBaseInfo;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceParametersOwner;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AdditionalServiceProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AirProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProductIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.AdditionalServiceProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class AdditionalServiceProductFXHandler
implements ProductFXHandler<AdditionalServiceProduct, AdditionalServiceProductIndex, AdditionalServiceProductUIData, Void> {
    @Override
    public AdditionalServiceProduct getPreviousProduct(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public AdditionalServiceProduct getNextProduct(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public Class<AdditionalServiceProduct> getProductClass() {
        return AdditionalServiceProduct.class;
    }

    @Override
    public Class<AdditionalServiceProductIndex> getProductIndexClass() {
        return AdditionalServiceProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.ADDITIONAL_SERVICE.toString();
    }

    @Override
    public StatisticalData getStatisticalData(AdditionalServiceProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(AdditionalServiceProduct product) {
    }

    @Override
    public Collection<Traveller> getTravellers(AdditionalServiceProduct product) {
        return product.getTravellers();
    }

    @Override
    public void setAgent(AdditionalServiceProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public ProductStatus getProductStatus(AdditionalServiceProduct product) {
        return product.getStatus();
    }

    @Override
    public void remove(AdditionalServiceProduct product) {
        product.getReservation().getProducts().remove(product);
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductAdditionalServicePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        AdditionalServiceCategory category = (AdditionalServiceCategory)parameters.get("category");
        BookingFileProductAdditionalServicePanelVM productVM = new BookingFileProductAdditionalServicePanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.ADDITIONAL_SERVICE.toString());
        MiscUtil.Pair<AdditionalServiceProduct, AdditionalServiceProductUIData> prototypeData = AdditionalServiceProductFXHelper.getPrototypeData();
        AdditionalServiceProduct product = (AdditionalServiceProduct)prototypeData.getFirst();
        AdditionalServiceProductUIData productSupplementData = (AdditionalServiceProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductAdditionalServicePanel node = new BookingFileProductAdditionalServicePanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            BookingFileProductAdditionalServicePanelController controller = new BookingFileProductAdditionalServicePanelController(node, false);
            controller.readData(productVM);
            BookingFileProductAdditionalServicePanel bookingFileProductAdditionalServicePanel = node;
            return bookingFileProductAdditionalServicePanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        return new BookingFileProductAdditionalServicePanel(false);
    }

    @Override
    public AdditionalServiceProduct createProduct() {
        return new AdditionalServiceProduct();
    }

    @Override
    public AdditionalServiceProductUIData createUiData() {
        return new AdditionalServiceProductUIData();
    }

    @Override
    public BaseProductVM createVM(AdditionalServiceProduct product) {
        return new BookingFileProductAdditionalServicePanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductAdditionalServicePanelVM)vm).getReservationUid();
    }

    @Override
    public void toVM(AdditionalServiceProduct product, AdditionalServiceProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodeTypes = Arrays.asList(ReasonCodeType.REASON_CODE_AIR, ReasonCodeType.REASON_CODE_NO_HOTEL, ReasonCodeType.REASON_CODE_DECLINED);
        BookingFileProductAdditionalServicePanelVM parentVM = (BookingFileProductAdditionalServicePanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        AdditionalServiceProductFXHelper.toVMParentParameters(product, parentVM);
        AdditionalServiceProductFXHelper.toVMParameters(parentVM.getGeneral(), product, productData, parentVM.getStatuses(), parentVM.getRelatedProducts());
        AirProductFXHelper.toVMAirSegments(product.getSegments(), null, productData.getSegmentsUIDataList(), parentVM.getSegments().getContent());
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, parentVM.getCommissions());
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodeTypes, AdditionalServiceProduct.class, parentVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
    }

    @Override
    public void fromVM(BaseProductVM vm, AdditionalServiceProduct product, AdditionalServiceProductUIData productData) {
        BookingFileProductAdditionalServicePanelVM productVM = (BookingFileProductAdditionalServicePanelVM)vm;
        AdditionalServiceProductFXHelper.fillBasicProductFields(product);
        AdditionalServiceProductFXHelper.fromVMParameters(productVM.getGeneral(), product, productData, productVM.getStatuses(), productVM.getRelatedProducts());
        AirProductFXHelper.fromVMAirSegments(productVM.getSegments().getContent(), product.getSegments(), null);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
    }

    @Override
    public ProductType getProductType(AdditionalServiceProduct product) {
        return ProductType.ADDITIONAL_SERVICE;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductAdditionalServiceParametersOwner paramsPane = ((BookingFileProductAdditionalServicePanel)node).getGeneralNode().getOwnerParametersNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        if (node instanceof BookingFileProductAdditionalServicePanel) {
            boolean emptyPaymentType;
            BookingFileProductAdditionalServicePanel panel = (BookingFileProductAdditionalServicePanel)node;
            String systemNumber = panel.getGeneralNode().getBaseInformationParametersNode().getNumberValueNode().getValue();
            AdditionalServiceCategory category = (AdditionalServiceCategory)((ComboBoxWidget)((BookingFileProductAdditionalServiceParametersBaseInfo)((BookingFileProductAdditionalServiceGeneralPanel)panel.getGeneralCell().getPayload()).getBaseInformationParametersCell().getPayload()).getCategoryValueCell().getPayload()).getValue();
            if (category == null) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AdditionalServiceCategoryIsEmpty, (Object[])new Object[]{systemNumber}));
            }
            if (emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null)) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
    }
}

