/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AeroexpressTicketFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.uidata.AeroexpressTicketUIData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class AeroexpressTicketFXHandler
implements ProductFXHandler<AeroexpressTicket, AeroexpressTicketIndex, AeroexpressTicketUIData, Void> {
    @Override
    public AeroexpressTicket getPreviousProduct(AeroexpressTicket product) {
        return product.getPreviousProduct();
    }

    @Override
    public AeroexpressTicket getNextProduct(AeroexpressTicket product) {
        return product.getNextProduct();
    }

    @Override
    public Class<AeroexpressTicket> getProductClass() {
        return AeroexpressTicket.class;
    }

    @Override
    public Class<AeroexpressTicketIndex> getProductIndexClass() {
        return AeroexpressTicketIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.AEROEXPRESS.toString();
    }

    @Override
    public StatisticalData getStatisticalData(AeroexpressTicket product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(AeroexpressTicket product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(AeroexpressTicket product) {
        return product.getTraveller() == null ? new ArrayList() : Collections.singletonList(product.getTraveller());
    }

    @Override
    public void setAgent(AeroexpressTicket product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public ProductStatus getProductStatus(AeroexpressTicket product) {
        return product.getStatus();
    }

    @Override
    public void remove(AeroexpressTicket baseProduct) {
        HashSet<AeroexpressTicket> productsToDelete = new HashSet<AeroexpressTicket>();
        productsToDelete.add(baseProduct);
        if (baseProduct.getStatus() == ProductStatus.SELL && baseProduct.getPreviousProduct() != null && baseProduct.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            productsToDelete.add(baseProduct.getPreviousProduct());
        }
        if (baseProduct.getStatus() == ProductStatus.EXCHANGE && baseProduct.getNextProduct() != null && baseProduct.getNextProduct().getStatus() == ProductStatus.SELL) {
            productsToDelete.add(baseProduct.getNextProduct());
        }
        for (AeroexpressTicket prod : productsToDelete) {
            this.removeProduct(prod);
        }
    }

    private void removeProduct(AeroexpressTicket product) {
        product.getReservation().getBookingFile().getReservations().forEach(res -> {
            res.getProducts().remove(product);
            res.getProducts().stream().filter(el -> el instanceof AeroexpressTicket).map(el -> (AeroexpressTicket)el).forEach(el -> {
                if (product.equals((Object)el.getPreviousProduct())) {
                    el.setPreviousProduct(null);
                }
                if (product.equals((Object)el.getNextProduct())) {
                    el.setNextProduct(null);
                }
            });
        });
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductAeroexpressPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductAeroexpressPanelVM productVM = new BookingFileProductAeroexpressPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.AEROEXPRESS.toString());
        MiscUtil.Pair<AeroexpressTicket, AeroexpressTicketUIData> prototypeData = AeroexpressTicketFXHelper.getPrototypeData();
        AeroexpressTicket product = (AeroexpressTicket)prototypeData.getFirst();
        AeroexpressTicketUIData productSupplementData = (AeroexpressTicketUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductAeroexpressPanel node = new BookingFileProductAeroexpressPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            AeroexpressTicketFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductAeroexpressPanelController controller = new BookingFileProductAeroexpressPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductAeroexpressPanel bookingFileProductAeroexpressPanel = node;
            return bookingFileProductAeroexpressPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductAeroexpressPanel node = new BookingFileProductAeroexpressPanel(false);
        AeroexpressTicketFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public AeroexpressTicket createProduct() {
        return new AeroexpressTicket();
    }

    @Override
    public AeroexpressTicketUIData createUiData() {
        return new AeroexpressTicketUIData();
    }

    @Override
    public BaseProductVM createVM(AeroexpressTicket product) {
        return new BookingFileProductAeroexpressPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductAeroexpressPanelVM)vm).getGeneral().getTicketInfo().getBookingValue();
    }

    @Override
    public void toVM(AeroexpressTicket product, AeroexpressTicketUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_AEROEXPRESS, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductAeroexpressPanelVM productVM = (BookingFileProductAeroexpressPanelVM)vm;
        AeroexpressTicketFXHelper.toVM(product, productData, productVM);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productVM.getCommissions());
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, AeroexpressTicket.class, productVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productVM.getOtherParameters().getValidation());
    }

    @Override
    public void fromVM(BaseProductVM vm, AeroexpressTicket product, AeroexpressTicketUIData productData) {
        BookingFile bookingFile = product.getReservation() != null && product.getReservation().getBookingFile() != null ? product.getReservation().getBookingFile() : vm.getBookingFile();
        AeroexpressTicketFXHelper.fillBasicProductFields(product);
        BookingFileProductAeroexpressPanelVM productVM = (BookingFileProductAeroexpressPanelVM)vm;
        AeroexpressTicketFXHelper.fromVM(productVM, bookingFile, product, productData, product.getStatus().equals((Object)ProductStatus.EXCHANGE) || product.getStatus().equals((Object)ProductStatus.REFUND));
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
    }

    @Override
    public ProductType getProductType(AeroexpressTicket product) {
        return ProductType.AEROEXPRESS;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductAeroexpressSalesChainPane salesChainPane = ((BookingFileProductAeroexpressPanel)node).getGeneralNode().getSalesChainNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)salesChainPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)salesChainPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileProductAeroexpressPanel panel = (BookingFileProductAeroexpressPanel)node;
        String systemNumber = panel.getGeneralNode().getTicketInfoNode().getTicketNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductAeroexpressPanel) {
            BookingFileProductAeroexpressPanel panel = (BookingFileProductAeroexpressPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }
}

