/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgentTouchPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgentTouchPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgentTouchPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAgentTouchOwnerParameters;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AgentTouchFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.booking.uidata.AgentTouchProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class AgentTouchFXHandler
implements ProductFXHandler<AgentTouch, CommonProductIndex, AgentTouchProductUIData, Void> {
    @Override
    public Class<AgentTouch> getProductClass() {
        return AgentTouch.class;
    }

    @Override
    public Class<CommonProductIndex> getProductIndexClass() {
        return CommonProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.AGENT_TOUCH.toString();
    }

    @Override
    public ProductStatus getProductStatus(AgentTouch product) {
        return ProductStatus.SELL;
    }

    @Override
    public void remove(AgentTouch product) {
        product.getReservation().getProducts().remove(product);
    }

    @Override
    public AgentTouch createProduct() {
        return new AgentTouch();
    }

    @Override
    public AgentTouchProductUIData createUiData() {
        return new AgentTouchProductUIData();
    }

    @Override
    public BaseProductVM createVM(AgentTouch product) {
        return new BookingFileAgentTouchPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileAgentTouchPanelVM)vm).getReservationUid();
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileAgentTouchPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileAgentTouchPanelVM productVM = new BookingFileAgentTouchPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.AGENT_TOUCH.toString());
        MiscUtil.Pair<AgentTouch, AgentTouchProductUIData> prototypeData = AgentTouchFXHelper.getPrototypeData();
        AgentTouch product = (AgentTouch)prototypeData.getFirst();
        AgentTouchProductUIData productSupplementData = (AgentTouchProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileAgentTouchPanel node = new BookingFileAgentTouchPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            AgentTouchFXHelper.updateNode(node, bookingFileVM);
            BookingFileAgentTouchPanelController controller = new BookingFileAgentTouchPanelController(node, false);
            controller.readData(productVM);
            BookingFileAgentTouchPanel bookingFileAgentTouchPanel = node;
            return bookingFileAgentTouchPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileAgentTouchPanel node = new BookingFileAgentTouchPanel(false);
        AgentTouchFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public AgentTouch getPreviousProduct(AgentTouch product) {
        return null;
    }

    @Override
    public AgentTouch getNextProduct(AgentTouch product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(AgentTouch product) {
        return null;
    }

    @Override
    public void newStatisticalData(AgentTouch product) {
    }

    @Override
    public Collection<Traveller> getTravellers(AgentTouch product) {
        return Collections.emptyList();
    }

    @Override
    public void setAgent(AgentTouch product, EntityReference<Person> agent) {
    }

    @Override
    public void toVM(AgentTouch product, AgentTouchProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        BookingFileAgentTouchPanelVM parentVM = (BookingFileAgentTouchPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        AgentTouchFXHelper.toVMParameters(product, parentVM.getGeneral(), parentVM.getStatuses(), productData);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, parentVM.getCommissions());
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
    }

    @Override
    public void fromVM(BaseProductVM vm, AgentTouch product, AgentTouchProductUIData productData) {
        BookingFileAgentTouchPanelVM parentVM = (BookingFileAgentTouchPanelVM)vm;
        AgentTouchFXHelper.fromVMParameters(product, parentVM.getGeneral(), parentVM.getStatuses(), productData);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, parentVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(parentVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, parentVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(parentVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
    }

    @Override
    public ProductType getProductType(AgentTouch product) {
        return ProductType.AGENT_TOUCH;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductAgentTouchOwnerParameters paramsPane = ((BookingFileAgentTouchPanel)node).getGeneralNode().getOwnerParametersNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileAgentTouchPanel panel = (BookingFileAgentTouchPanel)node;
        String systemNumber = ProductType.PRODUCT_VOIDING + (panel.getGeneralNode().getTicketInfoNode().getAgentSignatureValueNode().getValue() == null ? "" : " " + panel.getGeneralNode().getTicketInfoNode().getAgentSignatureValueNode().getValue());
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
    }
}

