/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.InsuranceAccidentFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class InsuranceAccidentFXHandler
implements ProductFXHandler<InsuranceAccident, InsuranceAccidentIndex, InsuranceUIData, Void> {
    @Override
    public Class<InsuranceAccident> getProductClass() {
        return InsuranceAccident.class;
    }

    @Override
    public Class<InsuranceAccidentIndex> getProductIndexClass() {
        return InsuranceAccidentIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.INSURANCE_ACCIDENT.toString();
    }

    @Override
    public InsuranceAccident getPreviousProduct(InsuranceAccident product) {
        return product.getPreviousProduct();
    }

    @Override
    public void remove(InsuranceAccident baseProduct) {
        InsuranceAccidentHelper.removeProduct((InsuranceAccident)baseProduct, (boolean)true);
    }

    @Override
    public InsuranceAccident getNextProduct(InsuranceAccident product) {
        return product.getNextProduct();
    }

    @Override
    public ProductStatus getProductStatus(InsuranceAccident product) {
        return product.getStatus();
    }

    @Override
    public InsuranceAccident createProduct() {
        return new InsuranceAccident();
    }

    @Override
    public StatisticalData getStatisticalData(InsuranceAccident product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(InsuranceAccident product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(InsuranceAccident product) {
        Traveller traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), product.getTravellerUid());
        return traveller == null ? new ArrayList() : Collections.singletonList(traveller);
    }

    @Override
    public void setAgent(InsuranceAccident product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public InsuranceUIData createUiData() {
        return new InsuranceUIData();
    }

    @Override
    public BaseProductVM createVM(InsuranceAccident product) {
        return new BookingFileProductInsuranceAccidentPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductInsuranceAccidentPanelVM)vm).getGeneral().getTicketInfo().getReservationValue();
    }

    @Override
    public void toVM(InsuranceAccident product, InsuranceUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_INSURANCE_TOURISTIC, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductInsuranceAccidentPanelVM productVM = (BookingFileProductInsuranceAccidentPanelVM)vm;
        product.setStatus(product.getStatus());
        InsuranceAccidentFXHelper.toVM(productVM, product, productData);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productVM.getCommissions());
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, InsuranceAccident.class, productVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productVM.getOtherParameters().getValidation());
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductInsuranceAccidentPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductInsuranceAccidentPanelVM productVM = new BookingFileProductInsuranceAccidentPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.INSURANCE_ACCIDENT.toString());
        MiscUtil.Pair<InsuranceAccident, InsuranceUIData> prototypeData = InsuranceAccidentFXHelper.getPrototypeData();
        InsuranceAccident product = (InsuranceAccident)prototypeData.getFirst();
        InsuranceUIData productSupplementData = (InsuranceUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductInsuranceAccidentPanel node = new BookingFileProductInsuranceAccidentPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            InsuranceAccidentFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductInsuranceAccidentPanelController controller = new BookingFileProductInsuranceAccidentPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductInsuranceAccidentPanel bookingFileProductInsuranceAccidentPanel = node;
            return bookingFileProductInsuranceAccidentPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductInsuranceAccidentPanel node = new BookingFileProductInsuranceAccidentPanel(false);
        InsuranceAccidentFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public void fromVM(BaseProductVM vm, InsuranceAccident product, InsuranceUIData productData) {
        BookingFileProductInsuranceAccidentPanelVM productVM = (BookingFileProductInsuranceAccidentPanelVM)vm;
        InsuranceAccidentFXHelper.fromVM(productVM, product, productData);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
        product.setStatisticalData(data);
    }

    @Override
    public ProductType getProductType(InsuranceAccident product) {
        return ProductType.INSURANCE_ACCIDENT;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductInsuranceAccidentSalesChainPane salesChainPane = ((BookingFileProductInsuranceAccidentPanel)node).getGeneralNode().getSalesChainNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)salesChainPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)salesChainPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileProductInsuranceAccidentPanel panel = (BookingFileProductInsuranceAccidentPanel)node;
        String systemNumber = panel.getGeneralNode().getTicketInfoNode().getTicketNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
        BigDecimal insuranceSum = (BigDecimal)((PriceValueWidget)panel.getCostNode().getInsuranceSumCell().getPayload()).getValue();
        String insuranceCurrency = ((CurrencyValueWidget)panel.getCostNode().getInsuranceCurrencyCell().getPayload()).getValue();
        if (insuranceSum != null && insuranceCurrency == null) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.insuranceAccidentMissingCurrency, (Object[])new Object[0]));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductInsuranceAccidentPanel) {
            BookingFileProductInsuranceAccidentPanel panel = (BookingFileProductInsuranceAccidentPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }
}

