/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServicePanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceParametersBaseInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceParametersOwnerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceRelatedProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceStatusesPaneVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.AdditionalServiceProductUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

public class AdditionalServiceProductFXHelper {
    public static void toVMParentParameters(AdditionalServiceProduct product, BookingFileProductAdditionalServicePanelVM view) {
        view.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        view.setUid(product.getUid());
    }

    public static void toVMParameters(BookingFileProductAdditionalServiceGeneralPanelVM view, AdditionalServiceProduct product, AdditionalServiceProductUIData productData, BookingFileProductAdditionalServiceStatusesPaneVM statuses, BookingFileProductAdditionalServiceRelatedProductsVM relatedProducts) {
        AdditionalServiceProductFXHelper.toVMInformationParameters(view.getBaseInformationParameters(), product);
        AdditionalServiceProductFXHelper.toVMOwnerParameters(view.getOwnerParameters(), product, productData);
        AdditionalServiceProductFXHelper.toVMControlStatusParameters(statuses, product, productData);
        AdditionalServiceProductFXHelper.toVMRelatedProducts(product, relatedProducts);
    }

    public static void fromVMParameters(BookingFileProductAdditionalServiceGeneralPanelVM view, AdditionalServiceProduct product, AdditionalServiceProductUIData productData, BookingFileProductAdditionalServiceStatusesPaneVM statuses, BookingFileProductAdditionalServiceRelatedProductsVM relatedProducts) {
        AdditionalServiceProductFXHelper.fromVMInformationParameters(view.getBaseInformationParameters(), product);
        AdditionalServiceProductFXHelper.fromVMOwnerParameters(view.getOwnerParameters(), product, productData);
        AdditionalServiceProductFXHelper.fromVMControlStatusParameters(statuses, product, productData);
        AdditionalServiceProductFXHelper.fromVMRelatedProducts(relatedProducts, product);
    }

    public static void fillBasicProductFields(AdditionalServiceProduct product) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getCategory() == AdditionalServiceCategory.CERTIFICATE_OF_COMPLETED_FLIGHT && product.getTicketType() == null) {
            product.setTicketType(TicketType.REFERRAL);
        }
    }

    private static void toVMInformationParameters(BookingFileProductAdditionalServiceParametersBaseInfoVM infoVM, AdditionalServiceProduct product) {
        infoVM.setProductValue(ProductType.ADDITIONAL_SERVICE.toString());
        infoVM.setCategoryValue(product.getCategory());
        infoVM.setStatusValue(EnumUtil.stringValueOf((Enum)product.getStatus()));
        infoVM.setTicketTypeValue(product.getTicketType());
        infoVM.setNumberValue(product.getSystemNumber());
        infoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        infoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
    }

    private static void toVMOwnerParameters(BookingFileProductAdditionalServiceParametersOwnerVM ownerVM, AdditionalServiceProduct product, AdditionalServiceProductUIData productData) {
        ownerVM.setAgencyValue(productData.getAgency());
        ownerVM.setSubagencyValue(productData.getSubagency());
        ownerVM.setBranchValue(product.getBranch());
        ownerVM.setSalesPointValue(product.getSalesPoint());
        ownerVM.setAgentValue(product.getAgent());
        ownerVM.setTravellerValue((Traveller)CollectionUtil.head((Iterable)product.getTravellers()));
        ownerVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        ownerVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
    }

    private static void toVMControlStatusParameters(BookingFileProductAdditionalServiceStatusesPaneVM statusesVM, AdditionalServiceProduct product, AdditionalServiceProductUIData productData) {
        statusesVM.setChecked(product.isChecked());
        statusesVM.setFinished(product.isCompleted());
        statusesVM.setHasErrors(productData.isHasErrors());
        statusesVM.setHasWarnings(productData.isHasWarnings());
        statusesVM.setRulesApplied(product.isContractRulesApplied());
    }

    public static void toVMRelatedProducts(AdditionalServiceProduct product, BookingFileProductAdditionalServiceRelatedProductsVM relatedProducts) {
        relatedProducts.setBookingFile(product.getReservation().getBookingFile());
        relatedProducts.setMainProductCode(product.getMainProductCode());
        relatedProducts.setMainProductNumber(product.getMainProductNumber());
        product.getRelatedProducts().forEach(p -> {
            BookingFileProductAdditionalServiceRelatedProductsTableVM productVM = new BookingFileProductAdditionalServiceRelatedProductsTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)p));
            productVM.setProductUID(p.getUid());
            relatedProducts.getRelatedTickets().add(productVM);
        });
    }

    private static void fromVMInformationParameters(BookingFileProductAdditionalServiceParametersBaseInfoVM infoVM, AdditionalServiceProduct product) {
        product.setCategory(infoVM.getCategoryValue());
        product.setTicketType(infoVM.getTicketTypeValue());
        product.setSystemNumber(infoVM.getNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)infoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)infoVM.getCorrectionDateValue()));
    }

    private static void fromVMOwnerParameters(BookingFileProductAdditionalServiceParametersOwnerVM ownerVM, AdditionalServiceProduct product, AdditionalServiceProductUIData productData) {
        Traveller traveller;
        productData.setAgency(ownerVM.getAgencyValue());
        productData.setSubagency(ownerVM.getSubagencyValue());
        productData.setSubagency(ownerVM.getSubagencyValue());
        product.setBranch(ownerVM.getBranchValue());
        product.setSalesPoint(ownerVM.getSalesPointValue());
        product.setAgent(ownerVM.getAgentValue());
        product.getTravellers().clear();
        if (ownerVM.getTravellerValue() != null && (traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), ownerVM.getTravellerValue().getUid())) != null) {
            product.getTravellers().add(traveller);
        }
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateSubagentValue()));
    }

    private static void fromVMControlStatusParameters(BookingFileProductAdditionalServiceStatusesPaneVM statusesVM, AdditionalServiceProduct product, AdditionalServiceProductUIData productData) {
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        productData.setHasErrors(statusesVM.isHasErrors());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
    }

    public static void fromVMRelatedProducts(BookingFileProductAdditionalServiceRelatedProductsVM productsVM, AdditionalServiceProduct product) {
        product.setMainProductCode(productsVM.getMainProductCode());
        product.setMainProductNumber(productsVM.getMainProductNumber());
        Map<String, BaseProduct> productMap = product.getReservation().getBookingFile().getReservations().stream().flatMap(el -> el.getProducts().stream()).filter(el -> el instanceof Product).map(el -> (Product)el).collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        product.getRelatedProducts().forEach(prod -> productMap.put(prod.getUid(), (BaseProduct)prod));
        product.getRelatedProducts().clear();
        product.getRelatedProducts().addAll(productsVM.getRelatedTickets().stream().map(vm -> (BaseProduct)productMap.get(vm.getProductUID())).collect(Collectors.toList()));
    }

    public static MiscUtil.Pair<AdditionalServiceProduct, AdditionalServiceProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        AdditionalServiceProduct product = new AdditionalServiceProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new AdditionalServiceProduct(), (Object)new AdditionalServiceProductUIData());
        }
        return prototypeData;
    }
}

