/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroExpressCostSumVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroExpressTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroExpressTravelerInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressCostPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressOtherParametersPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAeroexpressSalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.uidata.AeroexpressTicketUIData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

public class AeroexpressTicketFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVM(AeroexpressTicket product, AeroexpressTicketUIData productData, BookingFileProductAeroexpressPanelVM vm) {
        AeroexpressTicketFXHelper.toVMGeneral(product, vm.getGeneral(), productData);
        AeroexpressTicketFXHelper.toVMStatuses(product, vm.getStatuses(), productData);
        AeroexpressTicketFXHelper.toVMCostParameters(product, vm.getCost());
        AeroexpressTicketFXHelper.toVMOtherParameters(product, vm.getOtherParameters());
    }

    private static void toVMCostParameters(AeroexpressTicket product, BookingFileProductAeroexpressCostPaneVM costVM) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        costVM.setStatus(product.getStatus());
        BookingFileProductAeroExpressCostSumVM sumCell = costVM.getSum();
        String rub = "RUB";
        sumCell.setTariffCurrency("RUB");
        sumCell.setPenaltyCurrency("RUB");
        sumCell.setTotalCurrency("RUB");
        sumCell.setTariffSum(AeroexpressTicketFXHelper.getValue(product.getEquivalentFare(), negate));
        sumCell.setTotalSum(AeroexpressTicketFXHelper.getValue(AeroexpressTicketFXHelper.calculateTotal(product), negate));
        sumCell.setPenaltySum(product.getPenalty());
    }

    private static void toVMOtherParameters(AeroexpressTicket product, BookingFileProductAeroexpressOtherParametersPanelVM vm) {
        vm.setComments(product.getComments());
        vm.getAdditional().setBranch(product.getBranch());
        vm.getAdditional().setProvider(product.getProvider());
        vm.getAdditional().setProviderNum(product.getProviderSystemNumber());
    }

    private static void toVMGeneral(AeroexpressTicket product, BookingFileProductAeroexpressGeneralPanelVM vm, AeroexpressTicketUIData productData) {
        BookingFileProductAeroExpressTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        ticketInfoVM.setProductValue(ProductType.AEROEXPRESS.toString());
        ticketInfoVM.setTicketNumberValue(product.getSystemNumber());
        ticketInfoVM.setScnValue(product.getScn());
        if (product.getStatus() != null) {
            ticketInfoVM.setStatusValue(product.getStatus().toString());
        }
        ticketInfoVM.setBlankValue(product.getBlankType());
        ticketInfoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        ticketInfoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        ticketInfoVM.setBookingValue(product.getReservation().getUid());
        ticketInfoVM.setPccValue(product.getPcc());
        ticketInfoVM.setRelatedProductValue(product.getRelatedProduct());
        ticketInfoVM.setBookingNumberValue(product.getReservationId());
        BookingFileProductAeroExpressTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        travelerInfoVM.setArrivalValue(product.getArrivalLocation());
        travelerInfoVM.setDepartureValue(product.getDepartureLocation());
        travelerInfoVM.setDepartureDateValue(DateUtils.asLocalDateTime((Date)product.getDepartureDate()));
        travelerInfoVM.setClassOfServiceValue(product.getClassOfService());
        travelerInfoVM.setSeatValue(product.getSeat());
        travelerInfoVM.setPassengerValue(product.getTraveller());
        travelerInfoVM.setPassengerTypeValue(product.getPassengerType());
        travelerInfoVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        travelerInfoVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        BookingFileProductAeroexpressSalesChainPaneVM salesChainVM = vm.getSalesChain();
        salesChainVM.setBlankOwnerValue(product.getBlankOwner());
        salesChainVM.setSupplierValue(productData.getSupplier());
        salesChainVM.setAgencyValue(productData.getAgency());
        salesChainVM.setSubagencyValue(productData.getSubagency());
        salesChainVM.setSalesPointValue(product.getSalesPoint());
        salesChainVM.setPrescribeAgentValue(product.getAgent());
        salesChainVM.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMStatuses(AeroexpressTicket product, BookingFileProductStatusesPaneVM vm, AeroexpressTicketUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
    }

    public static void fromVM(BookingFileProductAeroexpressPanelVM vm, BookingFile bookingFile, AeroexpressTicket product, AeroexpressTicketUIData productData, boolean b) {
        AeroexpressTicketFXHelper.fromVMGeneral(product, productData, vm.getGeneral());
        AeroexpressTicketFXHelper.fromVMStatuses(vm.getStatuses(), product);
        AeroexpressTicketFXHelper.fromVMCost(vm.getCost(), product, productData);
        AeroexpressTicketFXHelper.fromVMOtherParameters(vm.getOtherParameters(), product);
    }

    private static void fromVMGeneral(AeroexpressTicket product, AeroexpressTicketUIData productData, BookingFileProductAeroexpressGeneralPanelVM vm) {
        BookingFileProductAeroExpressTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        product.setSystemNumber(ticketInfoVM.getTicketNumberValue());
        product.setScn(ticketInfoVM.getScnValue());
        product.setBlankType(ticketInfoVM.getBlankValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getCorrectionDateValue()));
        product.setPcc(ticketInfoVM.getPccValue());
        Map<String, Product> productMap = product.getReservation().getBookingFile().getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(prod -> prod instanceof Product).map(prod -> (Product)prod).collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        Product relatedProductValue = ticketInfoVM.getRelatedProductValue();
        if (relatedProductValue != null) {
            relatedProductValue = productMap.getOrDefault(ticketInfoVM.getRelatedProductValue().getUid(), ticketInfoVM.getRelatedProductValue());
        }
        product.setRelatedProduct(relatedProductValue);
        product.setReservationId(ticketInfoVM.getBookingNumberValue());
        BookingFileProductAeroExpressTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        product.setArrivalLocation(travelerInfoVM.getArrivalValue());
        product.setDepartureLocation(travelerInfoVM.getDepartureValue());
        product.setDepartureDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getDepartureDateValue()));
        product.setClassOfService(travelerInfoVM.getClassOfServiceValue());
        product.setSeat(travelerInfoVM.getSeatValue());
        if (travelerInfoVM.getPassengerValue() != null) {
            Traveller traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), travelerInfoVM.getPassengerValue().getUid());
            product.setTraveller(traveller);
        } else {
            product.setTraveller(null);
        }
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateSubagentValue()));
        product.setPassengerType(travelerInfoVM.getPassengerTypeValue());
        BookingFileProductAeroexpressSalesChainPaneVM salesChainVM = vm.getSalesChain();
        product.setBlankOwner(salesChainVM.getBlankOwnerValue());
        productData.setSupplier(salesChainVM.getSupplierValue());
        productData.setAgency(salesChainVM.getAgencyValue());
        productData.setSubagency(salesChainVM.getSubagencyValue());
        product.setSalesPoint(salesChainVM.getSalesPointValue());
        product.setAgent(salesChainVM.getPrescribeAgentValue());
        product.setTicketType(salesChainVM.getTicketTypeValue());
    }

    private static void fromVMCost(BookingFileProductAeroexpressCostPaneVM vm, AeroexpressTicket product, AeroexpressTicketUIData productData) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        product.setEquivalentFare(AeroexpressTicketFXHelper.getValue(vm.getSum().getTariffSum(), negate));
        product.setPenalty(vm.getSum().getPenaltySum());
    }

    private static void fromVMStatuses(BookingFileProductStatusesPaneVM vm, AeroexpressTicket product) {
        product.setChecked(vm.isChecked());
        product.setCompleted(vm.isFinished());
        product.setContractRulesApplied(vm.isRulesApplied());
    }

    private static void fromVMOtherParameters(BookingFileProductAeroexpressOtherParametersPanelVM vm, AeroexpressTicket product) {
        product.setComments(vm.getComments());
        product.setBranch(vm.getAdditional().getBranch());
        product.setProvider(vm.getAdditional().getProvider());
        product.setProviderSystemNumber(vm.getAdditional().getProviderNum());
    }

    public static void fillBasicProductFields(AeroexpressTicket product) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
    }

    private static BigDecimal calculateTotal(AeroexpressTicket product) {
        BigDecimal result = BigDecimal.ZERO;
        if (product.getEquivalentFare() != null) {
            result = result.add(product.getEquivalentFare());
        }
        if (product.getPenalty() != null) {
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                result = result.subtract(product.getPenalty());
            } else if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                result = result.add(product.getPenalty());
            }
        }
        return result;
    }

    public static MiscUtil.Pair<AeroexpressTicket, AeroexpressTicketUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        AeroexpressTicket product = new AeroexpressTicket();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new AeroexpressTicket(), (Object)new AeroexpressTicketUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductAeroexpressPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(AeroexpressTicket.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

