/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentSalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentTravelerInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceChildCostVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

public class InsuranceAccidentFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVM(BookingFileProductInsuranceAccidentPanelVM vm, InsuranceAccident product, InsuranceUIData productData) {
        vm.setUid(product.getUid());
        vm.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        vm.setBookingFile(product.getReservation().getBookingFile());
        InsuranceAccidentFXHelper.toVMGeneral(vm.getGeneral(), product, productData);
        InsuranceAccidentFXHelper.toVMStatuses(vm.getStatuses(), product, productData);
        InsuranceAccidentFXHelper.toVMCost(vm.getCost(), product, productData);
        vm.getOtherParameters().setComments(product.getComments());
    }

    private static void toVMCost(BookingFileProductInsuranceChildCostVM vm, InsuranceAccident product, InsuranceUIData productData) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        Money insuranceSum = product.getInsuranceSum();
        vm.setInsuranceSum(insuranceSum != null ? InsuranceAccidentFXHelper.getValue(insuranceSum.getValue(), negate) : null);
        vm.setInsuranceCurrency(insuranceSum != null ? insuranceSum.getCurrency() : null);
        vm.setInsurancePremiumSum(InsuranceAccidentFXHelper.getValue(product.getEquivalentSum(), negate));
        vm.setInsurancePremiumCurrency(productData.getCurrency());
        VatValue vatValue = product.getEquivalentFareVatValue();
        if (vatValue != null) {
            vm.getInsurancePremiumSumVat().setVatAmount(InsuranceAccidentFXHelper.getValue(vatValue.getAmount(), negate));
            vm.getInsurancePremiumSumVat().setVatRate(vatValue.getRate());
        }
    }

    private static void toVMGeneral(BookingFileProductInsuranceAccidentGeneralPanelVM vm, InsuranceAccident product, InsuranceUIData productData) {
        BookingFileProductInsuranceAccidentTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        ticketInfoVM.setProductValue(ProductType.INSURANCE_ACCIDENT.toString());
        ticketInfoVM.setTicketNumberValue(product.getSystemNumber());
        ticketInfoVM.setScnValue(product.getScn());
        ticketInfoVM.setStatusValue(productStatus != null ? productStatus.toString() : null);
        ticketInfoVM.setBlankValue(product.getBlankType());
        ticketInfoVM.setReservationValue(product.getReservation().getUid());
        ticketInfoVM.setDepartureDateValue(DateUtils.asLocalDateTime((Date)product.getDepartureDate()));
        ticketInfoVM.setDeparturePointValue(product.getDepartureLocationName());
        ticketInfoVM.setArrivalPointValue(product.getArrivalLocationName());
        BookingFileProductInsuranceAccidentTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        travelerInfoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        travelerInfoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        BookingFile bookingFile = product.getReservation().getBookingFile();
        Traveller traveller = BookingHelper.findTraveller((BookingFile)bookingFile, (String)product.getTravellerUid());
        BaseProduct relatedProduct = BookingHelper.findProductByUid((String)product.getRelatedProductUid(), (BookingFile)bookingFile);
        travelerInfoVM.setPassenger(traveller);
        travelerInfoVM.setPassengerType(product.getPassengerType());
        travelerInfoVM.setRelatedValue(relatedProduct);
        travelerInfoVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        travelerInfoVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        BookingFileProductInsuranceAccidentSalesChainPaneVM salesChainVM = vm.getSalesChain();
        salesChainVM.setBlankOwnerValue(product.getBlankOwner());
        salesChainVM.setSupplierValue(productData.getSupplier());
        salesChainVM.setAgencyValue(productData.getAgency());
        salesChainVM.setSubagencyValue(productData.getSubagency());
        salesChainVM.setBranchValue(product.getBranch());
        salesChainVM.setSalesPointValue(product.getSalesPoint());
        salesChainVM.setPrescribeAgentValue(product.getAgent());
        salesChainVM.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMStatuses(BookingFileProductStatusesPaneVM vm, InsuranceAccident product, InsuranceUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
    }

    public static void fromVM(BookingFileProductInsuranceAccidentPanelVM vm, InsuranceAccident product, InsuranceUIData productData) {
        BookingFileProductInsuranceAccidentTicketInfoPaneVM ticketInfoVM = vm.getGeneral().getTicketInfo();
        product.setSystemNumber(ticketInfoVM.getTicketNumberValue());
        product.setScn(ticketInfoVM.getScnValue());
        product.setBlankType(ticketInfoVM.getBlankValue());
        BookingFileProductInsuranceAccidentTravelerInfoPaneVM travelerInfoVM = vm.getGeneral().getTravelerInfo();
        Traveller passenger = travelerInfoVM.getPassenger();
        BaseProduct relatedValue = travelerInfoVM.getRelatedValue();
        product.setIssueDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getCorrectionDateValue()));
        product.setTravellerUid(passenger != null ? passenger.getUid() : null);
        product.setPassengerType(travelerInfoVM.getPassengerType());
        product.setDepartureDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getDepartureDateValue()));
        product.setDepartureLocationName(ticketInfoVM.getDeparturePointValue());
        product.setArrivalLocationName(ticketInfoVM.getArrivalPointValue());
        product.setRelatedProductUid(relatedValue != null ? relatedValue.getUid() : null);
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateSubagentValue()));
        BookingFileProductInsuranceAccidentSalesChainPaneVM salesChainVM = vm.getGeneral().getSalesChain();
        product.setBlankOwner(salesChainVM.getBlankOwnerValue());
        productData.setSupplier(salesChainVM.getSupplierValue());
        productData.setAgency(salesChainVM.getAgencyValue());
        productData.setSubagency(salesChainVM.getSubagencyValue());
        product.setBranch(salesChainVM.getBranchValue());
        product.setSalesPoint(salesChainVM.getSalesPointValue());
        product.setAgent(salesChainVM.getPrescribeAgentValue());
        product.setTicketType(salesChainVM.getTicketTypeValue());
        BookingFileProductStatusesPaneVM statusesVM = vm.getStatuses();
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
        InsuranceAccidentFXHelper.fromVMCost(vm.getCost(), product);
        product.setComments(vm.getOtherParameters().getComments());
    }

    private static void fromVMCost(BookingFileProductInsuranceChildCostVM vm, InsuranceAccident product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BigDecimal insuranceSum = InsuranceAccidentFXHelper.getValue(vm.getInsuranceSum(), negate);
        String insuranceCurrency = vm.getInsuranceCurrency();
        product.setInsuranceSum(insuranceSum != null ? MoneyHelper.buildMoney((BigDecimal)insuranceSum, (String)insuranceCurrency) : null);
        product.setEquivalentSum(InsuranceAccidentFXHelper.getValue(vm.getInsurancePremiumSum(), negate));
        if (product.getEquivalentFareVatValue() == null) {
            product.setEquivalentFareVatValue(new VatValue());
        }
        product.getEquivalentFareVatValue().setRate(vm.getInsurancePremiumSumVat().getVatRate());
        product.getEquivalentFareVatValue().setAmount(InsuranceAccidentFXHelper.getValue(vm.getInsurancePremiumSumVat().getVatAmount(), negate));
    }

    public static MiscUtil.Pair<InsuranceAccident, InsuranceUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        InsuranceAccident product = new InsuranceAccident();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new InsuranceAccident(), (Object)new InsuranceUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductInsuranceAccidentPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(InsuranceAccident.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

