/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductGeneralTaxesTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRatesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductAdditionalPopupsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductDetailingParametersVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductParametersBaseInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductParametersCostSumVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductParametersCostVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductParametersOwnerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductVatDetailsRowVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.uidata.UniversalProductUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class UniversalProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void fillBasicProductFields(UniversalProduct product) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
    }

    public static void toVMParentParameters(UniversalProduct product, BookingFileUniversalProductPanelVM view) {
        view.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        view.setUid(product.getUid());
        view.setBlankOwnerAndSupplierAreAgency(UniversalProductFXHelper.getDescription(product).isBlankOwnerAndSupplierAreAgency());
    }

    public static void toVMParameters(BookingFileUniversalProductGeneralPanelVM view, UniversalProduct product, UniversalProductUIData productData, BookingFileUniversalProductStatusesPaneVM statuses) {
        UniversalProductFXHelper.toVMInformationParameters(view.getBaseInformationParameters(), product);
        UniversalProductFXHelper.toVMOwnerParameters(view.getOwnerParameters(), product, productData);
        UniversalProductFXHelper.toVMControlStatusParameters(statuses, product, productData);
    }

    private static void toVMInformationParameters(BookingFileUniversalProductParametersBaseInfoVM infoVM, UniversalProduct product) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        String productName = L10nResourcesManager.getStr((String)"UNIVERSAL_PRODUCT_NAME", (Object[])new Object[0]);
        infoVM.setProductValue(product.getDescription().getCaption() == null ? productName : product.getDescription().getCaption());
        infoVM.setStatusValue(productStatus != null ? productStatus.toString() : null);
        infoVM.setTicketTypeValue(product.getTicketType());
        infoVM.setTicketNumberValue(product.getSystemNumber());
        infoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        infoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        infoVM.setScnValue(product.getScn());
        infoVM.setBlankValue(product.getBlankType());
        infoVM.setIsNotesSupported(UniversalProductFXHelper.getDescription(product).isNotesSupported());
        infoVM.setHasVAT(product.isHasVat());
    }

    private static void toVMOwnerParameters(BookingFileUniversalProductParametersOwnerVM ownerVM, UniversalProduct product, UniversalProductUIData productData) {
        ownerVM.setBlankOwnerValue(product.getBlankOwner());
        ownerVM.setSupplierValue(productData.getSupplier());
        ownerVM.setAgencyValue(productData.getAgency());
        ownerVM.setSubagencyValue(productData.getSubagency());
        ownerVM.setSalesPointValue(product.getSalesPoint());
        ownerVM.setPrescribeAgentValue(product.getAgent());
        ownerVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        ownerVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        List travellers = product.getReservation().getBookingFile().getTravellers();
        if (UniversalProductFXHelper.getDescription(product).isFewTravellersSupported()) {
            ownerVM.setIsFewTravellersSupported(true);
            VMHelper.transfer(travellers.stream().filter(item -> product.getTravellersUids().contains(item.getUid())).collect(Collectors.toList()), ownerVM.getTravellersValue());
        } else {
            String travellerUid;
            ownerVM.setIsFewTravellersSupported(false);
            String string = travellerUid = product.getTravellersUids().size() > 0 ? (String)product.getTravellersUids().get(0) : null;
            if (travellerUid != null) {
                ownerVM.setPassengerValue((Traveller)travellers.stream().filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)travellerUid)).findFirst().orElse(null));
            }
        }
    }

    private static void toVMControlStatusParameters(BookingFileUniversalProductStatusesPaneVM statusesVM, UniversalProduct product, UniversalProductUIData productData) {
        statusesVM.setChecked(product.isChecked());
        statusesVM.setFinished(product.isCompleted());
        statusesVM.setHasErrors(productData.isHasErrors());
        statusesVM.setHasWarnings(productData.isHasWarnings());
        statusesVM.setRulesApplied(product.isContractRulesApplied());
    }

    public static void toVMCost(BookingFileUniversalProductPanelVM vm, UniversalProduct product, VatAmount totalPrice, boolean showBaseFare) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        vm.getCost().setVatRecalc(product.isDontRecalcVat());
        BookingFileUniversalProductParametersCostSumVM sumVM = vm.getCost().getSumCell();
        String currency = product.getEquivalentCurrency();
        if (TextUtil.isBlank((String)currency)) {
            currency = Prefetched.getData().getEquivalentCurrency();
        }
        BookingFileProductRatesPaneVM ratesVM = vm.getCost().getRates();
        sumVM.setTotalCurrency(currency);
        sumVM.setEqTariffSum(UniversalProductFXHelper.getValue(product.getEquivalentFare(), negate));
        sumVM.setEqTariffCurrency(currency);
        sumVM.setPenaltySum(product.getPenalty());
        sumVM.setPenaltyCurrency(currency);
        ratesVM.setEqCurrencyValue(currency);
        if (showBaseFare) {
            ratesVM.setRateValue(product.getRateWithCoeff() == null ? null : Double.valueOf(product.getRateWithCoeff().doubleValue()));
            if (product.getBaseFare() != null) {
                sumVM.setTariffSum(UniversalProductFXHelper.getValue(product.getBaseFare().getValue(), negate));
                sumVM.setTariffCurrency(product.getBaseFare().getCurrency());
                ratesVM.setBaseCurrencyValue(product.getBaseFare().getCurrency());
            }
        }
        BigDecimal total = BigDecimal.ZERO;
        if (totalPrice != null) {
            total = totalPrice.getTotal();
            if (ProductStatus.REFUND == product.getStatus()) {
                total = total.negate();
            }
        }
        sumVM.setTotalSum(total);
        sumVM.setVatIncludedEqTariff(UniversalProductFXHelper.getValue(UniversalProductHelper.calculateVatComponentsSum((UniversalProduct)product, (VatBasisType)VatBasisType.FARE), negate));
        sumVM.setVatIncludedTaxes(UniversalProductFXHelper.getValue(UniversalProductHelper.calculateVatComponentsSum((UniversalProduct)product, (VatBasisType)VatBasisType.TAXES), negate));
        sumVM.setVatIncludedTotal(UniversalProductFXHelper.getValue(product.getTotalVat(), negate));
        BigDecimal sum = BigDecimal.ZERO;
        for (GeneralProductTax tax2 : product.getTaxes()) {
            sum = sum.add(MiscUtil.guarded((BigDecimal)tax2.getEquivalentAmount()));
        }
        sumVM.setTaxesSum(UniversalProductFXHelper.getValue(sum, negate));
        sumVM.setTaxesCurrency(currency);
        VMHelper.transfer(product.getTaxes(), vm.getCost().getGeneralTaxes().getContent(), taxModel -> new BookingFileProductGeneralTaxesTableVM(), (tax, taxVm) -> {
            Money amount;
            if (tax.getAmount() == null) {
                amount = null;
            } else {
                amount = new Money();
                amount.setUid(tax.getAmount().getUid());
                amount.setCurrency(tax.getAmount().getCurrency());
                amount.setValue(UniversalProductFXHelper.getValue(tax.getAmount().getValue(), negate));
            }
            taxVm.setAmount(amount);
            taxVm.setCode(tax.getCode());
            taxVm.setEqSum(UniversalProductFXHelper.getValue(tax.getEquivalentAmount(), negate));
        });
        ArrayList<BookingFileUniversalProductVatDetailsRowVM> vatsVM = new ArrayList<BookingFileUniversalProductVatDetailsRowVM>();
        if (product.getVendorVatDetalization() != null) {
            vatsVM.addAll(UniversalProductFXHelper.toVMVats(negate, product.getVendorVatDetalization().getComponents()));
        }
        vm.getCost().getDetailsVat().getContent().addAll(vatsVM);
    }

    public static void toVMComments(BookingFileUniversalProductAdditionalPopupsVM view, UniversalProduct product) {
        view.setComments(product.getComments());
    }

    public static void toVMDetailingParameters(BookingFileUniversalProductDetailingParametersVM modelVM, UniversalProduct product) {
        VMHelper.transfer(product.getCustomParameters(), modelVM.getAdditionalParameters().getCustomParameters());
        VMHelper.transfer(UniversalProductFXHelper.getDescription(product).getCustomParameters(), modelVM.getAdditionalParameters().getCustomParametersDescription());
    }

    private static List<BookingFileUniversalProductVatDetailsRowVM> toVMVats(boolean negate, List<VatComponent> vatComponents) {
        ArrayList<BookingFileUniversalProductVatDetailsRowVM> vatsVM = new ArrayList<BookingFileUniversalProductVatDetailsRowVM>();
        for (VatComponent vatComponent : vatComponents) {
            BookingFileUniversalProductVatDetailsRowVM rowVM = new BookingFileUniversalProductVatDetailsRowVM();
            rowVM.setUid(vatComponent.getUid());
            rowVM.setRate(vatComponent.getRate() == null ? null : new BigDecimal(vatComponent.getRate()));
            rowVM.setBasis(UniversalProductFXHelper.getValue(vatComponent.getBasis(), negate));
            rowVM.setSum(UniversalProductFXHelper.getValue(vatComponent.getSum(), negate));
            rowVM.getBasisTypes().addAll(vatComponent.getBasisTypes());
            rowVM.getTaxesUids().addAll(vatComponent.getTaxesUids());
            vatsVM.add(rowVM);
        }
        return vatsVM;
    }

    public static void fromVMParameters(BookingFileUniversalProductGeneralPanelVM view, UniversalProduct product, UniversalProductUIData productData, BookingFileUniversalProductStatusesPaneVM statuses) {
        UniversalProductFXHelper.fromVMInformationParameters(view.getBaseInformationParameters(), product);
        UniversalProductFXHelper.fromVMOwnerParameters(view.getOwnerParameters(), product, productData);
        UniversalProductFXHelper.fromVMControlStatusParameters(statuses, product, productData);
    }

    private static void fromVMInformationParameters(BookingFileUniversalProductParametersBaseInfoVM infoVM, UniversalProduct product) {
        product.setTicketType(infoVM.getTicketTypeValue());
        product.setSystemNumber(infoVM.getTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)infoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)infoVM.getCorrectionDateValue()));
        product.setScn(infoVM.getScnValue());
        product.setBlankType(infoVM.getBlankValue());
        product.setHasVat(infoVM.isHasVAT());
    }

    private static void fromVMOwnerParameters(BookingFileUniversalProductParametersOwnerVM ownerVM, UniversalProduct product, UniversalProductUIData productData) {
        product.setBlankOwner(ownerVM.getBlankOwnerValue());
        productData.setSupplier(ownerVM.getSupplierValue());
        productData.setAgency(ownerVM.getAgencyValue());
        productData.setSubagency(ownerVM.getSubagencyValue());
        product.setSalesPoint(ownerVM.getSalesPointValue());
        product.setAgent(ownerVM.getPrescribeAgentValue());
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateSubagentValue()));
        if (ownerVM.isIsFewTravellersSupported()) {
            VMHelper.transfer(ownerVM.getTravellersValue().stream().map(BaseIdentity::getUid).collect(Collectors.toList()), product.getTravellersUids());
        } else {
            product.getTravellersUids().clear();
            if (ownerVM.getPassengerValue() != null) {
                product.getTravellersUids().add(ownerVM.getPassengerValue().getUid());
            }
        }
    }

    private static void fromVMControlStatusParameters(BookingFileUniversalProductStatusesPaneVM statusesVM, UniversalProduct product, UniversalProductUIData productData) {
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        productData.setHasErrors(statusesVM.isHasErrors());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
    }

    public static void fromVMCost(BookingFileUniversalProductParametersCostVM costVM, UniversalProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileUniversalProductParametersCostSumVM sumVM = costVM.getSumCell();
        product.setDontRecalcVat(costVM.isVatRecalc());
        Money fare = new Money();
        fare.setValue(UniversalProductFXHelper.getValue(sumVM.getTariffSum(), negate));
        fare.setCurrency(sumVM.getTariffCurrency());
        product.setBaseFare(fare);
        product.setEquivalentCurrency(sumVM.getEqTariffCurrency());
        product.setEquivalentFare(UniversalProductFXHelper.getValue(sumVM.getEqTariffSum(), negate));
        product.setPenalty(sumVM.getPenaltySum());
        product.setTotalVat(sumVM.getVatIncludedTotal());
        BookingFileProductRatesPaneVM ratesVM = costVM.getRates();
        product.setRateWithCoeff(ratesVM.getRateValue() == null ? null : BigDecimal.valueOf(ratesVM.getRateValue()));
        VMHelper.transfer(costVM.getGeneralTaxes().getContent(), product.getTaxes(), vm -> new GeneralProductTax(), (vm, tax) -> {
            tax.setEquivalentAmount(UniversalProductFXHelper.getValue(vm.getEqSum(), negate));
            tax.setCode(vm.getCode());
            Money amount = vm.getAmount();
            if (amount != null) {
                amount.setValue(UniversalProductFXHelper.getValue(amount.getValue(), negate));
            }
            tax.setAmount(amount);
        });
        UniversalProductFXHelper.fromVMVatComponents(negate, costVM.getDetailsVat().getContent(), product);
    }

    public static void fromVMComments(BookingFileUniversalProductAdditionalPopupsVM view, UniversalProduct product) {
        product.setComments(view.getComments());
    }

    public static void fromVMDetailingParameters(BookingFileUniversalProductDetailingParametersVM modelVM, UniversalProduct product) {
        VMHelper.transfer(modelVM.getAdditionalParameters().getCustomParameters(), product.getCustomParameters());
    }

    public static MiscUtil.Pair<UniversalProduct, UniversalProductUIData> getPrototypeData(EntityReference<UniversalProductDescription> description) {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        UniversalProduct product = new UniversalProduct();
        product.setDescription(description);
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), description, agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new UniversalProduct(), (Object)new UniversalProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileUniversalProductPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(UniversalProduct.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }

    public static UniversalProductDescription getDescription(UniversalProduct product) {
        Objects.requireNonNull(product.getDescription(), "Universal product description is null in product");
        return Prefetched.getData().getUniversalProductDescriptionData().stream().filter(descriptionData -> product.getDescription().equals((Object)descriptionData.getReference())).map(UniversalProductDescriptionData::getData).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"Universal product description data for description {0} is not found", (Object[])new Object[]{product.getDescription()}));
    }

    private static void fromVMVatComponents(boolean negate, List<BookingFileUniversalProductVatDetailsRowVM> vatVM, UniversalProduct product) {
        VatDetalization detalization = product.getVendorVatDetalization();
        if (detalization == null) {
            detalization = new VatDetalization();
            product.setVendorVatDetalization(detalization);
        }
        VMHelper.transfer(vatVM, detalization.getComponents(), v -> new VatComponent(), (componentVM, vat) -> {
            vat.setRate(componentVM.getRate() == null ? null : Double.valueOf(componentVM.getRate().doubleValue()));
            vat.setBasis(UniversalProductFXHelper.getValue(componentVM.getBasis(), negate));
            vat.setSum(UniversalProductFXHelper.getValue(componentVM.getSum(), negate));
            vat.getBasisTypes().clear();
            vat.getBasisTypes().addAll(componentVM.getBasisTypes());
            vat.getTaxesUids().clear();
            vat.getTaxesUids().addAll(componentVM.getTaxesUids());
        });
    }
}

