/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaParametersBaseInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaParametersCostSumVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaParametersCostVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaParametersOwnerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.VisaProductUIData;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;

public class VisaProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVMParentParameters(VisaProduct product, BookingFileProductVisaPanelVM view) {
        view.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        view.setUid(product.getUid());
    }

    public static void toVMParameters(BookingFileProductVisaGeneralPanelVM view, VisaProduct product, VisaProductUIData productData, BookingFileProductVisaStatusesPaneVM statuses) {
        VisaProductFXHelper.toVMInformationParameters(view.getBaseInformationParameters(), product);
        VisaProductFXHelper.toVMOwnerParameters(view.getOwnerParameters(), product, productData);
        VisaProductFXHelper.toVMControlStatusParameters(statuses, product, productData);
    }

    public static void fromVMParameters(BookingFileProductVisaGeneralPanelVM view, VisaProduct product, VisaProductUIData productData, BookingFileProductVisaStatusesPaneVM statuses) {
        VisaProductFXHelper.fromVMInformationParameters(view.getBaseInformationParameters(), product);
        VisaProductFXHelper.fromVMOwnerParameters(view.getOwnerParameters(), product, productData);
        VisaProductFXHelper.fromVMControlStatusParameters(statuses, product, productData);
    }

    public static void fillBasicProductFields(VisaProduct product) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
    }

    private static void toVMInformationParameters(BookingFileProductVisaParametersBaseInfoVM infoVM, VisaProduct product) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        infoVM.setProductValue(ProductType.VISA_PRODUCT.toString());
        infoVM.setStatusValue(productStatus != null ? productStatus.toString() : null);
        infoVM.setTicketTypeValue(product.getTicketType());
        infoVM.setVisaNumberValue(product.getSystemNumber());
        infoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        infoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        infoVM.setCountryValue(product.getCountry());
        infoVM.setTypeValue(product.getType());
        infoVM.setEntryTypeValue(product.getEntryType());
        infoVM.setApplicationStatusValue(product.getApplicationStatus());
        infoVM.setExpressServiceValue(product.isExpressService());
        infoVM.setStartDateValue(DateUtils.asLocalDate((Date)product.getStartDate()));
        infoVM.setEndDateValue(DateUtils.asLocalDate((Date)product.getEndDate()));
    }

    private static void toVMOwnerParameters(BookingFileProductVisaParametersOwnerVM ownerVM, VisaProduct product, VisaProductUIData productData) {
        ownerVM.setSupplierValue(productData.getSupplier());
        ownerVM.setAgencyValue(productData.getAgency());
        ownerVM.setSubagencyValue(productData.getSubagency());
        ownerVM.setSalesPointValue(product.getSalesPoint());
        ownerVM.setAgentValue(product.getAgent());
        ownerVM.getTravellersValue().addAll(product.getTravellers());
        ownerVM.setNotesValue(product.getNotes());
        ownerVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        ownerVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
    }

    private static void toVMControlStatusParameters(BookingFileProductVisaStatusesPaneVM statusesVM, VisaProduct product, VisaProductUIData productData) {
        statusesVM.setChecked(product.isChecked());
        statusesVM.setFinished(product.isCompleted());
        statusesVM.setHasErrors(productData.isHasErrors());
        statusesVM.setHasWarnings(productData.isHasWarnings());
        statusesVM.setRulesApplied(product.isContractRulesApplied());
    }

    public static void toVMCost(BookingFileProductVisaParametersCostVM costVM, VisaProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductVisaParametersCostSumVM sumVM = costVM.getSumCell();
        BigDecimal ndsValue = null;
        String currency = null;
        if (product.getFare() != null) {
            currency = product.getFare().getCurrency();
            sumVM.setTariffSum(VisaProductFXHelper.getValue(product.getFare().getValue(), negate));
            sumVM.setTariffCurrency(currency);
        }
        if (product.getEquivalentFare() != null) {
            currency = product.getEquivalentFare().getCurrency();
            sumVM.setEqTariffSum(VisaProductFXHelper.getValue(product.getEquivalentFare().getValue(), negate));
            sumVM.setEqTariffCurrency(currency);
        }
        if (product.getEquivalentFareVatValue() != null) {
            VatValue vatValue = product.getEquivalentFareVatValue();
            sumVM.getVatIncludedEqTariff().setVatRate(vatValue.getRate());
            ndsValue = vatValue.getAmount();
            sumVM.getVatIncludedEqTariff().setVatAmount(VisaProductFXHelper.getValue(ndsValue, negate));
        }
        sumVM.setPenaltySum(product.getPenalty());
        if (product.getPenaltyVatValue() != null) {
            VatValue penaltyVatValue = product.getPenaltyVatValue();
            sumVM.getVatIncludedPenalty().setVatRate(penaltyVatValue.getRate());
            sumVM.getVatIncludedPenalty().setVatAmount(penaltyVatValue.getAmount());
        }
        sumVM.setPenaltyCurrency(currency);
        sumVM.setTotalSum(VisaProductHelper.getTotalPrice((VisaProduct)product));
        sumVM.setVatIncludedTotal(VisaProductFXHelper.getValue(ndsValue, negate));
        sumVM.setTotalCurrency(currency);
    }

    public static void toVMComments(BookingFileProductVisaPanelVM view, VisaProduct product) {
        view.getOtherParameters().getPopups().setComments(product.getComments());
    }

    private static void fromVMInformationParameters(BookingFileProductVisaParametersBaseInfoVM infoVM, VisaProduct product) {
        product.setTicketType(infoVM.getTicketTypeValue());
        product.setSystemNumber(infoVM.getVisaNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)infoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)infoVM.getCorrectionDateValue()));
        product.setCountry(infoVM.getCountryValue());
        product.setType(infoVM.getTypeValue());
        product.setEntryType(infoVM.getEntryTypeValue());
        product.setApplicationStatus(infoVM.getApplicationStatusValue());
        product.setExpressService(infoVM.isExpressServiceValue());
        product.setStartDate(DateUtils.asDate((LocalDate)infoVM.getStartDateValue()));
        product.setEndDate(DateUtils.asDate((LocalDate)infoVM.getEndDateValue()));
    }

    private static void fromVMOwnerParameters(BookingFileProductVisaParametersOwnerVM ownerVM, VisaProduct product, VisaProductUIData productData) {
        productData.setSupplier(ownerVM.getSupplierValue());
        productData.setAgency(ownerVM.getAgencyValue());
        productData.setSubagency(ownerVM.getSubagencyValue());
        product.setSalesPoint(ownerVM.getSalesPointValue());
        product.setAgent(ownerVM.getAgentValue());
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateSubagentValue()));
        product.getTravellers().clear();
        product.getTravellers().addAll(ownerVM.getTravellersValue().stream().filter(Objects::nonNull).map(t -> GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), t.getUid())).filter(Objects::nonNull).collect(Collectors.toList()));
        product.setNotes(ownerVM.getNotesValue());
    }

    private static void fromVMControlStatusParameters(BookingFileProductVisaStatusesPaneVM statusesVM, VisaProduct product, VisaProductUIData productData) {
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        productData.setHasErrors(statusesVM.isHasErrors());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
    }

    public static void fromVMCost(BookingFileProductVisaParametersCostVM costVM, VisaProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductVisaParametersCostSumVM sumVM = costVM.getSumCell();
        if (product.getFare() == null) {
            product.setFare(new Money());
        }
        product.getFare().setValue(VisaProductFXHelper.getValue(sumVM.getTariffSum(), negate));
        product.getFare().setCurrency(sumVM.getTariffCurrency());
        if (product.getEquivalentFare() == null) {
            product.setEquivalentFare(new Money());
        }
        product.getEquivalentFare().setValue(VisaProductFXHelper.getValue(sumVM.getEqTariffSum(), negate));
        product.getEquivalentFare().setCurrency(sumVM.getEqTariffCurrency());
        if (product.getEquivalentFareVatValue() == null) {
            product.setEquivalentFareVatValue(new VatValue());
        }
        product.getEquivalentFareVatValue().setAmount(VisaProductFXHelper.getValue(sumVM.getVatIncludedEqTariff().getVatAmount(), negate));
        product.getEquivalentFareVatValue().setRate(sumVM.getVatIncludedEqTariff().getVatRate());
        product.setPenalty(sumVM.getPenaltySum());
        if (product.getPenaltyVatValue() == null) {
            product.setPenaltyVatValue(new VatValue());
        }
        product.getPenaltyVatValue().setRate(sumVM.getVatIncludedPenalty().getVatRate());
        product.getPenaltyVatValue().setAmount(VisaProductFXHelper.getValue(sumVM.getVatIncludedPenalty().getVatAmount(), negate));
    }

    public static void fromVMComments(BookingFileProductVisaPanelVM view, VisaProduct product) {
        product.setComments(view.getOtherParameters().getPopups().getComments());
    }

    public static MiscUtil.Pair<VisaProduct, VisaProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        VisaProduct product = new VisaProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new VisaProduct(), (Object)new VisaProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductVisaPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(VisaProduct.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

