/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.BranchAddressGeneralPanelController;
import com.gridnine.xtrip.client.fx.model.profile.BranchAddressGeneralPanelVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class BranchAddressGeneralPanelControllerInterceptor
extends ControllerInterceptor<BranchAddressGeneralPanelVM, BranchAddressGeneralPanelController> {
    private static final List<AddressType> ADDRESS_TYPES = Arrays.asList(AddressType.FACTUAL, AddressType.LEGAL, AddressType.DELIVERY, AddressType.CONTACT);

    protected Class<BranchAddressGeneralPanelController> getControllerClass() {
        return BranchAddressGeneralPanelController.class;
    }

    protected void onCreate(BranchAddressGeneralPanelController controller) {
        controller.getView().getTypeNode().setItemsSupplier(() -> ADDRESS_TYPES);
        controller.getView().getCityNode().setListParametersSupplier(() -> {
            DictListParameters dictListParameters = new DictListParameters();
            TableColumnSettings codes = new TableColumnSettings();
            codes.setId(BaseDictionary.Property.codeVariants.name());
            codes.setDisplayName(Messages.Codes);
            codes.setRenderer((Renderer)StandardRenderers.CODE_VARIANTS);
            TableColumnSettings names = new TableColumnSettings();
            names.setId(BaseDictionary.Property.translations.name());
            names.setDisplayName(Messages.Names);
            names.setRenderer((Renderer)StandardRenderers.TRANSLATIONS);
            TableColumnSettings country = new TableColumnSettings();
            country.setId(GeoLocation.Property.country.name());
            country.setDisplayName(Messages.Country);
            country.setRenderer((Renderer)StandardRenderers.GENERIC);
            dictListParameters.getColumns().add(codes);
            dictListParameters.getColumns().add(names);
            dictListParameters.getColumns().add(country);
            dictListParameters.getFilters().add(codes);
            dictListParameters.getFilters().add(names);
            dictListParameters.getFilters().add(country);
            dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.type.name(), new Object[]{LocationType.CITY}));
            if (controller.getView().getCountryNode().valueProperty().get() != null) {
                dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.country.name(), new Object[]{controller.getView().getCountryNode().valueProperty().get()}));
            }
            return dictListParameters;
        });
        controller.getView().getCityNode().valueProperty().addListener((obj, oldValue, newValue) -> {
            if (controller.getView().getCountryNode().valueProperty().get() == null) {
                Notifications.get().submitTask(() -> {
                    try {
                        controller.getView().getCountryNode().setDisable(true);
                        ServiceInvocationContext sic = ServiceInvocationContext.get();
                        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                        GeoLocation city = (GeoLocation)dictService.load(sic, newValue);
                        if (city != null) {
                            FxUtil.waitForFxThread(() -> {
                                controller.getView().getCountryNode().valueProperty().set((Object)city.getCountry());
                                controller.getView().getCountryNode().setDisable(false);
                            });
                        }
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }, ObservableMutex.lookup((Node)controller.getView()));
            }
        });
    }
}

