/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.AppliedToVM;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsBigTableVM;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractMainFullPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRateVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import java.time.LocalDate;
import java.util.Date;

final class ClientContractTileHelper {
    private ClientContractTileHelper() {
    }

    static void toVM(Contract model, ClientContractMainFullPanelVM fullGeneral) {
        fullGeneral.getClientContract().setName(model.getName());
        fullGeneral.getClientContract().setSupplier(model.getSupplier());
        fullGeneral.getClientContract().setTypicalContract(model.isTypicalContract());
        fullGeneral.getClientContract().setPriority(model.getPriority());
        VMHelper.transfer(model.getCustomers(), fullGeneral.getClients(), customer -> new ClientContractDetailsBigTableVM(), (customer, customerVM) -> {
            customerVM.setOrganizationText(customer.getCustomer() == null ? null : customer.getCustomer().toString());
            customerVM.setContractNumberText(customer.getNumber());
            customerVM.setIssueDate(DateUtils.asLocalDate((Date)customer.getIssueDate()));
            customerVM.setStartDate(DateUtils.asLocalDate((Date)customer.getStartDate()));
            customerVM.setEndDate(DateUtils.asLocalDate((Date)customer.getEndDate()));
            customerVM.getSuperColumn().getGeneralDetails().setOrganization(customer.getCustomer());
            customerVM.getSuperColumn().getGeneralDetails().setContractNumber(customer.getNumber());
            customerVM.getSuperColumn().getGeneralDetails().setIssueDate(DateUtils.asLocalDate((Date)customer.getIssueDate()));
            customerVM.getSuperColumn().getGeneralDetails().setStartDate(DateUtils.asLocalDate((Date)customer.getStartDate()));
            customerVM.getSuperColumn().getGeneralDetails().setEndDate(DateUtils.asLocalDate((Date)customer.getEndDate()));
            customerVM.getSuperColumn().getPaymentDetails().setTranslateSupplierFees(customer.isTranslateSupplierFees());
            customerVM.getSuperColumn().getPaymentDetails().setTourCode(customer.getTourCode());
            VMHelper.transfer(customer.getPaymentConditions().getPaymentItems(), customerVM.getSuperColumn().getPaymentDetails().getPaymentConditions(), payment -> new PaymentConditionVM(), (condition, conditionVM) -> {
                if (condition.getAppliedTo() != null) {
                    AppliedToVM appliedTo = new AppliedToVM();
                    appliedTo.setAppliedTo(condition.getAppliedTo());
                    conditionVM.setAppliedTo(appliedTo);
                } else {
                    conditionVM.setAppliedTo(null);
                }
                conditionVM.setServicePaymentType(condition.getServicePaymentType());
                conditionVM.setServicePeriodicity(condition.getServicePeriodicity());
                conditionVM.setServicePaymentTime(condition.getServicePaymentTime());
                conditionVM.setFeePaymentType(condition.getFeePaymentType());
                conditionVM.setFeePeriodicity(condition.getFeePeriodicity());
                conditionVM.setFeePaymentTime(condition.getFeePaymentTime());
                conditionVM.setFeeSeparately(condition.isFeeSeparately());
                conditionVM.setPaymentTypeByDefault(condition.isPaymentTypeByDefault());
                conditionVM.setSabreRemark(condition.getSabreRemark());
            });
            customerVM.getSuperColumn().getCurrencyDetails().setPaymentCurrency(customer.getPaymentCurrency());
            VMHelper.transfer(customer.getExchangeRateConditions(), customerVM.getSuperColumn().getCurrencyDetails().getCurrencyRates(), currencyDetail -> new CurrencyRateVM(), (currencyDetail, currencyVM) -> {
                currencyVM.setRateType(currencyDetail.getRateType());
                currencyVM.setCoefficient(currencyDetail.getCoefficient());
                currencyVM.setRoundingMode(currencyDetail.getRoundingMode());
                currencyVM.setRoundingValue(currencyDetail.getRoundingValue());
                currencyVM.setRateRoundingMode(currencyDetail.getRateRoundingMode());
                currencyVM.setRateRoundingValue(currencyDetail.getRateRoundingValue());
                currencyVM.setIndirectRateFirst(currencyDetail.isIndirectRateFirst());
                currencyVM.setIndirectRateRoundingType(currencyDetail.getIndirectRateRoundingType());
                currencyVM.setStartDate(DateUtils.asLocalDate((Date)currencyDetail.getStartDate()));
                currencyVM.setEndDate(DateUtils.asLocalDate((Date)currencyDetail.getEndDate()));
            });
        });
    }

    static void fromVM(ClientContractMainFullPanelVM fullGeneral, Contract model) {
        model.setName(fullGeneral.getClientContract().getName());
        model.setSupplier(fullGeneral.getClientContract().getSupplier());
        model.setTypicalContract(fullGeneral.getClientContract().isTypicalContract());
        model.setPriority(fullGeneral.getClientContract().getPriority());
        VMHelper.transfer(fullGeneral.getClients(), model.getCustomers(), customerVM -> new ContractCustomerInfo(), (customerVM, customer) -> {
            customer.setCustomer(customerVM.getSuperColumn().getGeneralDetails().getOrganization());
            customer.setNumber(customerVM.getSuperColumn().getGeneralDetails().getContractNumber());
            customer.setIssueDate(DateUtils.asDate((LocalDate)customerVM.getSuperColumn().getGeneralDetails().getIssueDate()));
            customer.setStartDate(DateUtils.asDate((LocalDate)customerVM.getSuperColumn().getGeneralDetails().getStartDate()));
            customer.setEndDate(DateUtils.asDate((LocalDate)customerVM.getSuperColumn().getGeneralDetails().getEndDate()));
            customer.setTranslateSupplierFees(customerVM.getSuperColumn().getPaymentDetails().isTranslateSupplierFees());
            customer.setTourCode(customerVM.getSuperColumn().getPaymentDetails().getTourCode());
            VMHelper.transfer(customerVM.getSuperColumn().getPaymentDetails().getPaymentConditions(), customer.getPaymentConditions().getPaymentItems(), conditionVM -> new PaymentConditionItem(), (conditionVM, condition) -> {
                condition.setAppliedTo(conditionVM.getAppliedTo() == null ? null : conditionVM.getAppliedTo().getAppliedTo());
                condition.setServicePaymentType(conditionVM.getServicePaymentType());
                condition.setServicePeriodicity(conditionVM.getServicePeriodicity());
                condition.setServicePaymentTime(conditionVM.getServicePaymentTime());
                condition.setFeePaymentType(conditionVM.getFeePaymentType());
                condition.setFeePeriodicity(conditionVM.getFeePeriodicity());
                condition.setFeePaymentTime(conditionVM.getFeePaymentTime());
                condition.setFeeSeparately(conditionVM.isFeeSeparately());
                condition.setPaymentTypeByDefault(conditionVM.isPaymentTypeByDefault());
                condition.setSabreRemark(conditionVM.getSabreRemark());
            });
            customer.setPaymentCurrency(customerVM.getSuperColumn().getCurrencyDetails().getPaymentCurrency());
            VMHelper.transfer(customerVM.getSuperColumn().getCurrencyDetails().getCurrencyRates(), customer.getExchangeRateConditions(), currencyVM -> new ExchangeRateCondition(), (currencyVM, currency) -> {
                currency.setRateType(currencyVM.getRateType());
                currency.setCoefficient(currencyVM.getCoefficient());
                currency.setRoundingMode(currencyVM.getRoundingMode());
                currency.setRoundingValue(currencyVM.getRoundingValue());
                currency.setRateRoundingMode(currencyVM.getRateRoundingMode());
                currency.setRateRoundingValue(currencyVM.getRateRoundingValue());
                currency.setIndirectRateFirst(currencyVM.isIndirectRateFirst());
                currency.setIndirectRateRoundingType(currencyVM.getIndirectRateRoundingType());
                currency.setStartDate(DateUtils.asDate((LocalDate)currencyVM.getStartDate()));
                currency.setEndDate(DateUtils.asDate((LocalDate)currencyVM.getEndDate()));
            });
        });
    }
}

