/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.AppliedToVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRateVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRatesDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedClientContractDetailsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedClientContractMainFullGridPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedClientContractMainFullPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBankAccountVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionsDetailsVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.ModelContractsTileHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;

final class ExtendedClientContractTileHelper {
    private ExtendedClientContractTileHelper() {
    }

    static void toVM(Contract model, ContractSpaceVM contractSpaceVM) {
        ExtendedClientContractMainFullPanelVM panelVM = contractSpaceVM.getExtendedClientContractFull();
        ExtendedClientContractDetailsFullContainerVM detailsVM = contractSpaceVM.getExtendedClientContractDetailsFull();
        ExtendedClientContractMainFullGridPanelVM clientVM = panelVM.getClientContract();
        clientVM.setName(model.getName());
        clientVM.setSupplier(model.getSupplier());
        clientVM.setDefaultContract(model.isDefaultContract());
        clientVM.setContractNumber(model.getNumber());
        clientVM.setOrganization(model.getCustomer());
        clientVM.setIssueDate(DateUtils.asLocalDate((Date)model.getIssueDate()));
        clientVM.setStartDate(DateUtils.asLocalDate((Date)model.getStartDate()));
        clientVM.setEndDate(DateUtils.asLocalDate((Date)model.getEndDate()));
        clientVM.setAgreementType(model.getAgreementType());
        clientVM.setVatExemption(model.isVATExemption());
        PaymentConditionsDetailsVM paymentDetailsVM = detailsVM.getContent().getPaymentDetails();
        paymentDetailsVM.setTourCode(model.getTourCode());
        VMHelper.transfer(model.getPaymentConditions().getPaymentItems(), paymentDetailsVM.getPaymentConditions(), payment -> new PaymentConditionVM(), (condition, conditionVM) -> {
            if (condition.getAppliedTo() != null) {
                AppliedToVM appliedTo = new AppliedToVM();
                appliedTo.setAppliedTo(condition.getAppliedTo());
                conditionVM.setAppliedTo(appliedTo);
            } else {
                conditionVM.setAppliedTo(null);
            }
            conditionVM.setServicePaymentType(condition.getServicePaymentType());
            conditionVM.setServicePeriodicity(condition.getServicePeriodicity());
            conditionVM.setServicePaymentTime(condition.getServicePaymentTime());
            conditionVM.setFeePaymentType(condition.getFeePaymentType());
            conditionVM.setFeePeriodicity(condition.getFeePeriodicity());
            conditionVM.setFeePaymentTime(condition.getFeePaymentTime());
            conditionVM.setFeeSeparately(condition.isFeeSeparately());
            conditionVM.setPaymentTypeByDefault(condition.isPaymentTypeByDefault());
            conditionVM.setSabreRemark(condition.getSabreRemark());
        });
        CurrencyRatesDetailsVM currencyDetailsVM = detailsVM.getContent().getCurrencyDetails();
        currencyDetailsVM.setPaymentCurrency(model.getPaymentCurrency());
        VMHelper.transfer(model.getExchangeRateConditions(), currencyDetailsVM.getCurrencyRates(), currencyDetail -> new CurrencyRateVM(), (currencyDetail, currencyVM) -> {
            currencyVM.setRateType(currencyDetail.getRateType());
            currencyVM.setCoefficient(currencyDetail.getCoefficient());
            currencyVM.setRoundingMode(currencyDetail.getRoundingMode());
            currencyVM.setRoundingValue(currencyDetail.getRoundingValue());
            currencyVM.setRateRoundingMode(currencyDetail.getRateRoundingMode());
            currencyVM.setRateRoundingValue(currencyDetail.getRateRoundingValue());
            currencyVM.setIndirectRateFirst(currencyDetail.isIndirectRateFirst());
            currencyVM.setIndirectRateRoundingType(currencyDetail.getIndirectRateRoundingType());
            currencyVM.setStartDate(DateUtils.asLocalDate((Date)currencyDetail.getStartDate()));
            currencyVM.setEndDate(DateUtils.asLocalDate((Date)currencyDetail.getEndDate()));
        });
        OrganizationBankAccountVM bankAccountVM = new OrganizationBankAccountVM();
        bankAccountVM.setBankAccount(model.getBankAccount());
        detailsVM.getContent().getBankAccountDetails().setBankAccount(bankAccountVM);
        OrganizationBankAccountVM clientBankAccountVM = new OrganizationBankAccountVM();
        clientBankAccountVM.setBankAccount(model.getClientBankAccount());
        detailsVM.getContent().getClientBankAccountDetails().setClientBankAccount(clientBankAccountVM);
        ModelContractsTileHelper.toVM(model, contractSpaceVM.getModelContractsFull());
    }

    static void fromVM(ContractSpaceVM contractSpaceVM, Contract model) {
        ExtendedClientContractMainFullPanelVM panelVM = contractSpaceVM.getExtendedClientContractFull();
        ExtendedClientContractDetailsFullContainerVM detailsVM = contractSpaceVM.getExtendedClientContractDetailsFull();
        ExtendedClientContractMainFullGridPanelVM clientVM = panelVM.getClientContract();
        model.setName(clientVM.getName());
        model.setSupplier(clientVM.getSupplier());
        model.setDefaultContract(clientVM.isDefaultContract());
        model.setNumber(clientVM.getContractNumber());
        model.setCustomer(clientVM.getOrganization());
        model.setIssueDate(DateUtils.asDate((LocalDate)clientVM.getIssueDate()));
        model.setStartDate(DateUtils.asDate((LocalDate)clientVM.getStartDate()));
        model.setEndDate(DateUtils.asDate((LocalDate)clientVM.getEndDate()));
        model.setAgreementType(clientVM.getAgreementType());
        model.setVATExemption(clientVM.isVatExemption());
        PaymentConditionsDetailsVM paymentDetailsVM = detailsVM.getContent().getPaymentDetails();
        model.setTourCode(paymentDetailsVM.getTourCode());
        VMHelper.transfer(paymentDetailsVM.getPaymentConditions(), model.getPaymentConditions().getPaymentItems(), conditionVM -> new PaymentConditionItem(), (conditionVM, condition) -> {
            condition.setAppliedTo(conditionVM.getAppliedTo() == null ? null : conditionVM.getAppliedTo().getAppliedTo());
            condition.setServicePaymentType(conditionVM.getServicePaymentType());
            condition.setServicePeriodicity(conditionVM.getServicePeriodicity());
            condition.setServicePaymentTime(conditionVM.getServicePaymentTime());
            condition.setFeePaymentType(conditionVM.getFeePaymentType());
            condition.setFeePeriodicity(conditionVM.getFeePeriodicity());
            condition.setFeePaymentTime(conditionVM.getFeePaymentTime());
            condition.setFeeSeparately(conditionVM.isFeeSeparately());
            condition.setPaymentTypeByDefault(conditionVM.isPaymentTypeByDefault());
            condition.setSabreRemark(conditionVM.getSabreRemark());
        });
        CurrencyRatesDetailsVM currencyDetailsVM = detailsVM.getContent().getCurrencyDetails();
        model.setPaymentCurrency(currencyDetailsVM.getPaymentCurrency());
        VMHelper.transfer(currencyDetailsVM.getCurrencyRates(), model.getExchangeRateConditions(), currencyVM -> new ExchangeRateCondition(), (currencyVM, currency) -> {
            currency.setRateType(currencyVM.getRateType());
            currency.setCoefficient(currencyVM.getCoefficient());
            currency.setRoundingMode(currencyVM.getRoundingMode());
            currency.setRoundingValue(currencyVM.getRoundingValue());
            currency.setRateRoundingMode(currencyVM.getRateRoundingMode());
            currency.setRateRoundingValue(currencyVM.getRateRoundingValue());
            currency.setIndirectRateFirst(currencyVM.isIndirectRateFirst());
            currency.setIndirectRateRoundingType(currencyVM.getIndirectRateRoundingType());
            currency.setStartDate(DateUtils.asDate((LocalDate)currencyVM.getStartDate()));
            currency.setEndDate(DateUtils.asDate((LocalDate)currencyVM.getEndDate()));
        });
        model.setBankAccount((BankAccount)Optional.ofNullable(detailsVM.getContent().getBankAccountDetails().getBankAccount()).map(OrganizationBankAccountVM::getBankAccount).orElse(null));
        model.setClientBankAccount((BankAccount)Optional.ofNullable(detailsVM.getContent().getClientBankAccountDetails().getClientBankAccount()).map(OrganizationBankAccountVM::getBankAccount).orElse(null));
        ModelContractsTileHelper.fromVM(contractSpaceVM.getModelContractsFull(), model);
    }
}

