/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.AppliedToVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRateVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRatesDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSubAgencyContractDetailsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSubAgencyContractMainFullGridPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSubAgencyContractMainFullPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBankAccountVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionsDetailsVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.ModelContractsTileHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;

final class ExtendedSubagencyContractTileHelper {
    private ExtendedSubagencyContractTileHelper() {
    }

    static void toVM(Contract model, ContractSpaceVM contractSpaceVM) {
        ExtendedSubAgencyContractMainFullPanelVM panelVM = contractSpaceVM.getExtendedSubAgencyContractFull();
        ExtendedSubAgencyContractDetailsFullContainerVM detailsVM = contractSpaceVM.getExtendedSubAgencyContractDetailsFull();
        ExtendedSubAgencyContractMainFullGridPanelVM subAgencyVM = panelVM.getSubagencyContract();
        subAgencyVM.setName(model.getName());
        subAgencyVM.setVendor(model.getVendor());
        subAgencyVM.setSupplier(model.getSupplier());
        subAgencyVM.setDefaultContract(model.isDefaultContract());
        subAgencyVM.setContractNumber(model.getNumber());
        subAgencyVM.setOrganization(model.getCustomer());
        subAgencyVM.setIssueDate(DateUtils.asLocalDate((Date)model.getIssueDate()));
        subAgencyVM.setStartDate(DateUtils.asLocalDate((Date)model.getStartDate()));
        subAgencyVM.setEndDate(DateUtils.asLocalDate((Date)model.getEndDate()));
        subAgencyVM.setAgreementType(model.getAgreementType());
        subAgencyVM.setVatExemption(model.isVATExemption());
        PaymentConditionsDetailsVM paymentDetailsVM = detailsVM.getContent().getPaymentDetails();
        VMHelper.transfer(model.getPaymentConditions().getPaymentItems(), paymentDetailsVM.getPaymentConditions(), payment -> new PaymentConditionVM(), (condition, conditionVM) -> {
            if (condition.getAppliedTo() != null) {
                AppliedToVM appliedTo = new AppliedToVM();
                appliedTo.setAppliedTo(condition.getAppliedTo());
                conditionVM.setAppliedTo(appliedTo);
            } else {
                conditionVM.setAppliedTo(null);
            }
            conditionVM.setServicePaymentType(condition.getServicePaymentType());
            conditionVM.setServicePeriodicity(condition.getServicePeriodicity());
            conditionVM.setServicePaymentTime(condition.getServicePaymentTime());
            conditionVM.setFeePaymentType(condition.getFeePaymentType());
            conditionVM.setFeePeriodicity(condition.getFeePeriodicity());
            conditionVM.setFeePaymentTime(condition.getFeePaymentTime());
            conditionVM.setFeeSeparately(condition.isFeeSeparately());
            conditionVM.setPaymentTypeByDefault(condition.isPaymentTypeByDefault());
            conditionVM.setSabreRemark(condition.getSabreRemark());
        });
        CurrencyRatesDetailsVM currencyDetailsVM = detailsVM.getContent().getCurrencyDetails();
        currencyDetailsVM.setPaymentCurrency(model.getPaymentCurrency());
        VMHelper.transfer(model.getExchangeRateConditions(), currencyDetailsVM.getCurrencyRates(), currencyDetail -> new CurrencyRateVM(), (currencyDetail, currencyVM) -> {
            currencyVM.setRateType(currencyDetail.getRateType());
            currencyVM.setCoefficient(currencyDetail.getCoefficient());
            currencyVM.setRoundingMode(currencyDetail.getRoundingMode());
            currencyVM.setRoundingValue(currencyDetail.getRoundingValue());
            currencyVM.setRateRoundingMode(currencyDetail.getRateRoundingMode());
            currencyVM.setRateRoundingValue(currencyDetail.getRateRoundingValue());
            currencyVM.setIndirectRateFirst(currencyDetail.isIndirectRateFirst());
            currencyVM.setIndirectRateRoundingType(currencyDetail.getIndirectRateRoundingType());
            currencyVM.setStartDate(DateUtils.asLocalDate((Date)currencyDetail.getStartDate()));
            currencyVM.setEndDate(DateUtils.asLocalDate((Date)currencyDetail.getEndDate()));
        });
        OrganizationBankAccountVM bankAccountVM = new OrganizationBankAccountVM();
        bankAccountVM.setBankAccount(model.getBankAccount());
        detailsVM.getContent().getBankAccountDetails().setBankAccount(bankAccountVM);
        ModelContractsTileHelper.toVM(model, contractSpaceVM.getModelContractsFull());
    }

    static void fromVM(ContractSpaceVM contractSpaceVM, Contract model) {
        ExtendedSubAgencyContractMainFullPanelVM panelVM = contractSpaceVM.getExtendedSubAgencyContractFull();
        ExtendedSubAgencyContractDetailsFullContainerVM detailsVM = contractSpaceVM.getExtendedSubAgencyContractDetailsFull();
        ExtendedSubAgencyContractMainFullGridPanelVM subAgencyVM = panelVM.getSubagencyContract();
        model.setName(subAgencyVM.getName());
        model.setVendor(subAgencyVM.getVendor());
        model.setSupplier(subAgencyVM.getSupplier());
        model.setDefaultContract(subAgencyVM.isDefaultContract());
        model.setNumber(subAgencyVM.getContractNumber());
        model.setCustomer(subAgencyVM.getOrganization());
        model.setIssueDate(DateUtils.asDate((LocalDate)subAgencyVM.getIssueDate()));
        model.setStartDate(DateUtils.asDate((LocalDate)subAgencyVM.getStartDate()));
        model.setEndDate(DateUtils.asDate((LocalDate)subAgencyVM.getEndDate()));
        model.setAgreementType(subAgencyVM.getAgreementType());
        model.setVATExemption(subAgencyVM.isVatExemption());
        PaymentConditionsDetailsVM paymentDetailsVM = detailsVM.getContent().getPaymentDetails();
        VMHelper.transfer(paymentDetailsVM.getPaymentConditions(), model.getPaymentConditions().getPaymentItems(), conditionVM -> new PaymentConditionItem(), (conditionVM, condition) -> {
            condition.setAppliedTo(conditionVM.getAppliedTo() == null ? null : conditionVM.getAppliedTo().getAppliedTo());
            condition.setServicePaymentType(conditionVM.getServicePaymentType());
            condition.setServicePeriodicity(conditionVM.getServicePeriodicity());
            condition.setServicePaymentTime(conditionVM.getServicePaymentTime());
            condition.setFeePaymentType(conditionVM.getFeePaymentType());
            condition.setFeePeriodicity(conditionVM.getFeePeriodicity());
            condition.setFeePaymentTime(conditionVM.getFeePaymentTime());
            condition.setFeeSeparately(conditionVM.isFeeSeparately());
            condition.setPaymentTypeByDefault(conditionVM.isPaymentTypeByDefault());
            condition.setSabreRemark(conditionVM.getSabreRemark());
        });
        CurrencyRatesDetailsVM currencyDetailsVM = detailsVM.getContent().getCurrencyDetails();
        model.setPaymentCurrency(currencyDetailsVM.getPaymentCurrency());
        VMHelper.transfer(currencyDetailsVM.getCurrencyRates(), model.getExchangeRateConditions(), currencyVM -> new ExchangeRateCondition(), (currencyVM, currency) -> {
            currency.setRateType(currencyVM.getRateType());
            currency.setCoefficient(currencyVM.getCoefficient());
            currency.setRoundingMode(currencyVM.getRoundingMode());
            currency.setRoundingValue(currencyVM.getRoundingValue());
            currency.setRateRoundingMode(currencyVM.getRateRoundingMode());
            currency.setRateRoundingValue(currencyVM.getRateRoundingValue());
            currency.setIndirectRateFirst(currencyVM.isIndirectRateFirst());
            currency.setIndirectRateRoundingType(currencyVM.getIndirectRateRoundingType());
            currency.setStartDate(DateUtils.asDate((LocalDate)currencyVM.getStartDate()));
            currency.setEndDate(DateUtils.asDate((LocalDate)currencyVM.getEndDate()));
        });
        model.setBankAccount((BankAccount)Optional.ofNullable(detailsVM.getContent().getBankAccountDetails().getBankAccount()).map(OrganizationBankAccountVM::getBankAccount).orElse(null));
        ModelContractsTileHelper.fromVM(contractSpaceVM.getModelContractsFull(), model);
    }
}

