/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract;

import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.AppliedToVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRateVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsChildrenContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsNavigateContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsParentContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsQuotasTableItemVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractDetailsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractMainFullPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.TCHContractVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuota;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.profile.TchDirectContract;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;

class SupplierContractTileHelper {
    private SupplierContractTileHelper() {
    }

    static void toVM(Contract model, SupplierContractMainFullPanelVM fullGeneral, SupplierContractDetailsFullContainerVM fullDetails, SupplierContractApplicationsFullContainerVM fullApplications) {
        fullGeneral.getSupplierContract().setName(model.getName());
        fullGeneral.getSupplierContract().setVendor(model.getVendor());
        fullGeneral.getSupplierContract().setSupplier(model.getSupplier());
        fullGeneral.getSupplierContract().setTypicalContract(model.isTypicalContract());
        fullGeneral.getSupplierContract().setPriority(model.getPriority());
        fullGeneral.getSupplierContract().setHotelProvider(model.getProvider());
        VMHelper.transfer(model.getCustomers(), fullGeneral.getAgencies(), customer -> new ContractDetailsVM(), (customer, customerVM) -> {
            customerVM.setOrganization(customer.getCustomer());
            customerVM.setContractNumber(customer.getNumber());
            customerVM.setIssueDate(DateUtils.asLocalDate((Date)customer.getIssueDate()));
            customerVM.setStartDate(DateUtils.asLocalDate((Date)customer.getStartDate()));
            customerVM.setEndDate(DateUtils.asLocalDate((Date)customer.getEndDate()));
            customerVM.setVendorContractType(customer.getVendorContractType());
        });
        VMHelper.transfer(model.getCustomers(), fullDetails.getContent(), customer -> new ContractDetailsVM(), (customer, customerVM) -> {
            VMHelper.transfer(customer.getPaymentConditions().getPaymentItems(), customerVM.getPaymentDetails().getPaymentConditions(), condition -> new PaymentConditionVM(), (condition, conditionVM) -> {
                if (condition.getAppliedTo() != null) {
                    AppliedToVM appliedTo = new AppliedToVM();
                    appliedTo.setAppliedTo(condition.getAppliedTo());
                    conditionVM.setAppliedTo(appliedTo);
                } else {
                    conditionVM.setAppliedTo(null);
                }
                conditionVM.setServicePaymentType(condition.getServicePaymentType());
                conditionVM.setServicePeriodicity(condition.getServicePeriodicity());
                conditionVM.setServicePaymentTime(condition.getServicePaymentTime());
                conditionVM.setFeePaymentType(condition.getFeePaymentType());
                conditionVM.setFeePeriodicity(condition.getFeePeriodicity());
                conditionVM.setFeePaymentTime(condition.getFeePaymentTime());
                conditionVM.setFeeSeparately(condition.isFeeSeparately());
                conditionVM.setPaymentTypeByDefault(condition.isPaymentTypeByDefault());
                conditionVM.setSabreRemark(condition.getSabreRemark());
            });
            customerVM.getCurrencyDetails().setPaymentCurrency(customer.getPaymentCurrency());
            VMHelper.transfer(customer.getExchangeRateConditions(), customerVM.getCurrencyDetails().getCurrencyRates(), currency -> new CurrencyRateVM(), (currency, currencyVM) -> {
                currencyVM.setRateType(currency.getRateType());
                currencyVM.setCoefficient(currency.getCoefficient());
                currencyVM.setRoundingMode(currency.getRoundingMode());
                currencyVM.setRoundingValue(currency.getRoundingValue());
                currencyVM.setRateRoundingMode(currency.getRateRoundingMode());
                currencyVM.setRateRoundingValue(currency.getRateRoundingValue());
                currencyVM.setIndirectRateFirst(currency.isIndirectRateFirst());
                currencyVM.setIndirectRateRoundingType(currency.getIndirectRateRoundingType());
                currencyVM.setStartDate(DateUtils.asLocalDate((Date)currency.getStartDate()));
                currencyVM.setEndDate(DateUtils.asLocalDate((Date)currency.getEndDate()));
            });
            customerVM.getTchDetails().setLastTchNotificationDate(DateUtils.asLocalDate((Date)customer.getLastTchNotificationDate()));
            VMHelper.transfer(customer.getTchDirectContracts(), customerVM.getTchDetails().getTchContracts(), tch -> new TCHContractVM(), (tch, tchVM) -> {
                tchVM.setAirline(tch.getAirline());
                tchVM.setContractNumber(tch.getContractNumber());
                tchVM.setIssueDate(DateUtils.asLocalDate((Date)tch.getIssueDate()));
                tchVM.setStartDate(DateUtils.asLocalDate((Date)tch.getStartDate()));
                tchVM.setEndDate(DateUtils.asLocalDate((Date)tch.getEndDate()));
            });
        });
        VMHelper.transfer(model.getCustomers(), fullApplications.getContent(), customer -> new SupplierContractApplicationsNavigateContainerVM(), (customer, contractVM) -> customer.getAppendices().forEach(application -> {
            if (application instanceof SUBlockCharterAppendix) {
                SUBlockCharterAppendix app = (SUBlockCharterAppendix)application;
                SupplierContractApplicationsParentContainerVM parentAppVM = new SupplierContractApplicationsParentContainerVM();
                parentAppVM.setNumber(app.getNumber());
                parentAppVM.setItinerary(app.getItinerary());
                parentAppVM.setType(app.getType());
                parentAppVM.setCurrency(app.getCurrency());
                parentAppVM.setIssueDate(DateUtils.asLocalDate((Date)app.getIssueDate()));
                parentAppVM.setStartDate(DateUtils.asLocalDate((Date)app.getStartDate()));
                parentAppVM.setEndDate(DateUtils.asLocalDate((Date)app.getEndDate()));
                parentAppVM.setTariffCodes(app.getFareBasis());
                parentAppVM.setUid(app.getUid());
                contractVM.getContent().add(parentAppVM);
                app.getTariffs().forEach(tariff -> {
                    SupplierContractApplicationsChildrenContainerVM childAppVM = new SupplierContractApplicationsChildrenContainerVM();
                    childAppVM.getTariffs().setClassOfBooking(tariff.getClassOfBooking());
                    childAppVM.getTariffs().setOwAdultTariff(tariff.getOwAdultTariff());
                    childAppVM.getTariffs().setRtAdultTariff(tariff.getRtAdultTariff());
                    VMHelper.transfer(tariff.getQuotas(), childAppVM.getQuotas(), quota -> new SupplierContractApplicationsQuotasTableItemVM(), (quota, quotaVM) -> {
                        quotaVM.getFullData().setFlightNumber(quota.getFlightNumber());
                        quotaVM.getFullData().setFlightDate(DateUtils.asLocalDate((Date)quota.getFlightDate()));
                        quotaVM.getFullData().setQuota(quota.getQuota());
                        quotaVM.getFullData().setBackwardDirection(quota.isBackwardDirection());
                        quotaVM.setFlightNumber(quota.getFlightNumber());
                        quotaVM.setFlightDate(DateUtils.asLocalDate((Date)quota.getFlightDate()));
                        quotaVM.setQuota((String)StandardRenderers.NUMBER_INTEGRAL.apply((Object)quota.getQuota()));
                        quotaVM.setBackwardDirection((String)StandardRenderers.BOOLEAN.apply((Object)quota.isBackwardDirection()));
                    });
                    contractVM.getContent().add(childAppVM);
                });
            }
        }));
    }

    static void fromVM(SupplierContractMainFullPanelVM fullGeneral, SupplierContractDetailsFullContainerVM fullDetails, SupplierContractApplicationsFullContainerVM fullApplications, Contract model) {
        model.setName(fullGeneral.getSupplierContract().getName());
        model.setVendor(fullGeneral.getSupplierContract().getVendor());
        model.setSupplier(fullGeneral.getSupplierContract().getSupplier());
        model.setTypicalContract(fullGeneral.getSupplierContract().isTypicalContract());
        model.setPriority(fullGeneral.getSupplierContract().getPriority());
        model.setProvider(fullGeneral.getSupplierContract().getHotelProvider());
        for (int i = 0; i < fullGeneral.getAgencies().size(); ++i) {
            if (!TextUtil.equals((String)((ContractDetailsVM)fullGeneral.getAgencies().get(i)).getUid(), (String)((ContractDetailsVM)fullDetails.getContent().get(i)).getUid(), (boolean)false)) {
                ((ContractDetailsVM)fullDetails.getContent().get(i)).setUid(((ContractDetailsVM)fullGeneral.getAgencies().get(i)).getUid());
            }
            if (TextUtil.equals((String)((ContractDetailsVM)fullGeneral.getAgencies().get(i)).getUid(), (String)((SupplierContractApplicationsNavigateContainerVM)fullApplications.getContent().get(i)).getUid(), (boolean)false)) continue;
            ((SupplierContractApplicationsNavigateContainerVM)fullApplications.getContent().get(i)).setUid(((ContractDetailsVM)fullGeneral.getAgencies().get(i)).getUid());
        }
        VMHelper.transfer(fullGeneral.getAgencies(), model.getCustomers(), customerVM -> new ContractCustomerInfo(), (customerVM, customer) -> {
            customer.setCustomer(customerVM.getOrganization());
            customer.setNumber(customerVM.getContractNumber());
            customer.setIssueDate(DateUtils.asDate((LocalDate)customerVM.getIssueDate()));
            customer.setStartDate(DateUtils.asDate((LocalDate)customerVM.getStartDate()));
            customer.setEndDate(DateUtils.asDate((LocalDate)customerVM.getEndDate()));
            customer.setVendorContractType(customerVM.getVendorContractType());
        });
        VMHelper.transfer(fullDetails.getContent(), model.getCustomers(), customerVM -> new ContractCustomerInfo(), (customerVM, customer) -> {
            VMHelper.transfer(customerVM.getPaymentDetails().getPaymentConditions(), customer.getPaymentConditions().getPaymentItems(), conditionVM -> new PaymentConditionItem(), (conditionVM, condition) -> {
                condition.setAppliedTo(conditionVM.getAppliedTo() == null ? null : conditionVM.getAppliedTo().getAppliedTo());
                condition.setServicePaymentType(conditionVM.getServicePaymentType());
                condition.setServicePeriodicity(conditionVM.getServicePeriodicity());
                condition.setServicePaymentTime(conditionVM.getServicePaymentTime());
                condition.setFeePaymentType(conditionVM.getFeePaymentType());
                condition.setFeePeriodicity(conditionVM.getFeePeriodicity());
                condition.setFeePaymentTime(conditionVM.getFeePaymentTime());
                condition.setFeeSeparately(conditionVM.isFeeSeparately());
                condition.setPaymentTypeByDefault(conditionVM.isPaymentTypeByDefault());
                condition.setSabreRemark(conditionVM.getSabreRemark());
            });
            customer.setPaymentCurrency(customerVM.getCurrencyDetails().getPaymentCurrency());
            VMHelper.transfer(customerVM.getCurrencyDetails().getCurrencyRates(), customer.getExchangeRateConditions(), currencyVM -> new ExchangeRateCondition(), (currencyVM, currency) -> {
                currency.setRateType(currencyVM.getRateType());
                currency.setCoefficient(currencyVM.getCoefficient());
                currency.setRoundingMode(currencyVM.getRoundingMode());
                currency.setRoundingValue(currencyVM.getRoundingValue());
                currency.setRateRoundingMode(currencyVM.getRateRoundingMode());
                currency.setRateRoundingValue(currencyVM.getRateRoundingValue());
                currency.setIndirectRateFirst(currencyVM.isIndirectRateFirst());
                currency.setIndirectRateRoundingType(currencyVM.getIndirectRateRoundingType());
                currency.setStartDate(DateUtils.asDate((LocalDate)currencyVM.getStartDate()));
                currency.setEndDate(DateUtils.asDate((LocalDate)currencyVM.getEndDate()));
            });
            customer.setLastTchNotificationDate(DateUtils.asDate((LocalDate)customerVM.getTchDetails().getLastTchNotificationDate()));
            VMHelper.transfer(customerVM.getTchDetails().getTchContracts(), customer.getTchDirectContracts(), tchVM -> new TchDirectContract(), (tchVM, tch) -> {
                tch.setAirline(tchVM.getAirline());
                tch.setContractNumber(tchVM.getContractNumber());
                tch.setIssueDate(DateUtils.asDate((LocalDate)tchVM.getIssueDate()));
                tch.setStartDate(DateUtils.asDate((LocalDate)tchVM.getStartDate()));
                tch.setEndDate(DateUtils.asDate((LocalDate)tchVM.getEndDate()));
            });
        });
        VMHelper.transfer(fullApplications.getContent(), model.getCustomers(), contractVM -> new ContractCustomerInfo(), (contractVM, customer) -> {
            customer.getAppendices().clear();
            contractVM.getContent().forEach(view -> {
                if (view instanceof SupplierContractApplicationsParentContainerVM) {
                    SupplierContractApplicationsParentContainerVM parent = (SupplierContractApplicationsParentContainerVM)view;
                    SUBlockCharterAppendix application = new SUBlockCharterAppendix();
                    application.setNumber(parent.getNumber());
                    application.setItinerary(parent.getItinerary());
                    application.setType(parent.getType());
                    application.setCurrency(parent.getCurrency());
                    application.setIssueDate(DateUtils.asDate((LocalDate)parent.getIssueDate()));
                    application.setStartDate(DateUtils.asDate((LocalDate)parent.getStartDate()));
                    application.setEndDate(DateUtils.asDate((LocalDate)parent.getEndDate()));
                    application.setFareBasis(parent.getTariffCodes());
                    application.setUid(parent.getUid());
                    customer.getAppendices().add(application);
                } else if (view instanceof SupplierContractApplicationsChildrenContainerVM) {
                    SupplierContractApplicationsChildrenContainerVM child = (SupplierContractApplicationsChildrenContainerVM)view;
                    SUBlockCharterTariffInfo tariff = new SUBlockCharterTariffInfo();
                    tariff.setClassOfBooking(child.getTariffs().getClassOfBooking());
                    tariff.setOwAdultTariff(child.getTariffs().getOwAdultTariff());
                    tariff.setRtAdultTariff(child.getTariffs().getRtAdultTariff());
                    VMHelper.transfer(child.getQuotas(), tariff.getQuotas(), quotaVM -> new SUBlockCharterQuota(), (quotaVM, quota) -> {
                        quota.setFlightNumber(quotaVM.getFullData().getFlightNumber());
                        quota.setFlightDate(DateUtils.asDate((LocalDate)quotaVM.getFullData().getFlightDate()));
                        quota.setQuota(quotaVM.getFullData().getQuota());
                        quota.setBackwardDirection(quotaVM.getFullData().isBackwardDirection());
                    });
                    if (customer.getAppendices().size() > 0) {
                        ((SUBlockCharterAppendix)customer.getAppendices().get(customer.getAppendices().size() - 1)).getTariffs().add(tariff);
                    }
                }
            });
        });
    }
}

