/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ValueWrapper;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsBigTableSuperColumnVM;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractMainFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.action.AddClientContractActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.action.ConsumerActions;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;

enum ClientsContractMainTileActions implements TileAction<Node, ClientContractMainFullPanel>
{
    ADD_CLIENTS{

        public String getName(Tile<Node, ClientContractMainFullPanel> tile) {
            return Messages.Add_client;
        }

        public String getDescription(Tile<Node, ClientContractMainFullPanel> tile) {
            return Messages.Add_clients;
        }

        public double getWeight() {
            return 0.0;
        }

        public boolean isEnabled(Tile<Node, ClientContractMainFullPanel> tile) {
            return !ViewController.forView((Node)tile.getFullNode()).isReadonly();
        }

        public void execute(Control source, Tile<Node, ClientContractMainFullPanel> tile, boolean alt) {
            ConsumerActions actions = (ConsumerActions)ReflectionUtil.createBySystemPropertyName((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"client.fx.contract.action.add_client", null, AddClientContractActions::new);
            actions.accept(source, tile, alt);
        }
    }
    ,
    REPLACE_REQUISITES{
        private DateValueWidget startDateWidget;
        private DateValueWidget endDateWidget;
        private BooleanValueWidget replaceValue;
        private BooleanValueWidget replaceAllClient;
        private MultiEntityWidget<Organization> client;

        public String getName(Tile<Node, ClientContractMainFullPanel> tile) {
            return Messages.Edit_details;
        }

        public String getDescription(Tile<Node, ClientContractMainFullPanel> tile) {
            return Messages.Edit_details;
        }

        public double getWeight() {
            return 5.0;
        }

        public boolean isEnabled(Tile<Node, ClientContractMainFullPanel> tile) {
            return !ViewController.forView((Node)tile.getFullNode()).isReadonly();
        }

        public void execute(Control source, Tile<Node, ClientContractMainFullPanel> tile, boolean alt) {
            RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)tile.getFullNode());
            RootEntityPane.executeAsyncAction((RootEntityPane)rootEntityPane, () -> this.nextStep(source, tile, rootEntityPane));
        }

        private void nextStep(Control source, Tile<Node, ClientContractMainFullPanel> tile, RootEntityPane<Contract, ?> rootEntityPane) {
            try {
                FxUtil.waitForFxThread(() -> {
                    GridContainer pane = this.configureView(rootEntityPane);
                    VBox body = new VBox(new Node[]{pane});
                    Dialog dialog = new Dialog();
                    dialog.setTitle(Messages.Choose_clients).setBody((Node)body).setExpandToParent(false).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                        this.clearValidationMessages(body);
                        List<MessagePane> messages = this.validateData();
                        if (!messages.isEmpty()) {
                            messages.forEach(msg -> body.getChildren().add(0, msg));
                            return;
                        }
                        BigTableWidget bigTableWidget = (BigTableWidget)((ClientContractMainFullPanel)tile.getFullNode()).getClientsCard().getContent();
                        int size = bigTableWidget.getRowsCount();
                        LocalDate startDate = this.startDateWidget.getValue();
                        LocalDate endDate = this.endDateWidget.getValue();
                        for (int i = 0; i < size; ++i) {
                            ClientContractDetailsBigTableSuperColumnVM val = (ClientContractDetailsBigTableSuperColumnVM)((ValueWrapper)bigTableWidget.getCellValue(i, "superColumn")).getValue();
                            if (!this.replaceAllClient.getValue() && !this.client.getValues().contains((Object)val.getGeneralDetails().getOrganization())) continue;
                            if (endDate != null && bigTableWidget.getCellValue(i, "endDate").equals("")) {
                                bigTableWidget.setCellValue(i, "endDate", StandardRenderers.DATE.apply((Object)DateUtils.asDate((LocalDate)endDate)));
                                val.getGeneralDetails().setEndDate(endDate);
                            }
                            if (startDate == null || (bigTableWidget.getCellValue(i, "startDate").equals("") || !this.replaceValue.getValue()) && !bigTableWidget.getCellValue(i, "startDate").equals("")) continue;
                            bigTableWidget.setCellValue(i, "startDate", StandardRenderers.DATE.apply((Object)DateUtils.asDate((LocalDate)startDate)));
                            val.getGeneralDetails().setStartDate(startDate);
                        }
                        dialog.close();
                    }).show((Node)source);
                });
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }

        private void clearValidationMessages(VBox body) {
            body.getChildren().removeAll((Collection)body.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
        }

        private List<MessagePane> validateData() {
            ArrayList<MessagePane> msg = new ArrayList<MessagePane>();
            if (this.startDateWidget.getValue() == null && this.endDateWidget.getValue() == null) {
                msg.add(MessagePane.error((String)Messages.Specify_validity_period));
            }
            if (!this.replaceAllClient.getValue() && this.client.getValues().isEmpty()) {
                msg.add(MessagePane.error((String)Messages.Specify_clients));
            }
            return msg;
        }

        private GridContainer configureView(RootEntityPane<Contract, ?> rootEntityPane) {
            new GridContainer();
            GridContainer pane = new GridContainer();
            pane.setColumnsCount(3);
            this.startDateWidget = new DateValueWidget(false);
            GridCell startDateCell = new GridCell(Messages.Start_of_action, (Node)this.startDateWidget);
            this.endDateWidget = new DateValueWidget(false);
            GridCell endDateCell = new GridCell(Messages.End_of_action, (Node)this.endDateWidget);
            this.replaceValue = new BooleanValueWidget(false, false);
            GridCell replaceValueCell = new GridCell(Messages.Replace_value, (Node)this.replaceValue);
            replaceValueCell.setHelp(() -> new QuickHelp(Messages.Empty_field_message));
            this.client = new MultiEntityWidget(Organization.class, false);
            this.client.setItemsSupplier(() -> {
                ArrayList list = new ArrayList();
                ((Contract)rootEntityPane.getData().getContainer().getEntity()).getCustomers().forEach(customer -> list.add(customer.getCustomer()));
                return list;
            }, false);
            GridCell clientCell = new GridCell(Messages.Client, this.client);
            this.replaceAllClient = new BooleanValueWidget(false, false);
            this.replaceAllClient.valueProperty().addListener((obj, oldVal, newVal) -> clientCell.setHidden(newVal.booleanValue()));
            GridCell replaceAllClientCell = new GridCell(Messages.Apply_to_all_clients, (Node)this.replaceAllClient);
            pane.getCells().addAll((Object[])new GridCell[]{startDateCell, endDateCell, replaceValueCell, replaceAllClientCell, clientCell});
            return pane;
        }
    };

}

