/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractMainFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractMainFullPanelController;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.VBox;

enum SupplierContractMainTileActions implements TileAction<Node, SupplierContractMainFullPanel>
{
    ADD_AGENCIES{

        public String getName(Tile<Node, SupplierContractMainFullPanel> tile) {
            return Messages.Add_Agency;
        }

        public String getDescription(Tile<Node, SupplierContractMainFullPanel> tile) {
            return Messages.Add_few_agencies;
        }

        public double getWeight() {
            return 0.0;
        }

        public boolean isEnabled(Tile<Node, SupplierContractMainFullPanel> tile) {
            return !ViewController.forView((Node)tile.getFullNode()).isReadonly();
        }

        public void execute(Control source, Tile<Node, SupplierContractMainFullPanel> tile, boolean alt) {
            IndexListParameters<Organization, OrganizationIndex> parameters = ControllerInterceptorsHelper.getAgencies();
            IndexListPane<BaseEntity, EntityIndex<BaseEntity>> pane = new IndexListPane<BaseEntity, EntityIndex<BaseEntity>>(new ObservableMutex(), parameters, SelectionMode.MULTIPLE, false){

                protected void newConfigurationPopulated() {
                    super.newConfigurationPopulated();
                    this.getTableView().getColumns().add((Object)TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo((EntityReference)item.getSource())));
                }
            };
            new Dialog().setTitle(Messages.Choose_agency).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> 1.lambda$execute$1((IndexListPane)pane, tile), (BooleanExpression)pane.selectionPresentProperty()).show((Node)source);
        }

        private static /* synthetic */ void lambda$execute$1(IndexListPane pane, Tile tile) {
            List items = pane.getSelectedItems();
            if (items != null) {
                items.forEach(item -> {
                    ((TableWidget)((SupplierContractMainFullPanel)tile.getFullNode()).getAgenciesCard().getContent()).addRow(((TableWidget)((SupplierContractMainFullPanel)tile.getFullNode()).getAgenciesCard().getContent()).getRowsCount());
                    ((EntityBoxWidget)((EntityBoxWidgetColumn)((TableWidget)((SupplierContractMainFullPanel)tile.getFullNode()).getAgenciesCard().getContent()).getColumn("organization")).getWidget(((TableWidget)((SupplierContractMainFullPanel)tile.getFullNode()).getAgenciesCard().getContent()).getRowsCount() - 1)).valueProperty().set((Object)item.getSource());
                });
            }
        }
    }
    ,
    REPLACE_REQUISITES{
        private DateValueWidget startDateWidget;
        private DateValueWidget endDateWidget;
        private BooleanValueWidget replaceValue;
        private BooleanValueWidget replaceAllClient;
        private MultiEntityWidget<Organization> supplier;

        public String getName(Tile<Node, SupplierContractMainFullPanel> tile) {
            return Messages.Edit_details;
        }

        public String getDescription(Tile<Node, SupplierContractMainFullPanel> tile) {
            return Messages.Edit_details;
        }

        public double getWeight() {
            return 5.0;
        }

        public boolean isEnabled(Tile<Node, SupplierContractMainFullPanel> tile) {
            return !ViewController.forView((Node)tile.getFullNode()).isReadonly();
        }

        public void execute(Control source, Tile<Node, SupplierContractMainFullPanel> tile, boolean alt) {
            RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)tile.getFullNode());
            RootEntityPane.executeAsyncAction((RootEntityPane)rootEntityPane, () -> this.nextStep(source, tile, rootEntityPane));
        }

        private void nextStep(Control source, Tile<Node, SupplierContractMainFullPanel> tile, RootEntityPane<Contract, ?> rootEntityPane) {
            try {
                FxUtil.waitForFxThread(() -> {
                    GridContainer pane = this.configureView(rootEntityPane);
                    VBox body = new VBox(new Node[]{pane});
                    Dialog dialog = new Dialog();
                    dialog.setTitle(Messages.Choice_of_suppliers).setBody((Node)body).setExpandToParent(false).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                        this.clearValidationMessages(body);
                        List<MessagePane> messages = this.validateData();
                        if (!messages.isEmpty()) {
                            messages.forEach(msg -> body.getChildren().add(0, msg));
                            return;
                        }
                        LocalDate startDate = this.startDateWidget.getValue();
                        LocalDate endDate = this.endDateWidget.getValue();
                        TableWidget tableWidget = (TableWidget)((SupplierContractMainFullPanel)tile.getFullNode()).getAgenciesCard().getContent();
                        Collection model = tableWidget.getRowsData();
                        tableWidget.getRowsData().stream().filter(vm -> this.replaceAllClient.getValue() || this.supplier.getValues().contains((Object)vm.getOrganization())).forEach(vm -> {
                            if (endDate != null && vm.getEndDate() == null) {
                                vm.setEndDate(endDate);
                            }
                            if (startDate == null) {
                                return;
                            }
                            if (vm.getStartDate() != null && this.replaceValue.getValue() || vm.getStartDate() == null) {
                                vm.setStartDate(startDate);
                            }
                        });
                        ((SupplierContractMainFullPanelController)ViewController.forView((Node)tile.getFullNode())).getAgencies().readData((Object)model);
                        dialog.close();
                    }).show((Node)source);
                });
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }

        private void clearValidationMessages(VBox body) {
            body.getChildren().removeAll((Collection)body.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
        }

        private List<MessagePane> validateData() {
            ArrayList<MessagePane> msg = new ArrayList<MessagePane>();
            if (this.startDateWidget.getValue() == null && this.endDateWidget.getValue() == null) {
                msg.add(MessagePane.error((String)Messages.Specify_validity_period));
            }
            if (!this.replaceAllClient.getValue() && this.supplier.getValues().isEmpty()) {
                msg.add(MessagePane.error((String)Messages.Specify_clients));
            }
            return msg;
        }

        private GridContainer configureView(RootEntityPane<Contract, ?> rootEntityPane) {
            new GridContainer();
            GridContainer pane = new GridContainer();
            pane.setColumnsCount(3);
            this.startDateWidget = new DateValueWidget(false);
            GridCell startDateCell = new GridCell(Messages.Start_of_action, (Node)this.startDateWidget);
            this.endDateWidget = new DateValueWidget(false);
            GridCell endDateCell = new GridCell(Messages.End_of_action, (Node)this.endDateWidget);
            this.replaceValue = new BooleanValueWidget(false, false);
            GridCell replaceValueCell = new GridCell(Messages.Replace_value, (Node)this.replaceValue);
            replaceValueCell.setHelp(() -> new QuickHelp(Messages.Empty_field_message));
            this.supplier = new MultiEntityWidget(Organization.class, false);
            this.supplier.setItemsSupplier(() -> {
                ArrayList list = new ArrayList();
                ((Contract)rootEntityPane.getData().getContainer().getEntity()).getCustomers().forEach(customer -> list.add(customer.getCustomer()));
                return list;
            }, false);
            GridCell clientCell = new GridCell(Messages.Client, this.supplier);
            this.replaceAllClient = new BooleanValueWidget(false, false);
            this.replaceAllClient.valueProperty().addListener((obj, oldVal, newVal) -> clientCell.setHidden(newVal.booleanValue()));
            GridCell replaceAllClientCell = new GridCell(Messages.Apply_to_all_clients, (Node)this.replaceAllClient);
            pane.getCells().addAll((Object[])new GridCell[]{startDateCell, endDateCell, replaceValueCell, replaceAllClientCell, clientCell});
            return pane;
        }
    };

}

