/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.document;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.document.DocumentHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.document.StandardDocumentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.model.DocumentContainerVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.system.Document;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

class StandardDocumentHandlerConfigurator
implements DocumentHandlerConfigurator {
    StandardDocumentHandlerConfigurator() {
    }

    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<Document, Void>, DocumentContainerVM>> toVM, List<BiConsumer<DocumentContainerVM, DataTransferPackage<Document, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new StandardDocumentContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Document model = (Document)dtp.getContainer().getEntity();
            vm.setMultiOwner(model.isMultiOwner());
            vm.getMainSpecifications().setDocumentType(model.getType());
            vm.getMainSpecifications().setExternal(model.isExternal());
            vm.getMainSpecifications().setShowOnSite(!model.isDoNotShowOnSite());
            vm.getMainSpecifications().setName(model.getName());
            vm.setDescription(model.getDescription());
            vm.getMainSpecifications().setOwner(model.getOwner());
            VMHelper.transfer(model.getOwners().stream().map(e -> e).collect(Collectors.toList()), vm.getMainSpecifications().getOwners());
            vm.getMainSpecifications().setTitle(model.getTitle());
            RichData data = new RichData();
            data.setContent(model.getContent());
            data.setContentType(model.getContentType());
            if (data.getContentType() == null) {
                data.setContentType(RichContentHandler.guessContentType((String)model.getName()));
            }
            vm.setContents(data);
            vm.getMainSpecifications().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
        });
        fromVM.add((vm, dtp) -> {
            Document model = (Document)dtp.getContainer().getEntity();
            model.setType(vm.getMainSpecifications().getDocumentType());
            model.setExternal(vm.getMainSpecifications().isExternal());
            model.setDoNotShowOnSite(!vm.getMainSpecifications().isShowOnSite());
            model.setName(vm.getMainSpecifications().getName());
            model.setTitle(vm.getMainSpecifications().getTitle());
            model.setOwner(vm.getMainSpecifications().getOwner());
            VMHelper.transfer(vm.getMainSpecifications().getOwners(), model.getOwners());
            model.setDescription(vm.getDescription());
            model.setContentType(vm.getContents() == null ? null : vm.getContents().getContentType());
            model.setContent(vm.getContents() == null ? null : vm.getContents().getContent());
            model.setCreated(DateUtils.asDate((LocalDate)vm.getMainSpecifications().getCreated()));
        });
    }
}

