/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings;

import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExchangeDocumentXmlExportSettingsContainer;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExchangeDocumentXmlExportSettingsContainerController;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExchangeDocumentXmlExportSettingsContainerVM;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportSettingsGeneral;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsEditorHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.parsers.ParsersManagerActivityHandler;
import com.gridnine.xtrip.client.fx.standard.settings.model.FileConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.FtpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.HttpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.SftpConnectionSettingsModel;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import java.util.List;
import java.util.stream.Collectors;
import javafx.util.StringConverter;

class ExchangeDocumentXmlExportSettingsControllerInterceptor
extends ControllerInterceptor<ExchangeDocumentXmlExportSettingsContainerVM, ExchangeDocumentXmlExportSettingsContainerController> {
    ExchangeDocumentXmlExportSettingsControllerInterceptor() {
    }

    private static void hideConnectionCards(ExchangeDocumentXmlExportSettingsContainer view) {
        view.getCards().forEach(card -> card.setHidden(true));
        view.getCommonCard().setHidden(false);
        view.getSpecifiedCard().setHidden(false);
    }

    protected Class<ExchangeDocumentXmlExportSettingsContainerController> getControllerClass() {
        return ExchangeDocumentXmlExportSettingsContainerController.class;
    }

    protected void onCreate(ExchangeDocumentXmlExportSettingsContainerController controller) {
        ExchangeDocumentXmlExportSettingsContainer view = controller.getView();
        ExchangeDocumentXmlExportSettingsControllerInterceptor.hideConnectionCards(view);
        ComboBoxWidget connectionTypeNode = ((ExportSettingsGeneral)controller.getView().getCommonCard().getContent()).getConnectionTypeNode();
        connectionTypeNode.setNoNulls(true);
        connectionTypeNode.valueProperty().addListener((obj, o, newConnectionType) -> {
            ExchangeDocumentXmlExportSettingsControllerInterceptor.hideConnectionCards(view);
            if (newConnectionType != null) {
                switch (newConnectionType) {
                    case FTP: {
                        view.getFtpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case SFTP: {
                        view.getSftpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case HTTP: {
                        view.getHttpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case FILE: {
                        view.getFileConnectionSettingsCard().setHidden(false);
                    }
                }
            }
        });
        ((FileConnectionSettingsModel)view.getFileConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FILE));
        ((FtpConnectionSettingsModel)view.getFtpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FTP));
        ((SftpConnectionSettingsModel)view.getSftpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.SFTP));
        ((HttpConnectionSettingsModel)view.getHttpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.HTTP));
        Notifications.get().submitTask(() -> {
            List classes = ParsersManagerActivityHandler.getDocumentClasses().stream().map(Class::getName).filter(className -> !className.contains("Base") && !"com.gridnine.xtrip.common.parsers.model.MCOExchangeDocument".equals(className)).collect(Collectors.toList());
            FxUtil.submitToFxThread(() -> {
                controller.getSpecified().getView().getDocumentTypeExportSettingsNode().setItemsSupplier(() -> classes);
                controller.getSpecified().getView().getDocumentTypeExportSettingsNode().setConverter((StringConverter)new StringConverter<String>(){

                    public String toString(String className) {
                        return className != null ? ((EntityType)MetaRegistry.get().getEntities().get(className)).getDisplayName() : "";
                    }

                    public String fromString(String string) {
                        return null;
                    }
                });
            });
        }, Messages.Parsers_manager_load_document_classes);
        ((FileConnectionSettingsModel)view.getFileConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.ExchangeDocumentExportSettingsReferenceHelp));
        ((FtpConnectionSettingsModel)view.getFtpConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.ExchangeDocumentExportSettingsReferenceHelp));
        ((SftpConnectionSettingsModel)view.getSftpConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.ExchangeDocumentExportSettingsReferenceHelp));
        ((HttpConnectionSettingsModel)view.getHttpConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.ExchangeDocumentExportSettingsReferenceHelp));
    }
}

