/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportDocumentContainer;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportDocumentContainerController;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportDocumentContainerGeneral;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportDocumentContainerGeneralVM;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DialogHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.export.BasicExportSettingsIndex;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.export.ExportDocumentContainerAdditionalInfo;
import com.gridnine.xtrip.common.model.export.ExportDocumentContainerAdditionalInfoController;
import com.gridnine.xtrip.common.model.export.ExportDocumentContainerAdditionalInfoVM;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.export.ExportDocumentInfo;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javafx.scene.Node;
import org.apache.commons.lang.StringUtils;

public class ExportDocumentHandler
extends BaseRootEntityHandler<ExportDocument, Void, ExportDocumentContainerVM, ExportDocumentContainer> {
    private static final String EXPORT_DOCUMENT_INFO_TITLE = "EXPORT_DOCUMENT_INFO_TITLE";
    private static final String EXPORT_DOCUMENT_INFO_DESCRIPTION = "";
    private static final String EXPORT_DOCUMENT_INFO_DOCUMENT_TYPE = "EXPORT_DOCUMENT_INFO_DOCUMENT_TYPE";
    private static final ListItemStringConverter<ExportDocumentContainerAdditionalInfo> EXPORT_DOCUMENT_INFO_CONVERTER = (view, idx) -> {
        Object docType;
        Object description;
        String resultTitle = String.valueOf(idx);
        String resultDescription = EXPORT_DOCUMENT_INFO_DESCRIPTION;
        Object title = view.getProperties().get((Object)EXPORT_DOCUMENT_INFO_TITLE);
        if (title != null && StringUtils.isNotEmpty((String)title.toString())) {
            resultTitle = title.toString();
        }
        if ((description = view.getProperties().get((Object)EXPORT_DOCUMENT_INFO_DESCRIPTION)) != null && StringUtils.isNotEmpty((String)description.toString())) {
            resultDescription = description.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(resultTitle).append(": ").append(resultDescription);
        if (resultDescription.equals(EXPORT_DOCUMENT_INFO_DESCRIPTION) && (docType = view.getProperties().get((Object)EXPORT_DOCUMENT_INFO_DOCUMENT_TYPE)) != null) {
            sb.append(docType);
        }
        return sb.toString();
    };

    public Class<ExportDocument> getEntityClass() {
        return ExportDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return ExportDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ExportDocument, Void>, ExportDocumentContainerVM>> toVM, List<BiConsumer<ExportDocumentContainerVM, DataTransferPackage<ExportDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<ExportDocumentContainerVM, ExportDocumentContainerController>(){

            protected Class<ExportDocumentContainerController> getControllerClass() {
                return ExportDocumentContainerController.class;
            }

            protected void onCreate(ExportDocumentContainerController controller) {
                IndexListParameters parameters = new IndexListParameters();
                parameters.setIndexType(BasicExportSettingsIndex.class);
                ListParametersHelper.setFilters(parameters, BasicExportSettingsIndex.Property.commonSettings.name(), BasicExportSettingsIndex.Property.exportCategory.name(), BasicExportSettingsIndex.Property.connectionType.name());
                ListParametersHelper.setColumns(parameters, BasicExportSettingsIndex.Property.name.name(), BasicExportSettingsIndex.Property.commonSettings.name(), BasicExportSettingsIndex.Property.exportCategory.name(), BasicExportSettingsIndex.Property.connectionType.name());
                ((ExportDocumentContainerGeneral)controller.getView().getGeneralCard().getContent()).getExportSettingsNode().setListParametersSupplier(() -> parameters);
                ((CompactGroupsWidget)controller.getView().getInfoCard().getContent()).setConverter(EXPORT_DOCUMENT_INFO_CONVERTER);
                ((RichContentWidget)controller.getView().getContentCard().getContent()).setFileNameSupplier(() -> ((ExportDocumentContainerGeneral)controller.getView().getGeneralCard().getContent()).getFileNode().getValue());
            }

            protected void afterReadData(ExportDocumentContainerController controller, ExportDocumentContainerVM model) {
                ((ExportDocumentContainerGeneral)controller.getView().getGeneralCard().getContent()).getMessagesActionNode().setOnMouseClicked(e -> DialogHelper.showMessages((Node)controller.getView(), Messages.Messages, model.getMessages()));
            }
        });
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<ExportDocumentContainerAdditionalInfoVM, ExportDocumentContainerAdditionalInfoController>(){

            protected Class<ExportDocumentContainerAdditionalInfoController> getControllerClass() {
                return ExportDocumentContainerAdditionalInfoController.class;
            }

            protected void afterReadData(ExportDocumentContainerAdditionalInfoController controller, ExportDocumentContainerAdditionalInfoVM model) {
                controller.getView().getProperties().put((Object)ExportDocumentHandler.EXPORT_DOCUMENT_INFO_TITLE, (Object)model.getTitle());
                controller.getView().getProperties().put((Object)ExportDocumentHandler.EXPORT_DOCUMENT_INFO_DESCRIPTION, (Object)model.getDescription());
                controller.getView().getProperties().put((Object)ExportDocumentHandler.EXPORT_DOCUMENT_INFO_DOCUMENT_TYPE, (Object)model.getContent().getContentType());
            }
        });
        toVM.add((dtp, vm) -> {
            ExportDocument model = (ExportDocument)dtp.getContainer().getEntity();
            ExportDocumentContainerGeneralVM generalVM = vm.getGeneral();
            Map<MessageType, Long> messageCountMap = model.getMessages().stream().collect(Collectors.groupingBy(Message::getType, Collectors.counting()));
            VMHelper.transfer(model.getMessages(), vm.getMessages());
            generalVM.setStatus(model.getStatus());
            generalVM.setMessagesAction(messageCountMap.getOrDefault(MessageType.ERROR, 0L) > 0L ? Messages.Handler_Errors : (messageCountMap.getOrDefault(MessageType.WARNING, 0L) > 0L ? Messages.Warnings : Messages.No_errors));
            generalVM.setDescription(model.getDescription());
            generalVM.setFile(model.getFileName());
            generalVM.setExportSettings(model.getExportSettings());
            generalVM.setCreateDate(DateUtils.asLocalDateTime((Date)model.getCreateDate()));
            generalVM.setLastUploadDate(DateUtils.asLocalDateTime((Date)model.getLastCommunicationDate()));
            vm.setObject(model.getObject() == null ? null : this.buildRichData(model.getObject().getContent(), model.isNewFormat()));
            vm.setContent(this.buildRichData(model.getContent(), model.isNewFormat()));
            vm.setResponse(this.buildRichData(model.getResponse(), model.isNewFormat()));
            for (ExportDocumentInfo info : model.getInfo()) {
                ExportDocumentContainerAdditionalInfoVM infoVM = new ExportDocumentContainerAdditionalInfoVM();
                RichData richData = new RichData();
                richData.setContent(info.getContent() != null ? info.getContent().getData() : null);
                richData.setContentType(info.getContent() != null ? info.getContent().getContentType() : null);
                infoVM.setContent(richData);
                infoVM.setTitle(info.getTitle());
                infoVM.setDescription(info.getDescription());
                vm.getInfo().add(infoVM);
            }
        });
        fromVM.add((vm, dtp) -> {
            ExportDocument model = (ExportDocument)dtp.getContainer().getEntity();
            model.setStatus(vm.getGeneral().getStatus());
            model.setExportSettings(vm.getGeneral().getExportSettings());
        });
    }

    private RichData buildRichData(byte[] content, boolean newFormat) {
        if (content == null) {
            return null;
        }
        try {
            RichData result = new RichData();
            if (newFormat) {
                result.setContent(GZIPUtil.gunzip((byte[])content));
            } else {
                try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(content));){
                    if (zis.getNextEntry() != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IoUtil.copyStream((InputStream)zis, (OutputStream)baos, (int)256);
                        result.setContent(baos.toByteArray());
                    }
                }
            }
            result.setContentType(this.guessContentType(result.getContent()));
            return result;
        }
        catch (IOException ioe) {
            ErrorHandler.handle((Throwable)ioe);
            return null;
        }
    }

    private ContentType guessContentType(byte[] data) {
        if (data == null || data.length < 4) {
            return ContentType.BINARY;
        }
        char ch = data[0] == -2 && data[1] == -1 ? StandardCharsets.UTF_16BE.decode(ByteBuffer.wrap(data, 2, 2)).get() : (data[0] == -1 && data[1] == -2 ? StandardCharsets.UTF_16LE.decode(ByteBuffer.wrap(data, 2, 2)).get() : (data[0] == -17 && data[1] == -69 && data[2] == -65 ? (char)data[3] : (char)data[0]));
        return ch == '<' ? ContentType.XML : ContentType.BINARY;
    }

    @Override
    protected ViewController<ExportDocumentContainer, ExportDocumentContainerVM> createSpaceController(boolean readonly) {
        return new ExportDocumentContainerController(true);
    }

    @Override
    protected ExportDocumentContainerVM createVM() {
        return new ExportDocumentContainerVM();
    }
}

