/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.model.exportSettings.Connection;
import com.gridnine.xtrip.client.fx.model.exportSettings.ConnectionVM;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportSettingsContainerGeneral;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportSettingsContainerGeneralVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.connectionSettings.ConnectionSettingsHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.common.model.export.BaseCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.BasicCommonConnectionSettingsIndex;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import com.gridnine.xtrip.common.search.SearchCriterion;

public class ExportSettingsEditorHelper {
    public static <S extends BaseExportSettings> void toVM(S model, ExportSettingsContainerGeneralVM generalVM, ConnectionVM connectionSettingsVM) {
        BaseConnectionSettings connectionSettings = model.getConnectionSettings();
        if (connectionSettings != null) {
            ConnectionSettingsHandler<?> connectionSettingsHandler = ConnectionSettingsHandler.getForClass(connectionSettings.getClass());
            connectionSettingsHandler.toVM(connectionSettingsVM, connectionSettings);
            generalVM.setConnectionType(connectionSettingsHandler.getConnectionType());
        }
        generalVM.setName(model.getName());
        generalVM.setCreateDocs(model.isCreateDocuments());
        generalVM.setSendData(model.isSendData());
    }

    public static <S extends BaseExportSettings> void fromVM(S model, ExportSettingsContainerGeneralVM generalVM, ConnectionVM connectionSettingsVM) {
        ConnectionSettingsHandler<?> connectionSettingsHandler = ConnectionSettingsHandler.getForConnectionType(generalVM.getConnectionType());
        if (connectionSettingsHandler != null) {
            connectionSettingsHandler.fromVM(connectionSettingsVM, model);
        }
        model.setName(generalVM.getName());
        model.setCreateDocuments(generalVM.isCreateDocs());
        model.setSendData(generalVM.isSendData());
    }

    public static void setConnectionTypeListener(Card<ExportSettingsContainerGeneral> generalCard, Card<Connection> connectionSettingsCard) {
        ((ExportSettingsContainerGeneral)generalCard.getContent()).getConnectionTypeNode().valueProperty().addListener((obj, o, n) -> {
            ((Connection)connectionSettingsCard.getContent()).getLoginCell().setHidden(n == ConnectionType.FILE);
            ((Connection)connectionSettingsCard.getContent()).getPasswordCell().setHidden(n == ConnectionType.FILE);
            ((Connection)connectionSettingsCard.getContent()).getTlsEnabledCell().setHidden(n != ConnectionType.FTP);
            ((Connection)connectionSettingsCard.getContent()).getPassiveModeEnabledCell().setHidden(n != ConnectionType.FTP);
            ((Connection)connectionSettingsCard.getContent()).getKeyCell().setHidden(true);
        });
    }

    public static IndexListParameters<BaseCommonConnectionSettings, ?> filterConnectionsList(ConnectionType connectionType) {
        IndexListParameters<BaseCommonConnectionSettings, BasicCommonConnectionSettingsIndex> connectionSettings = ControllerInterceptorsHelper.getCommonConnectionSettings();
        connectionSettings.getSearchCriterions().add(SearchCriterion.eq((String)BasicCommonConnectionSettingsIndex.Property.connectionType.name(), (Object)connectionType));
        return connectionSettings;
    }

    protected ExportSettingsEditorHelper() {
    }
}

