/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportSettingsGeneral;
import com.gridnine.xtrip.client.fx.model.exportSettings.OrganizationXmlExportSettingsContainer;
import com.gridnine.xtrip.client.fx.model.exportSettings.OrganizationXmlExportSettingsContainerController;
import com.gridnine.xtrip.client.fx.model.exportSettings.OrganizationXmlExportSettingsContainerVM;
import com.gridnine.xtrip.client.fx.model.exportSettings.OrganizationXmlExportSettingsGeneral;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsEditorHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsListCreater;
import com.gridnine.xtrip.client.fx.standard.settings.model.FileConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.FtpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.HttpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.SftpConnectionSettingsModel;
import com.gridnine.xtrip.common.fx.model.export.TreeDataWrapper;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import java.util.function.Consumer;

class OrganizationXmlExportSettingsControllerInterceptor
extends ControllerInterceptor<OrganizationXmlExportSettingsContainerVM, OrganizationXmlExportSettingsContainerController> {
    private static final String rootEntityId = "com.gridnine.xtrip.common.model.export.profile.v2.OrganizationExport";

    OrganizationXmlExportSettingsControllerInterceptor() {
    }

    private static void hideConnectionCards(OrganizationXmlExportSettingsContainer view) {
        view.getCards().forEach(card -> card.setHidden(true));
        view.getCommonCard().setHidden(false);
        view.getSpecifiedCard().setHidden(false);
    }

    protected Class<OrganizationXmlExportSettingsContainerController> getControllerClass() {
        return OrganizationXmlExportSettingsContainerController.class;
    }

    protected void onCreate(OrganizationXmlExportSettingsContainerController controller) {
        OrganizationXmlExportSettingsContainer view = controller.getView();
        OrganizationXmlExportSettingsControllerInterceptor.hideConnectionCards(view);
        ComboBoxWidget connectionTypeNode = ((ExportSettingsGeneral)controller.getView().getCommonCard().getContent()).getConnectionTypeNode();
        connectionTypeNode.setNoNulls(true);
        connectionTypeNode.valueProperty().addListener((obj, o, newConnectionType) -> {
            OrganizationXmlExportSettingsControllerInterceptor.hideConnectionCards(view);
            if (newConnectionType != null) {
                switch (newConnectionType) {
                    case FTP: {
                        view.getFtpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case SFTP: {
                        view.getSftpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case HTTP: {
                        view.getHttpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case FILE: {
                        view.getFileConnectionSettingsCard().setHidden(false);
                    }
                }
            }
        });
        ((FileConnectionSettingsModel)view.getFileConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FILE));
        ((FtpConnectionSettingsModel)view.getFtpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FTP));
        ((SftpConnectionSettingsModel)view.getSftpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.SFTP));
        ((HttpConnectionSettingsModel)view.getHttpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.HTTP));
    }

    protected void afterReadData(final OrganizationXmlExportSettingsContainerController controller, final OrganizationXmlExportSettingsContainerVM model) {
        Consumer<TreeDataWrapper> cons = new Consumer<TreeDataWrapper>(){

            @Override
            public void accept(TreeDataWrapper wrapper) {
                ExportSettingsHelper.toTreeDataWrapper(wrapper, model.getSpecified().getRootExportSettings().getSettings());
                ((OrganizationXmlExportSettingsGeneral)controller.getView().getSpecifiedCard().getContent()).getRootExportSettingsNode().readData((Object)wrapper);
            }
        };
        ExportSettingsListCreater.getTreeData(rootEntityId, cons);
    }
}

