/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.connectionSettings;

import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.model.exportSettings.ConnectionVM;
import com.gridnine.xtrip.common.model.export.BaseConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.ConnectionType;

public interface ConnectionSettingsHandler<C extends BaseConnectionSettings>
extends RegistryItem<ConnectionSettingsHandler<?>> {
    public static final RegistryItemType<ConnectionSettingsHandler<?>> TYPE = new RegistryItemType("CONNECTION-SETTINGS-HANDLER");

    public static <C extends BaseConnectionSettings> ConnectionSettingsHandler<C> getForClass(Class<C> settingsClass) {
        String className = settingsClass.getName();
        for (ConnectionSettingsHandler handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getSettingsClass().getName().equals(className)) continue;
            return handler;
        }
        return null;
    }

    public static ConnectionSettingsHandler<?> getForConnectionType(ConnectionType connectionType) {
        for (ConnectionSettingsHandler handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (handler.getConnectionType() != connectionType) continue;
            return handler;
        }
        return null;
    }

    default public RegistryItemType<ConnectionSettingsHandler<?>> getType() {
        return TYPE;
    }

    default public String getId() {
        return this.getConnectionType().name();
    }

    public Class<C> getSettingsClass();

    public ConnectionType getConnectionType();

    public void toVM(ConnectionVM var1, C var2);

    public <S extends BaseExportSettings> void fromVM(ConnectionVM var1, S var2);
}

