/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.CreditBankTransferOrderCard;
import com.gridnine.xtrip.client.fx.model.profile.CreditBankTransferOrderCardController;
import com.gridnine.xtrip.client.fx.model.profile.CreditBankTransferOrderCardVM;
import com.gridnine.xtrip.client.fx.model.profile.CreditBankTransferOrderMainCardVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.CreditBankTransferOrderContollerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.CreditBankTransferOrder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class CreditBankTransferOrderHandler
extends BaseRootEntityHandler<CreditBankTransferOrder, Void, CreditBankTransferOrderCardVM, CreditBankTransferOrderCard> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<CreditBankTransferOrder, Void>, CreditBankTransferOrderCardVM>> toVM, List<BiConsumer<CreditBankTransferOrderCardVM, DataTransferPackage<CreditBankTransferOrder, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CreditBankTransferOrderContollerInterceptor());
        toVM.add((dtp, vm) -> {
            CreditBankTransferOrder model = (CreditBankTransferOrder)dtp.getContainer().getEntity();
            CreditBankTransferOrderMainCardVM mainFull = vm.getMainCard();
            mainFull.setName(model.getName());
            mainFull.setNumber(model.getNumber());
            mainFull.setOrganization(model.getOrganization());
            mainFull.setDate(DateUtils.asLocalDateTime((Date)model.getDate()));
            mainFull.setPayer(model.getPayer());
            mainFull.setTotalAmount(model.getTotalAmount());
            mainFull.setContract(model.getContract());
            mainFull.setIncomeDocNumber(model.getIncomeDocNumber());
            mainFull.setIncomeDocDate(DateUtils.asLocalDate((Date)model.getIncomeDocDate()));
            mainFull.setEndOfDecade(DateUtils.asLocalDate((Date)model.getVendorReportData().getEndOfDecade()));
            mainFull.setPaymentType(model.getVendorReportData().getPaymentType());
        });
        fromVM.add((vm, dtp) -> {
            CreditBankTransferOrder model = (CreditBankTransferOrder)dtp.getContainer().getEntity();
            CreditBankTransferOrderMainCardVM mainFull = vm.getMainCard();
            model.setName(mainFull.getName());
            model.setNumber(mainFull.getNumber());
            model.setOrganization(mainFull.getOrganization());
            model.setDate(DateUtils.asDate((LocalDateTime)mainFull.getDate()));
            model.setPayer(mainFull.getPayer());
            model.setTotalAmount(mainFull.getTotalAmount());
            model.setContract(mainFull.getContract());
            model.setIncomeDocNumber(mainFull.getIncomeDocNumber());
            model.setIncomeDocDate(DateUtils.asDate((LocalDate)mainFull.getIncomeDocDate()));
            model.getVendorReportData().setEndOfDecade(DateUtils.asDate((LocalDate)mainFull.getEndOfDecade()));
            model.getVendorReportData().setPaymentType(mainFull.getPaymentType());
        });
    }

    @Override
    protected ViewController<CreditBankTransferOrderCard, CreditBankTransferOrderCardVM> createSpaceController(boolean readonly) {
        return new CreditBankTransferOrderCardController(readonly);
    }

    @Override
    protected CreditBankTransferOrderCardVM createVM() {
        return new CreditBankTransferOrderCardVM();
    }

    public Class<CreditBankTransferOrder> getEntityClass() {
        return CreditBankTransferOrder.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicPaymentDocumentIndex.class;
    }
}

